package org.opentripplanner.graph_builder.module.configure;

import dagger.internal.DaggerGenerated;
import dagger.internal.DoubleCheck;
import dagger.internal.InstanceFactory;
import dagger.internal.Preconditions;
import dagger.internal.Provider;
import java.time.ZoneId;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.processing.Generated;
import org.opentripplanner.ext.dataoverlay.EdgeUpdaterModule;
import org.opentripplanner.ext.emission.EmissionRepository;
import org.opentripplanner.ext.emission.configure.EmissionGraphBuilderModule_ProvideEmissionModuleFactory;
import org.opentripplanner.ext.emission.internal.graphbuilder.EmissionGraphBuilder;
import org.opentripplanner.ext.flex.AreaStopsToVerticesMapper;
import org.opentripplanner.ext.stopconsolidation.StopConsolidationModule;
import org.opentripplanner.ext.stopconsolidation.StopConsolidationRepository;
import org.opentripplanner.ext.transferanalyzer.DirectTransferAnalyzer;
import org.opentripplanner.graph_builder.GraphBuilder;
import org.opentripplanner.graph_builder.GraphBuilderDataSources;
import org.opentripplanner.graph_builder.configure.GraphBuilderModule_ProvideGraphBuilderFactory;
import org.opentripplanner.graph_builder.issue.api.DataImportIssueStore;
import org.opentripplanner.graph_builder.issue.report.DataImportIssueReporter;
import org.opentripplanner.graph_builder.module.DirectTransferGenerator;
import org.opentripplanner.graph_builder.module.GraphCoherencyCheckerModule;
import org.opentripplanner.graph_builder.module.OsmBoardingLocationsModule;
import org.opentripplanner.graph_builder.module.RouteToCentroidStationIdsValidator;
import org.opentripplanner.graph_builder.module.StreetLinkerModule;
import org.opentripplanner.graph_builder.module.TimeZoneAdjusterModule;
import org.opentripplanner.graph_builder.module.TripPatternNamer;
import org.opentripplanner.graph_builder.module.TurnRestrictionModule;
import org.opentripplanner.graph_builder.module.geometry.CalculateWorldEnvelopeModule;
import org.opentripplanner.graph_builder.module.islandpruning.PruneIslands;
import org.opentripplanner.graph_builder.module.ned.ElevationModule;
import org.opentripplanner.graph_builder.module.osm.OsmModule;
import org.opentripplanner.gtfs.graphbuilder.GtfsModule;
import org.opentripplanner.netex.NetexModule;
import org.opentripplanner.routing.fares.FareServiceFactory;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.routing.linking.VertexLinker;
import org.opentripplanner.routing.linking.configure.VertexLinkerGraphBuildingModule_LinkerFactory;
import org.opentripplanner.service.osminfo.OsmInfoGraphBuildRepository;
import org.opentripplanner.service.osminfo.internal.DefaultOsmInfoGraphBuildService;
import org.opentripplanner.service.vehicleparking.VehicleParkingRepository;
import org.opentripplanner.service.worldenvelope.WorldEnvelopeRepository;
import org.opentripplanner.standalone.config.BuildConfig;
import org.opentripplanner.street.model.StreetLimitationParameters;
import org.opentripplanner.transit.service.TimetableRepository;

@DaggerGenerated
@Generated(
    value = "dagger.internal.codegen.ComponentProcessor",
    comments = "https://dagger.dev"
)
@SuppressWarnings({
    "unchecked",
    "rawtypes",
    "KotlinInternal",
    "KotlinInternalInJava",
    "cast",
    "deprecation",
    "nullness:initialization.field.uninitialized"
})
public final class DaggerGraphBuilderFactory {
  private DaggerGraphBuilderFactory() {
  }

  public static GraphBuilderFactory.Builder builder() {
    return new Builder();
  }

  private static final class Builder implements GraphBuilderFactory.Builder {
    private BuildConfig config;

    private Graph graph;

    private TimetableRepository timetableRepository;

    private OsmInfoGraphBuildRepository osmInfoGraphBuildRepository;

    private WorldEnvelopeRepository worldEnvelopeRepository;

    private StopConsolidationRepository stopConsolidationRepository;

    private VehicleParkingRepository vehicleParkingRepository;

    private FareServiceFactory fareServiceFactory;

    private StreetLimitationParameters streetLimitationParameters;

    private GraphBuilderDataSources dataSources;

    private ZoneId timeZoneId;

    private EmissionRepository emissionRepository;

    @Override
    public Builder config(BuildConfig config) {
      this.config = Preconditions.checkNotNull(config);
      return this;
    }

    @Override
    public Builder graph(Graph graph) {
      this.graph = Preconditions.checkNotNull(graph);
      return this;
    }

    @Override
    public Builder timetableRepository(TimetableRepository timetableRepository) {
      this.timetableRepository = Preconditions.checkNotNull(timetableRepository);
      return this;
    }

    @Override
    public Builder osmInfoGraphBuildRepository(
        OsmInfoGraphBuildRepository osmInfoGraphBuildRepository) {
      this.osmInfoGraphBuildRepository = Preconditions.checkNotNull(osmInfoGraphBuildRepository);
      return this;
    }

    @Override
    public Builder worldEnvelopeRepository(WorldEnvelopeRepository worldEnvelopeRepository) {
      this.worldEnvelopeRepository = Preconditions.checkNotNull(worldEnvelopeRepository);
      return this;
    }

    @Override
    public Builder stopConsolidationRepository(
        @Nullable StopConsolidationRepository stopConsolidationRepository) {
      this.stopConsolidationRepository = stopConsolidationRepository;
      return this;
    }

    @Override
    public Builder vehicleParkingRepository(VehicleParkingRepository parkingRepository) {
      this.vehicleParkingRepository = Preconditions.checkNotNull(parkingRepository);
      return this;
    }

    @Override
    public Builder fareServiceFactory(FareServiceFactory fareServiceFactory) {
      this.fareServiceFactory = Preconditions.checkNotNull(fareServiceFactory);
      return this;
    }

    @Override
    public Builder streetLimitationParameters(
        StreetLimitationParameters streetLimitationParameters) {
      this.streetLimitationParameters = Preconditions.checkNotNull(streetLimitationParameters);
      return this;
    }

    @Override
    public Builder dataSources(GraphBuilderDataSources graphBuilderDataSources) {
      this.dataSources = Preconditions.checkNotNull(graphBuilderDataSources);
      return this;
    }

    @Override
    public Builder timeZoneId(@Nullable ZoneId zoneId) {
      this.timeZoneId = zoneId;
      return this;
    }

    @Override
    public Builder emissionRepository(@Nullable EmissionRepository emissionRepository) {
      this.emissionRepository = emissionRepository;
      return this;
    }

    @Override
    public GraphBuilderFactory build() {
      Preconditions.checkBuilderRequirement(config, BuildConfig.class);
      Preconditions.checkBuilderRequirement(graph, Graph.class);
      Preconditions.checkBuilderRequirement(timetableRepository, TimetableRepository.class);
      Preconditions.checkBuilderRequirement(osmInfoGraphBuildRepository, OsmInfoGraphBuildRepository.class);
      Preconditions.checkBuilderRequirement(worldEnvelopeRepository, WorldEnvelopeRepository.class);
      Preconditions.checkBuilderRequirement(vehicleParkingRepository, VehicleParkingRepository.class);
      Preconditions.checkBuilderRequirement(fareServiceFactory, FareServiceFactory.class);
      Preconditions.checkBuilderRequirement(streetLimitationParameters, StreetLimitationParameters.class);
      Preconditions.checkBuilderRequirement(dataSources, GraphBuilderDataSources.class);
      return new GraphBuilderFactoryImpl(config, graph, timetableRepository, osmInfoGraphBuildRepository, worldEnvelopeRepository, stopConsolidationRepository, vehicleParkingRepository, fareServiceFactory, streetLimitationParameters, dataSources, timeZoneId, emissionRepository);
    }
  }

  private static final class GraphBuilderFactoryImpl implements GraphBuilderFactory {
    private final Graph graph;

    private final TimetableRepository timetableRepository;

    private final WorldEnvelopeRepository worldEnvelopeRepository;

    private final OsmInfoGraphBuildRepository osmInfoGraphBuildRepository;

    private final FareServiceFactory fareServiceFactory;

    private final GraphBuilderFactoryImpl graphBuilderFactoryImpl = this;

    Provider<GraphBuilderDataSources> dataSourcesProvider;

    Provider<BuildConfig> configProvider;

    Provider<DataImportIssueStore> provideDataImportIssuesStoreProvider;

    Provider<DataImportIssueReporter> provideDataImportIssuesToHTMLProvider;

    Provider<Graph> graphProvider;

    Provider<TimetableRepository> timetableRepositoryProvider;

    Provider<DirectTransferGenerator> provideDirectTransferGeneratorProvider;

    Provider<VertexLinker> linkerProvider;

    Provider<DirectTransferAnalyzer> provideDirectTransferAnalyzerProvider;

    Provider<GraphBuilder> provideGraphBuilderProvider;

    Provider<FareServiceFactory> fareServiceFactoryProvider;

    Provider<GtfsModule> provideGtfsModuleProvider;

    Provider<OsmInfoGraphBuildRepository> osmInfoGraphBuildRepositoryProvider;

    Provider<VehicleParkingRepository> vehicleParkingRepositoryProvider;

    Provider<StreetLimitationParameters> streetLimitationParametersProvider;

    Provider<OsmModule> provideOsmModuleProvider;

    Provider<List<ElevationModule>> provideElevationModulesProvider;

    Provider<NetexModule> provideNetexModuleProvider;

    Provider<PruneIslands> providePruneIslandsProvider;

    Provider<StreetLinkerModule> provideStreetLinkerModuleProvider;

    Provider<EdgeUpdaterModule> provideDataOverlayFactoryProvider;

    Provider<TurnRestrictionModule> provideTurnRestrictionModuleProvider;

    Provider<EmissionRepository> emissionRepositoryProvider;

    Provider<EmissionGraphBuilder> provideEmissionModuleProvider;

    Provider<RouteToCentroidStationIdsValidator> routeToCentroidStationIdValidatorProvider;

    Provider<StopConsolidationRepository> stopConsolidationRepositoryProvider;

    Provider<StopConsolidationModule> providesStopConsolidationModuleProvider;

    GraphBuilderFactoryImpl(BuildConfig configParam, Graph graphParam,
        TimetableRepository timetableRepositoryParam,
        OsmInfoGraphBuildRepository osmInfoGraphBuildRepositoryParam,
        WorldEnvelopeRepository worldEnvelopeRepositoryParam,
        StopConsolidationRepository stopConsolidationRepositoryParam,
        VehicleParkingRepository vehicleParkingRepositoryParam,
        FareServiceFactory fareServiceFactoryParam,
        StreetLimitationParameters streetLimitationParametersParam,
        GraphBuilderDataSources dataSourcesParam, ZoneId timeZoneIdParam,
        EmissionRepository emissionRepositoryParam) {
      this.graph = graphParam;
      this.timetableRepository = timetableRepositoryParam;
      this.worldEnvelopeRepository = worldEnvelopeRepositoryParam;
      this.osmInfoGraphBuildRepository = osmInfoGraphBuildRepositoryParam;
      this.fareServiceFactory = fareServiceFactoryParam;
      initialize(configParam, graphParam, timetableRepositoryParam, osmInfoGraphBuildRepositoryParam, worldEnvelopeRepositoryParam, stopConsolidationRepositoryParam, vehicleParkingRepositoryParam, fareServiceFactoryParam, streetLimitationParametersParam, dataSourcesParam, timeZoneIdParam, emissionRepositoryParam);
      initialize2(configParam, graphParam, timetableRepositoryParam, osmInfoGraphBuildRepositoryParam, worldEnvelopeRepositoryParam, stopConsolidationRepositoryParam, vehicleParkingRepositoryParam, fareServiceFactoryParam, streetLimitationParametersParam, dataSourcesParam, timeZoneIdParam, emissionRepositoryParam);

    }

    DefaultOsmInfoGraphBuildService defaultOsmInfoGraphBuildService() {
      return new DefaultOsmInfoGraphBuildService(osmInfoGraphBuildRepository);
    }

    @SuppressWarnings("unchecked")
    private void initialize(final BuildConfig configParam, final Graph graphParam,
        final TimetableRepository timetableRepositoryParam,
        final OsmInfoGraphBuildRepository osmInfoGraphBuildRepositoryParam,
        final WorldEnvelopeRepository worldEnvelopeRepositoryParam,
        final StopConsolidationRepository stopConsolidationRepositoryParam,
        final VehicleParkingRepository vehicleParkingRepositoryParam,
        final FareServiceFactory fareServiceFactoryParam,
        final StreetLimitationParameters streetLimitationParametersParam,
        final GraphBuilderDataSources dataSourcesParam, final ZoneId timeZoneIdParam,
        final EmissionRepository emissionRepositoryParam) {
      this.dataSourcesProvider = InstanceFactory.create(dataSourcesParam);
      this.configProvider = InstanceFactory.create(configParam);
      this.provideDataImportIssuesStoreProvider = DoubleCheck.provider(GraphBuilderModules_ProvideDataImportIssuesStoreFactory.create());
      this.provideDataImportIssuesToHTMLProvider = DoubleCheck.provider(GraphBuilderModules_ProvideDataImportIssuesToHTMLFactory.create(dataSourcesProvider, configProvider, provideDataImportIssuesStoreProvider));
      this.graphProvider = InstanceFactory.create(graphParam);
      this.timetableRepositoryProvider = InstanceFactory.create(timetableRepositoryParam);
      this.provideDirectTransferGeneratorProvider = DoubleCheck.provider(GraphBuilderModules_ProvideDirectTransferGeneratorFactory.create(configProvider, graphProvider, timetableRepositoryProvider, provideDataImportIssuesStoreProvider));
      this.linkerProvider = DoubleCheck.provider(VertexLinkerGraphBuildingModule_LinkerFactory.create(graphProvider, configProvider));
      this.provideDirectTransferAnalyzerProvider = DoubleCheck.provider(GraphBuilderModules_ProvideDirectTransferAnalyzerFactory.create(configProvider, graphProvider, linkerProvider, timetableRepositoryProvider, provideDataImportIssuesStoreProvider));
      this.provideGraphBuilderProvider = DoubleCheck.provider(GraphBuilderModule_ProvideGraphBuilderFactory.create(graphProvider, timetableRepositoryProvider, provideDataImportIssuesStoreProvider, dataSourcesProvider));
      this.fareServiceFactoryProvider = InstanceFactory.create(fareServiceFactoryParam);
      this.provideGtfsModuleProvider = DoubleCheck.provider(GraphBuilderModules_ProvideGtfsModuleFactory.create(dataSourcesProvider, configProvider, graphProvider, timetableRepositoryProvider, provideDataImportIssuesStoreProvider, fareServiceFactoryProvider));
      this.osmInfoGraphBuildRepositoryProvider = InstanceFactory.create(osmInfoGraphBuildRepositoryParam);
      this.vehicleParkingRepositoryProvider = InstanceFactory.create(vehicleParkingRepositoryParam);
      this.streetLimitationParametersProvider = InstanceFactory.create(streetLimitationParametersParam);
      this.provideOsmModuleProvider = DoubleCheck.provider(GraphBuilderModules_ProvideOsmModuleFactory.create(dataSourcesProvider, configProvider, graphProvider, osmInfoGraphBuildRepositoryProvider, vehicleParkingRepositoryProvider, provideDataImportIssuesStoreProvider, streetLimitationParametersProvider));
      this.provideElevationModulesProvider = DoubleCheck.provider(GraphBuilderModules_ProvideElevationModulesFactory.create(configProvider, dataSourcesProvider, graphProvider, provideOsmModuleProvider, provideDataImportIssuesStoreProvider));
      this.provideNetexModuleProvider = DoubleCheck.provider(GraphBuilderModules_ProvideNetexModuleFactory.create(dataSourcesProvider, configProvider, graphProvider, timetableRepositoryProvider, vehicleParkingRepositoryProvider, provideDataImportIssuesStoreProvider));
      this.providePruneIslandsProvider = DoubleCheck.provider(GraphBuilderModules_ProvidePruneIslandsFactory.create(configProvider, graphProvider, vehicleParkingRepositoryProvider, timetableRepositoryProvider, provideDataImportIssuesStoreProvider, linkerProvider));
      this.provideStreetLinkerModuleProvider = DoubleCheck.provider(GraphBuilderModules_ProvideStreetLinkerModuleFactory.create(graphProvider, vehicleParkingRepositoryProvider, timetableRepositoryProvider, provideDataImportIssuesStoreProvider, linkerProvider));
      this.provideDataOverlayFactoryProvider = DoubleCheck.provider(GraphBuilderModules_ProvideDataOverlayFactoryFactory.create(configProvider, graphProvider));
      this.provideTurnRestrictionModuleProvider = DoubleCheck.provider(GraphBuilderModules_ProvideTurnRestrictionModuleFactory.create(graphProvider, osmInfoGraphBuildRepositoryProvider));
      this.emissionRepositoryProvider = InstanceFactory.createNullable(emissionRepositoryParam);
      this.provideEmissionModuleProvider = DoubleCheck.provider(EmissionGraphBuilderModule_ProvideEmissionModuleFactory.create(dataSourcesProvider, configProvider, emissionRepositoryProvider, timetableRepositoryProvider, provideDataImportIssuesStoreProvider));
      this.routeToCentroidStationIdValidatorProvider = DoubleCheck.provider(GraphBuilderModules_RouteToCentroidStationIdValidatorFactory.create(provideDataImportIssuesStoreProvider, configProvider, timetableRepositoryProvider));
    }

    @SuppressWarnings("unchecked")
    private void initialize2(final BuildConfig configParam, final Graph graphParam,
        final TimetableRepository timetableRepositoryParam,
        final OsmInfoGraphBuildRepository osmInfoGraphBuildRepositoryParam,
        final WorldEnvelopeRepository worldEnvelopeRepositoryParam,
        final StopConsolidationRepository stopConsolidationRepositoryParam,
        final VehicleParkingRepository vehicleParkingRepositoryParam,
        final FareServiceFactory fareServiceFactoryParam,
        final StreetLimitationParameters streetLimitationParametersParam,
        final GraphBuilderDataSources dataSourcesParam, final ZoneId timeZoneIdParam,
        final EmissionRepository emissionRepositoryParam) {
      this.stopConsolidationRepositoryProvider = InstanceFactory.createNullable(stopConsolidationRepositoryParam);
      this.providesStopConsolidationModuleProvider = DoubleCheck.provider(GraphBuilderModules_ProvidesStopConsolidationModuleFactory.create(timetableRepositoryProvider, stopConsolidationRepositoryProvider, dataSourcesProvider));
    }

    @Override
    public AreaStopsToVerticesMapper areaStopsToVerticesMapper() {
      return new AreaStopsToVerticesMapper(graph, timetableRepository);
    }

    @Override
    public CalculateWorldEnvelopeModule calculateWorldEnvelopeModule() {
      return new CalculateWorldEnvelopeModule(graph, timetableRepository, worldEnvelopeRepository);
    }

    @Override
    public DataImportIssueReporter dataImportIssueReporter() {
      return provideDataImportIssuesToHTMLProvider.get();
    }

    @Override
    public DirectTransferGenerator directTransferGenerator() {
      return provideDirectTransferGeneratorProvider.get();
    }

    @Override
    public DirectTransferAnalyzer directTransferAnalyzer() {
      return provideDirectTransferAnalyzerProvider.get();
    }

    @Override
    public GraphCoherencyCheckerModule graphCoherencyCheckerModule() {
      return new GraphCoherencyCheckerModule(graph, provideDataImportIssuesStoreProvider.get());
    }

    @Override
    public GraphBuilder graphBuilder() {
      return provideGraphBuilderProvider.get();
    }

    @Override
    public GtfsModule gtfsModule() {
      return provideGtfsModuleProvider.get();
    }

    @Override
    public List<ElevationModule> elevationModules() {
      return provideElevationModulesProvider.get();
    }

    @Override
    public NetexModule netexModule() {
      return provideNetexModuleProvider.get();
    }

    @Override
    public OsmBoardingLocationsModule osmBoardingLocationsModule() {
      return new OsmBoardingLocationsModule(graph, linkerProvider.get(), defaultOsmInfoGraphBuildService());
    }

    @Override
    public OsmModule osmModule() {
      return provideOsmModuleProvider.get();
    }

    @Override
    public PruneIslands pruneIslands() {
      return providePruneIslandsProvider.get();
    }

    @Override
    public StreetLinkerModule streetLinkerModule() {
      return provideStreetLinkerModuleProvider.get();
    }

    @Override
    public TimeZoneAdjusterModule timeZoneAdjusterModule() {
      return new TimeZoneAdjusterModule(timetableRepository);
    }

    @Override
    public TripPatternNamer tripPatternNamer() {
      return new TripPatternNamer(timetableRepository);
    }

    @Override
    @Nullable
    public EdgeUpdaterModule dataOverlayFactory() {
      return provideDataOverlayFactoryProvider.get();
    }

    @Override
    public TurnRestrictionModule turnRestrictionModule() {
      return provideTurnRestrictionModuleProvider.get();
    }

    @Override
    @Nullable
    public EmissionGraphBuilder emissionGraphBuilder() {
      return provideEmissionModuleProvider.get();
    }

    @Override
    @Nullable
    public RouteToCentroidStationIdsValidator routeToCentroidStationIdValidator() {
      return routeToCentroidStationIdValidatorProvider.get();
    }

    @Override
    @Nullable
    public StopConsolidationModule stopConsolidationModule() {
      return providesStopConsolidationModuleProvider.get();
    }

    @Override
    public FareServiceFactory fareServiceFactory() {
      return fareServiceFactory;
    }

    @Override
    public VertexLinker vertexLinker() {
      return linkerProvider.get();
    }
  }
}
