package org.opentripplanner.graph_builder.module;

import dagger.internal.DaggerGenerated;
import dagger.internal.Factory;
import dagger.internal.Provider;
import dagger.internal.QualifierMetadata;
import dagger.internal.ScopeMetadata;
import javax.annotation.processing.Generated;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.routing.linking.VertexLinker;
import org.opentripplanner.service.osminfo.OsmInfoGraphBuildService;

@ScopeMetadata
@QualifierMetadata
@DaggerGenerated
@Generated(
    value = "dagger.internal.codegen.ComponentProcessor",
    comments = "https://dagger.dev"
)
@SuppressWarnings({
    "unchecked",
    "rawtypes",
    "KotlinInternal",
    "KotlinInternalInJava",
    "cast",
    "deprecation",
    "nullness:initialization.field.uninitialized"
})
public final class OsmBoardingLocationsModule_Factory implements Factory<OsmBoardingLocationsModule> {
  private final Provider<Graph> graphProvider;

  private final Provider<VertexLinker> linkerProvider;

  private final Provider<OsmInfoGraphBuildService> osmInfoGraphBuildServiceProvider;

  private OsmBoardingLocationsModule_Factory(Provider<Graph> graphProvider,
      Provider<VertexLinker> linkerProvider,
      Provider<OsmInfoGraphBuildService> osmInfoGraphBuildServiceProvider) {
    this.graphProvider = graphProvider;
    this.linkerProvider = linkerProvider;
    this.osmInfoGraphBuildServiceProvider = osmInfoGraphBuildServiceProvider;
  }

  @Override
  public OsmBoardingLocationsModule get() {
    return newInstance(graphProvider.get(), linkerProvider.get(), osmInfoGraphBuildServiceProvider.get());
  }

  public static OsmBoardingLocationsModule_Factory create(Provider<Graph> graphProvider,
      Provider<VertexLinker> linkerProvider,
      Provider<OsmInfoGraphBuildService> osmInfoGraphBuildServiceProvider) {
    return new OsmBoardingLocationsModule_Factory(graphProvider, linkerProvider, osmInfoGraphBuildServiceProvider);
  }

  public static OsmBoardingLocationsModule newInstance(Graph graph, VertexLinker linker,
      OsmInfoGraphBuildService osmInfoGraphBuildService) {
    return new OsmBoardingLocationsModule(graph, linker, osmInfoGraphBuildService);
  }
}
