package org.opentripplanner.graph_builder.configure;

import dagger.internal.DaggerGenerated;
import dagger.internal.Factory;
import dagger.internal.Preconditions;
import dagger.internal.Provider;
import dagger.internal.QualifierMetadata;
import dagger.internal.ScopeMetadata;
import javax.annotation.processing.Generated;
import org.opentripplanner.graph_builder.GraphBuilder;
import org.opentripplanner.graph_builder.GraphBuilderDataSources;
import org.opentripplanner.graph_builder.issue.api.DataImportIssueStore;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.transit.service.TimetableRepository;

@ScopeMetadata("jakarta.inject.Singleton")
@QualifierMetadata
@DaggerGenerated
@Generated(
    value = "dagger.internal.codegen.ComponentProcessor",
    comments = "https://dagger.dev"
)
@SuppressWarnings({
    "unchecked",
    "rawtypes",
    "KotlinInternal",
    "KotlinInternalInJava",
    "cast",
    "deprecation",
    "nullness:initialization.field.uninitialized"
})
public final class GraphBuilderModule_ProvideGraphBuilderFactory implements Factory<GraphBuilder> {
  private final Provider<Graph> baseGraphProvider;

  private final Provider<TimetableRepository> timetableRepositoryProvider;

  private final Provider<DataImportIssueStore> issueStoreProvider;

  private final Provider<GraphBuilderDataSources> closeDataSourcesHandleProvider;

  private GraphBuilderModule_ProvideGraphBuilderFactory(Provider<Graph> baseGraphProvider,
      Provider<TimetableRepository> timetableRepositoryProvider,
      Provider<DataImportIssueStore> issueStoreProvider,
      Provider<GraphBuilderDataSources> closeDataSourcesHandleProvider) {
    this.baseGraphProvider = baseGraphProvider;
    this.timetableRepositoryProvider = timetableRepositoryProvider;
    this.issueStoreProvider = issueStoreProvider;
    this.closeDataSourcesHandleProvider = closeDataSourcesHandleProvider;
  }

  @Override
  public GraphBuilder get() {
    return provideGraphBuilder(baseGraphProvider.get(), timetableRepositoryProvider.get(), issueStoreProvider.get(), closeDataSourcesHandleProvider.get());
  }

  public static GraphBuilderModule_ProvideGraphBuilderFactory create(
      Provider<Graph> baseGraphProvider, Provider<TimetableRepository> timetableRepositoryProvider,
      Provider<DataImportIssueStore> issueStoreProvider,
      Provider<GraphBuilderDataSources> closeDataSourcesHandleProvider) {
    return new GraphBuilderModule_ProvideGraphBuilderFactory(baseGraphProvider, timetableRepositoryProvider, issueStoreProvider, closeDataSourcesHandleProvider);
  }

  public static GraphBuilder provideGraphBuilder(Graph baseGraph,
      TimetableRepository timetableRepository, DataImportIssueStore issueStore,
      GraphBuilderDataSources closeDataSourcesHandle) {
    return Preconditions.checkNotNullFromProvides(GraphBuilderModule.provideGraphBuilder(baseGraph, timetableRepository, issueStore, closeDataSourcesHandle));
  }
}
