package org.opentripplanner.ext.geocoder.configure;

import dagger.internal.DaggerGenerated;
import dagger.internal.Factory;
import dagger.internal.Provider;
import dagger.internal.QualifierMetadata;
import dagger.internal.ScopeMetadata;
import javax.annotation.Nullable;
import javax.annotation.processing.Generated;
import org.opentripplanner.ext.geocoder.LuceneIndex;
import org.opentripplanner.ext.stopconsolidation.StopConsolidationService;
import org.opentripplanner.transit.service.TimetableRepository;

@ScopeMetadata("jakarta.inject.Singleton")
@QualifierMetadata
@DaggerGenerated
@Generated(
    value = "dagger.internal.codegen.ComponentProcessor",
    comments = "https://dagger.dev"
)
@SuppressWarnings({
    "unchecked",
    "rawtypes",
    "KotlinInternal",
    "KotlinInternalInJava",
    "cast",
    "deprecation",
    "nullness:initialization.field.uninitialized"
})
public final class GeocoderModule_LuceneIndexFactory implements Factory<LuceneIndex> {
  private final GeocoderModule module;

  private final Provider<TimetableRepository> timetableRepositoryProvider;

  private final Provider<StopConsolidationService> stopConsolidationServiceProvider;

  private GeocoderModule_LuceneIndexFactory(GeocoderModule module,
      Provider<TimetableRepository> timetableRepositoryProvider,
      Provider<StopConsolidationService> stopConsolidationServiceProvider) {
    this.module = module;
    this.timetableRepositoryProvider = timetableRepositoryProvider;
    this.stopConsolidationServiceProvider = stopConsolidationServiceProvider;
  }

  @Override
  @Nullable
  public LuceneIndex get() {
    return luceneIndex(module, timetableRepositoryProvider.get(), stopConsolidationServiceProvider.get());
  }

  public static GeocoderModule_LuceneIndexFactory create(GeocoderModule module,
      Provider<TimetableRepository> timetableRepositoryProvider,
      Provider<StopConsolidationService> stopConsolidationServiceProvider) {
    return new GeocoderModule_LuceneIndexFactory(module, timetableRepositoryProvider, stopConsolidationServiceProvider);
  }

  @Nullable
  public static LuceneIndex luceneIndex(GeocoderModule instance,
      TimetableRepository timetableRepository,
      @Nullable StopConsolidationService stopConsolidationService) {
    return instance.luceneIndex(timetableRepository, stopConsolidationService);
  }
}
