package org.opentripplanner.datastore.configure;

import dagger.internal.DaggerGenerated;
import dagger.internal.Factory;
import dagger.internal.Preconditions;
import dagger.internal.Provider;
import dagger.internal.QualifierMetadata;
import dagger.internal.ScopeMetadata;
import java.io.File;
import javax.annotation.Nullable;
import javax.annotation.processing.Generated;
import org.opentripplanner.datastore.OtpDataStore;
import org.opentripplanner.datastore.api.OtpDataStoreConfig;
import org.opentripplanner.datastore.base.DataSourceRepository;

@ScopeMetadata("jakarta.inject.Singleton")
@QualifierMetadata({
    "org.opentripplanner.datastore.api.OtpBaseDirectory",
    "org.opentripplanner.datastore.api.GoogleStorageDSRepository"
})
@DaggerGenerated
@Generated(
    value = "dagger.internal.codegen.ComponentProcessor",
    comments = "https://dagger.dev"
)
@SuppressWarnings({
    "unchecked",
    "rawtypes",
    "KotlinInternal",
    "KotlinInternalInJava",
    "cast",
    "deprecation",
    "nullness:initialization.field.uninitialized"
})
public final class DataStoreModule_ProvideDataStoreFactory implements Factory<OtpDataStore> {
  private final Provider<File> baseDirectoryProvider;

  private final Provider<OtpDataStoreConfig> configProvider;

  private final Provider<DataSourceRepository> gsRepositoryProvider;

  private DataStoreModule_ProvideDataStoreFactory(Provider<File> baseDirectoryProvider,
      Provider<OtpDataStoreConfig> configProvider,
      Provider<DataSourceRepository> gsRepositoryProvider) {
    this.baseDirectoryProvider = baseDirectoryProvider;
    this.configProvider = configProvider;
    this.gsRepositoryProvider = gsRepositoryProvider;
  }

  @Override
  public OtpDataStore get() {
    return provideDataStore(baseDirectoryProvider.get(), configProvider.get(), gsRepositoryProvider.get());
  }

  public static DataStoreModule_ProvideDataStoreFactory create(Provider<File> baseDirectoryProvider,
      Provider<OtpDataStoreConfig> configProvider,
      Provider<DataSourceRepository> gsRepositoryProvider) {
    return new DataStoreModule_ProvideDataStoreFactory(baseDirectoryProvider, configProvider, gsRepositoryProvider);
  }

  public static OtpDataStore provideDataStore(File baseDirectory, OtpDataStoreConfig config,
      @Nullable DataSourceRepository gsRepository) {
    return Preconditions.checkNotNullFromProvides(DataStoreModule.provideDataStore(baseDirectory, config, gsRepository));
  }
}
