package org.opentripplanner.apis.transmodel.model.stop;

import graphql.Scalars;
import graphql.relay.Relay;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import java.util.Optional;
import org.opentripplanner.api.model.transit.FeedScopedIdMapper;
import org.opentripplanner.routing.graphfinder.NearbyStop;

public class QuayAtDistanceType {

  private final FeedScopedIdMapper idMapper;

  public QuayAtDistanceType(FeedScopedIdMapper idMapper) {
    this.idMapper = idMapper;
  }

  public GraphQLObjectType createQD(GraphQLOutputType quayType, Relay relay) {
    return GraphQLObjectType.newObject()
      .name("QuayAtDistance")
      .field(
        GraphQLFieldDefinition.newFieldDefinition()
          .name("id")
          .type(new GraphQLNonNull(Scalars.GraphQLID))
          .dataFetcher(environment ->
            relay.toGlobalId(
              "QAD",
              Optional.ofNullable((NearbyStop) environment.getSource())
                .map(
                  nearbyStop ->
                    nearbyStop.distance + ";" + idMapper.mapToApi(nearbyStop.stop.getId())
                )
                .orElse(null)
            )
          )
          .build()
      )
      .field(
        GraphQLFieldDefinition.newFieldDefinition()
          .name("quay")
          .type(quayType)
          .dataFetcher(environment -> ((NearbyStop) environment.getSource()).stop)
          .build()
      )
      .field(
        GraphQLFieldDefinition.newFieldDefinition()
          .name("distance")
          .type(Scalars.GraphQLFloat)
          .description("The distance in meters to the given quay.")
          .dataFetcher(environment -> ((NearbyStop) environment.getSource()).distance)
          .build()
      )
      .build();
  }
}
