package org.opentripplanner.apis.transmodel.configure;

import dagger.internal.DaggerGenerated;
import dagger.internal.Factory;
import dagger.internal.Provider;
import dagger.internal.QualifierMetadata;
import dagger.internal.ScopeMetadata;
import graphql.schema.GraphQLSchema;
import javax.annotation.Nullable;
import javax.annotation.processing.Generated;
import org.opentripplanner.routing.api.request.RouteRequest;
import org.opentripplanner.standalone.config.RouterConfig;
import org.opentripplanner.transit.service.TimetableRepository;

@ScopeMetadata("jakarta.inject.Singleton")
@QualifierMetadata("org.opentripplanner.apis.transmodel.configure.TransmodelSchema")
@DaggerGenerated
@Generated(
    value = "dagger.internal.codegen.ComponentProcessor",
    comments = "https://dagger.dev"
)
@SuppressWarnings({
    "unchecked",
    "rawtypes",
    "KotlinInternal",
    "KotlinInternalInJava",
    "cast",
    "deprecation",
    "nullness:initialization.field.uninitialized"
})
public final class TransmodelSchemaModule_ProvideTransmodelSchemaFactory implements Factory<GraphQLSchema> {
  private final TransmodelSchemaModule module;

  private final Provider<RouteRequest> defaultRouteRequestProvider;

  private final Provider<TimetableRepository> timetableRepositoryProvider;

  private final Provider<RouterConfig> routerConfigProvider;

  private TransmodelSchemaModule_ProvideTransmodelSchemaFactory(TransmodelSchemaModule module,
      Provider<RouteRequest> defaultRouteRequestProvider,
      Provider<TimetableRepository> timetableRepositoryProvider,
      Provider<RouterConfig> routerConfigProvider) {
    this.module = module;
    this.defaultRouteRequestProvider = defaultRouteRequestProvider;
    this.timetableRepositoryProvider = timetableRepositoryProvider;
    this.routerConfigProvider = routerConfigProvider;
  }

  @Override
  @Nullable
  public GraphQLSchema get() {
    return provideTransmodelSchema(module, defaultRouteRequestProvider.get(), timetableRepositoryProvider.get(), routerConfigProvider.get());
  }

  public static TransmodelSchemaModule_ProvideTransmodelSchemaFactory create(
      TransmodelSchemaModule module, Provider<RouteRequest> defaultRouteRequestProvider,
      Provider<TimetableRepository> timetableRepositoryProvider,
      Provider<RouterConfig> routerConfigProvider) {
    return new TransmodelSchemaModule_ProvideTransmodelSchemaFactory(module, defaultRouteRequestProvider, timetableRepositoryProvider, routerConfigProvider);
  }

  @Nullable
  public static GraphQLSchema provideTransmodelSchema(TransmodelSchemaModule instance,
      RouteRequest defaultRouteRequest, TimetableRepository timetableRepository,
      RouterConfig routerConfig) {
    return instance.provideTransmodelSchema(defaultRouteRequest, timetableRepository, routerConfig);
  }
}
