import { getArgumentValues } from '@graphql-tools/utils';
import TransformObjectFields from './TransformObjectFields.js';
export default class FilterObjectFieldDirectives {
    constructor(filter) {
        this.filter = filter;
    }
    transformSchema(originalWrappingSchema, subschemaConfig) {
        const transformer = new TransformObjectFields((_typeName, _fieldName, fieldConfig) => {
            const keepDirectives = fieldConfig.astNode?.directives?.filter(dir => {
                const directiveDef = originalWrappingSchema.getDirective(dir.name.value);
                const directiveValue = directiveDef ? getArgumentValues(directiveDef, dir) : undefined;
                return this.filter(dir.name.value, directiveValue);
            }) ?? [];
            if (fieldConfig.astNode?.directives != null &&
                keepDirectives.length !== fieldConfig.astNode.directives.length) {
                fieldConfig = {
                    ...fieldConfig,
                    astNode: {
                        ...fieldConfig.astNode,
                        directives: keepDirectives,
                    },
                };
                return fieldConfig;
            }
        });
        return transformer.transformSchema(originalWrappingSchema, subschemaConfig);
    }
}
