"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const utils_1 = require("@graphql-tools/utils");
const TransformObjectFields_js_1 = tslib_1.__importDefault(require("./TransformObjectFields.js"));
class FilterObjectFieldDirectives {
    constructor(filter) {
        this.filter = filter;
    }
    transformSchema(originalWrappingSchema, subschemaConfig) {
        const transformer = new TransformObjectFields_js_1.default((_typeName, _fieldName, fieldConfig) => {
            const keepDirectives = fieldConfig.astNode?.directives?.filter(dir => {
                const directiveDef = originalWrappingSchema.getDirective(dir.name.value);
                const directiveValue = directiveDef ? (0, utils_1.getArgumentValues)(directiveDef, dir) : undefined;
                return this.filter(dir.name.value, directiveValue);
            }) ?? [];
            if (fieldConfig.astNode?.directives != null &&
                keepDirectives.length !== fieldConfig.astNode.directives.length) {
                fieldConfig = {
                    ...fieldConfig,
                    astNode: {
                        ...fieldConfig.astNode,
                        directives: keepDirectives,
                    },
                };
                return fieldConfig;
            }
        });
        return transformer.transformSchema(originalWrappingSchema, subschemaConfig);
    }
}
exports.default = FilterObjectFieldDirectives;
