import { meros as merosIncomingMessage } from 'meros/node';
import { meros as merosReadableStream } from 'meros/browser';
import { mapAsyncIterator, mergeIncrementalResult } from '@graphql-tools/utils';
import { addCancelToResponseStream } from './addCancelToResponseStream.js';
function isIncomingMessage(body) {
    return body != null && typeof body === 'object' && 'pipe' in body;
}
export async function handleMultipartMixedResponse(response, controller) {
    const body = response.body;
    const contentType = response.headers.get('content-type') || '';
    let asyncIterator;
    if (isIncomingMessage(body)) {
        // Meros/node expects headers as an object map with the content-type prop
        body.headers = {
            'content-type': contentType,
        };
        // And it expects `IncomingMessage` and `node-fetch` returns `body` as `Promise<PassThrough>`
        const result = await merosIncomingMessage(body);
        if ('next' in result) {
            asyncIterator = result;
        }
    }
    else {
        // Nothing is needed for regular `Response`.
        const result = await merosReadableStream(response);
        if ('next' in result) {
            asyncIterator = result;
        }
    }
    const executionResult = {};
    if (asyncIterator == null) {
        return executionResult;
    }
    const resultStream = mapAsyncIterator(asyncIterator, (part) => {
        if (part.json) {
            const incrementalResult = part.body;
            mergeIncrementalResult({
                incrementalResult,
                executionResult,
            });
            return executionResult;
        }
    });
    if (controller) {
        return addCancelToResponseStream(resultStream, controller);
    }
    return resultStream;
}
