"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.handleMultipartMixedResponse = void 0;
const node_1 = require("meros/node");
const browser_1 = require("meros/browser");
const utils_1 = require("@graphql-tools/utils");
const addCancelToResponseStream_js_1 = require("./addCancelToResponseStream.js");
function isIncomingMessage(body) {
    return body != null && typeof body === 'object' && 'pipe' in body;
}
async function handleMultipartMixedResponse(response, controller) {
    const body = response.body;
    const contentType = response.headers.get('content-type') || '';
    let asyncIterator;
    if (isIncomingMessage(body)) {
        // Meros/node expects headers as an object map with the content-type prop
        body.headers = {
            'content-type': contentType,
        };
        // And it expects `IncomingMessage` and `node-fetch` returns `body` as `Promise<PassThrough>`
        const result = await (0, node_1.meros)(body);
        if ('next' in result) {
            asyncIterator = result;
        }
    }
    else {
        // Nothing is needed for regular `Response`.
        const result = await (0, browser_1.meros)(response);
        if ('next' in result) {
            asyncIterator = result;
        }
    }
    const executionResult = {};
    if (asyncIterator == null) {
        return executionResult;
    }
    const resultStream = (0, utils_1.mapAsyncIterator)(asyncIterator, (part) => {
        if (part.json) {
            const incrementalResult = part.body;
            (0, utils_1.mergeIncrementalResult)({
                incrementalResult,
                executionResult,
            });
            return executionResult;
        }
    });
    if (controller) {
        return (0, addCancelToResponseStream_js_1.addCancelToResponseStream)(resultStream, controller);
    }
    return resultStream;
}
exports.handleMultipartMixedResponse = handleMultipartMixedResponse;
