import { getOperationASTFromRequest } from '@graphql-tools/utils';
import { print } from 'graphql';
import { createClient } from 'graphql-ws';
import WebSocket from 'isomorphic-ws';
function isClient(client) {
    return 'subscribe' in client;
}
export function buildGraphQLWSExecutor(clientOptionsOrClient) {
    let graphqlWSClient;
    if (isClient(clientOptionsOrClient)) {
        graphqlWSClient = clientOptionsOrClient;
    }
    else {
        graphqlWSClient = createClient({
            webSocketImpl: WebSocket,
            lazy: true,
            ...clientOptionsOrClient,
        });
        if (clientOptionsOrClient.onClient) {
            clientOptionsOrClient.onClient(graphqlWSClient);
        }
    }
    return function GraphQLWSExecutor(executionRequest) {
        const { document, variables, operationName, extensions, operationType = getOperationASTFromRequest(executionRequest).operation, } = executionRequest;
        const query = print(document);
        const iterableIterator = graphqlWSClient.iterate({
            query,
            variables,
            operationName,
            extensions,
        });
        if (operationType === 'subscription') {
            return iterableIterator;
        }
        return iterableIterator.next().then(({ value }) => value);
    };
}
