"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.buildPackageNameFromPath = buildPackageNameFromPath;
exports.wrapTypeWithModifiers = wrapTypeWithModifiers;
exports.stripIndent = stripIndent;
const tslib_1 = require("tslib");
const graphql_1 = require("graphql");
const min_indent_1 = tslib_1.__importDefault(require("min-indent"));
const unixify_1 = tslib_1.__importDefault(require("unixify"));
function buildPackageNameFromPath(path) {
    return (0, unixify_1.default)(path || '')
        .replace(/src\/main\/.*?\//, '')
        .replace(/\//g, '.');
}
function wrapTypeWithModifiers(baseType, typeNode, listType = 'Iterable') {
    if (typeNode.kind === graphql_1.Kind.NON_NULL_TYPE) {
        return wrapTypeWithModifiers(baseType, typeNode.type, listType);
    }
    if (typeNode.kind === graphql_1.Kind.LIST_TYPE) {
        const innerType = wrapTypeWithModifiers(baseType, typeNode.type, listType);
        return `${listType}<${innerType}>`;
    }
    return baseType;
}
function stripIndent(string) {
    const indent = (0, min_indent_1.default)(string);
    if (indent === 0) {
        return string;
    }
    const regex = new RegExp(`^[ \\t]{${indent}}`, 'gm');
    return string.replace(regex, '');
}
