"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.JavaResolversVisitor = void 0;
const java_common_1 = require("@graphql-codegen/java-common");
const visitor_plugin_common_1 = require("@graphql-codegen/visitor-plugin-common");
class JavaResolversVisitor extends visitor_plugin_common_1.BaseVisitor {
    constructor(rawConfig, _schema, defaultPackageName) {
        super(rawConfig, {
            mappers: (0, visitor_plugin_common_1.transformMappers)(rawConfig.mappers || {}),
            package: rawConfig.package || defaultPackageName,
            defaultMapper: (0, visitor_plugin_common_1.parseMapper)(rawConfig.defaultMapper || 'Object'),
            className: rawConfig.className || 'Resolvers',
            listType: rawConfig.listType || 'Iterable',
            scalars: (0, visitor_plugin_common_1.buildScalarsFromConfig)(_schema, rawConfig, java_common_1.JAVA_SCALARS, 'Object'),
        });
        this._includeTypeResolverImport = false;
    }
    getImports() {
        const mappersImports = this.mappersImports();
        const allImports = [...mappersImports];
        if (this._includeTypeResolverImport) {
            allImports.push('graphql.schema.TypeResolver');
        }
        allImports.push('graphql.schema.DataFetcher');
        return allImports.map(i => `import ${i};`).join('\n') + '\n';
    }
    mappersImports() {
        return Object.keys(this.config.mappers)
            .map(typeName => this.config.mappers[typeName])
            .filter((m) => m.isExternal)
            .map(m => m.source);
    }
    getTypeToUse(type) {
        if (this.scalars[type.name.value]) {
            return this.scalars[type.name.value];
        }
        if (this.config.mappers[type.name.value]) {
            return this.config.mappers[type.name.value].type;
        }
        return this.config.defaultMapper.type;
    }
    getPackageName() {
        return `package ${this.config.package};\n`;
    }
    wrapWithClass(content) {
        return new java_common_1.JavaDeclarationBlock()
            .access('public')
            .asKind('class')
            .withName(this.config.className)
            .withBlock((0, visitor_plugin_common_1.indentMultiline)(content)).string;
    }
    UnionTypeDefinition(node) {
        this._includeTypeResolverImport = true;
        return new java_common_1.JavaDeclarationBlock()
            .access('public')
            .asKind('interface')
            .withName(this.convertName(node.name))
            .extends(['TypeResolver'])
            .withComment(node.description).string;
    }
    InterfaceTypeDefinition(node) {
        this._includeTypeResolverImport = true;
        return new java_common_1.JavaDeclarationBlock()
            .access('public')
            .asKind('interface')
            .withName(this.convertName(node.name))
            .extends(['TypeResolver'])
            .withComment(node.description)
            .withBlock(node.fields.map(f => (0, visitor_plugin_common_1.indent)(f(true))).join('\n')).string;
    }
    ObjectTypeDefinition(node) {
        return new java_common_1.JavaDeclarationBlock()
            .access('public')
            .asKind('interface')
            .withName(this.convertName(node.name))
            .withComment(node.description)
            .withBlock(node.fields.map(f => (0, visitor_plugin_common_1.indent)(f(false))).join('\n')).string;
    }
    FieldDefinition(node, key, _parent) {
        return (isInterface) => {
            const baseType = (0, visitor_plugin_common_1.getBaseTypeNode)(node.type);
            const typeToUse = this.getTypeToUse(baseType);
            const wrappedType = (0, java_common_1.wrapTypeWithModifiers)(typeToUse, node.type, this.config.listType);
            if (isInterface) {
                return `default public DataFetcher<${wrappedType}> ${node.name.value}() { return null; }`;
            }
            return `public DataFetcher<${wrappedType}> ${node.name.value}();`;
        };
    }
}
exports.JavaResolversVisitor = JavaResolversVisitor;
