//THIS IS AN AUTOGENERATED FILE. DO NOT EDIT THIS FILE DIRECTLY.
package org.opentripplanner.apis.gtfs.generated;

import graphql.relay.Connection;
import graphql.relay.DefaultEdge;
import graphql.relay.Edge;
import graphql.schema.DataFetcher;
import graphql.schema.TypeResolver;
import java.util.Currency;
import java.util.Map;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.opentripplanner.api.resource.DebugOutput;
import org.opentripplanner.apis.gtfs.generated.GraphQLTypes.GraphQLAbsoluteDirection;
import org.opentripplanner.apis.gtfs.generated.GraphQLTypes.GraphQLAlertCauseType;
import org.opentripplanner.apis.gtfs.generated.GraphQLTypes.GraphQLAlertEffectType;
import org.opentripplanner.apis.gtfs.generated.GraphQLTypes.GraphQLAlertSeverityLevelType;
import org.opentripplanner.apis.gtfs.generated.GraphQLTypes.GraphQLBikesAllowed;
import org.opentripplanner.apis.gtfs.generated.GraphQLTypes.GraphQLInputField;
import org.opentripplanner.apis.gtfs.generated.GraphQLTypes.GraphQLOccupancyStatus;
import org.opentripplanner.apis.gtfs.generated.GraphQLTypes.GraphQLPickupDropoffType;
import org.opentripplanner.apis.gtfs.generated.GraphQLTypes.GraphQLRealtimeState;
import org.opentripplanner.apis.gtfs.generated.GraphQLTypes.GraphQLRelativeDirection;
import org.opentripplanner.apis.gtfs.generated.GraphQLTypes.GraphQLRoutingErrorCode;
import org.opentripplanner.apis.gtfs.generated.GraphQLTypes.GraphQLTransitMode;
import org.opentripplanner.apis.gtfs.model.CallRealTime;
import org.opentripplanner.apis.gtfs.model.CallSchedule;
import org.opentripplanner.apis.gtfs.model.CallScheduledTime;
import org.opentripplanner.apis.gtfs.model.FeedPublisher;
import org.opentripplanner.apis.gtfs.model.PlanPageInfo;
import org.opentripplanner.apis.gtfs.model.RideHailingProvider;
import org.opentripplanner.apis.gtfs.model.StopPosition;
import org.opentripplanner.apis.gtfs.model.TripOccupancy;
import org.opentripplanner.ext.fares.model.FareRuleSet;
import org.opentripplanner.ext.ridehailing.model.RideEstimate;
import org.opentripplanner.model.StopTimesInPattern;
import org.opentripplanner.model.SystemNotice;
import org.opentripplanner.model.TripTimeOnDate;
import org.opentripplanner.model.calendar.openinghours.OHCalendar;
import org.opentripplanner.model.fare.FareMedium;
import org.opentripplanner.model.fare.FareOffer;
import org.opentripplanner.model.fare.RiderCategory;
import org.opentripplanner.model.plan.Emission;
import org.opentripplanner.model.plan.Itinerary;
import org.opentripplanner.model.plan.Leg;
import org.opentripplanner.model.plan.leg.LegCallTime;
import org.opentripplanner.model.plan.leg.LegRealTimeEstimate;
import org.opentripplanner.model.plan.leg.StopArrival;
import org.opentripplanner.model.plan.walkstep.WalkStep;
import org.opentripplanner.routing.alertpatch.TransitAlert;
import org.opentripplanner.routing.api.response.RoutingError;
import org.opentripplanner.routing.graphfinder.NearbyStop;
import org.opentripplanner.routing.graphfinder.PatternAtStop;
import org.opentripplanner.routing.graphfinder.PlaceAtDistance;
import org.opentripplanner.service.realtimevehicles.model.RealtimeVehicle;
import org.opentripplanner.service.realtimevehicles.model.RealtimeVehicle.StopRelationship;
import org.opentripplanner.service.vehicleparking.model.VehicleParking;
import org.opentripplanner.service.vehicleparking.model.VehicleParkingSpaces;
import org.opentripplanner.service.vehicleparking.model.VehicleParkingState;
import org.opentripplanner.service.vehiclerental.model.RentalVehicleEntityCounts;
import org.opentripplanner.service.vehiclerental.model.RentalVehicleFuel;
import org.opentripplanner.service.vehiclerental.model.RentalVehicleType;
import org.opentripplanner.service.vehiclerental.model.RentalVehicleTypeCount;
import org.opentripplanner.service.vehiclerental.model.VehicleRentalPlace;
import org.opentripplanner.service.vehiclerental.model.VehicleRentalStation;
import org.opentripplanner.service.vehiclerental.model.VehicleRentalStationUris;
import org.opentripplanner.service.vehiclerental.model.VehicleRentalSystem;
import org.opentripplanner.service.vehiclerental.model.VehicleRentalVehicle;
import org.opentripplanner.transit.model.basic.Money;
import org.opentripplanner.transit.model.network.Route;
import org.opentripplanner.transit.model.network.TripPattern;
import org.opentripplanner.transit.model.organization.Agency;
import org.opentripplanner.transit.model.timetable.EstimatedTime;
import org.opentripplanner.transit.model.timetable.Trip;
import org.opentripplanner.transit.model.timetable.TripOnServiceDate;
import org.opentripplanner.transit.model.timetable.booking.BookingInfo;
import org.opentripplanner.transit.model.timetable.booking.BookingTime;

public class GraphQLDataFetchers {

  /** A public transport agency */
  public interface GraphQLAgency {
    public DataFetcher<Iterable<TransitAlert>> alerts();

    public DataFetcher<String> fareUrl();

    public DataFetcher<String> gtfsId();

    public DataFetcher<graphql.relay.Relay.ResolvedGlobalId> id();

    public DataFetcher<String> lang();

    public DataFetcher<String> name();

    public DataFetcher<String> phone();

    public DataFetcher<Iterable<Route>> routes();

    public DataFetcher<String> timezone();

    public DataFetcher<String> url();
  }

  /** Alert of a current or upcoming disruption in public transportation */
  public interface GraphQLAlert {
    public DataFetcher<Agency> agency();

    public DataFetcher<GraphQLAlertCauseType> alertCause();

    public DataFetcher<String> alertDescriptionText();

    public DataFetcher<Iterable<Map.Entry<String, String>>> alertDescriptionTextTranslations();

    public DataFetcher<GraphQLAlertEffectType> alertEffect();

    public DataFetcher<Integer> alertHash();

    public DataFetcher<String> alertHeaderText();

    public DataFetcher<Iterable<Map.Entry<String, String>>> alertHeaderTextTranslations();

    public DataFetcher<GraphQLAlertSeverityLevelType> alertSeverityLevel();

    public DataFetcher<String> alertUrl();

    public DataFetcher<Iterable<Map.Entry<String, String>>> alertUrlTranslations();

    public DataFetcher<Long> effectiveEndDate();

    public DataFetcher<Long> effectiveStartDate();

    public DataFetcher<Iterable<Object>> entities();

    public DataFetcher<String> feed();

    public DataFetcher<graphql.relay.Relay.ResolvedGlobalId> id();

    public DataFetcher<Iterable<TripPattern>> patterns();

    public DataFetcher<Route> route();

    public DataFetcher<Object> stop();

    public DataFetcher<Trip> trip();
  }

  /** Entity related to an alert */
  public interface GraphQLAlertEntity extends TypeResolver {}

  /** Arrival and departure time (not relative to midnight). */
  public interface GraphQLArrivalDepartureTime {
    public DataFetcher<java.time.OffsetDateTime> arrival();

    public DataFetcher<java.time.OffsetDateTime> departure();
  }

  /** Bike park represents a location where bicycles can be parked. */
  public interface GraphQLBikePark {
    public DataFetcher<String> bikeParkId();

    public DataFetcher<graphql.relay.Relay.ResolvedGlobalId> id();

    public DataFetcher<Double> lat();

    public DataFetcher<Double> lon();

    public DataFetcher<String> name();

    public DataFetcher<OHCalendar> openingHours();

    public DataFetcher<Boolean> realtime();

    public DataFetcher<Integer> spacesAvailable();

    public DataFetcher<Iterable<String>> tags();
  }

  /** Bike rental station represents a location where users can rent bicycles for a fee. */
  public interface GraphQLBikeRentalStation {
    public DataFetcher<Boolean> allowDropoff();

    public DataFetcher<Boolean> allowDropoffNow();

    public DataFetcher<Boolean> allowOverloading();

    public DataFetcher<Boolean> allowPickup();

    public DataFetcher<Boolean> allowPickupNow();

    public DataFetcher<Integer> bikesAvailable();

    public DataFetcher<Integer> capacity();

    public DataFetcher<graphql.relay.Relay.ResolvedGlobalId> id();

    public DataFetcher<Double> lat();

    public DataFetcher<Double> lon();

    public DataFetcher<String> name();

    public DataFetcher<Iterable<String>> networks();

    public DataFetcher<Boolean> operative();

    public DataFetcher<Boolean> realtime();

    public DataFetcher<VehicleRentalStationUris> rentalUris();

    public DataFetcher<Integer> spacesAvailable();

    public DataFetcher<String> state();

    public DataFetcher<String> stationId();
  }

  public interface GraphQLBikeRentalStationUris {
    public DataFetcher<String> android();

    public DataFetcher<String> ios();

    public DataFetcher<String> web();
  }

  /**
   * Booking information for a stop time which has special requirements to use, like calling ahead or
   * using an app.
   */
  public interface GraphQLBookingInfo {
    public DataFetcher<org.opentripplanner.transit.model.organization.ContactInfo> contactInfo();

    public DataFetcher<String> dropOffMessage();

    public DataFetcher<BookingTime> earliestBookingTime();

    public DataFetcher<BookingTime> latestBookingTime();

    public DataFetcher<java.time.Duration> maximumBookingNotice();

    public DataFetcher<Long> maximumBookingNoticeSeconds();

    public DataFetcher<String> message();

    public DataFetcher<java.time.Duration> minimumBookingNotice();

    public DataFetcher<Long> minimumBookingNoticeSeconds();

    public DataFetcher<String> pickupMessage();
  }

  /** Temporal restriction for a booking */
  public interface GraphQLBookingTime {
    public DataFetcher<Integer> daysPrior();

    public DataFetcher<String> time();
  }

  /** Real-time estimates for arrival and departure times for a stop location. */
  public interface GraphQLCallRealTime {
    public DataFetcher<EstimatedTime> arrival();

    public DataFetcher<EstimatedTime> departure();
  }

  /** What is scheduled for a trip on a service date for a stop location. */
  public interface GraphQLCallSchedule {
    public DataFetcher<CallScheduledTime> time();
  }

  /** Scheduled times for a trip on a service date for a stop location. */
  public interface GraphQLCallScheduledTime extends TypeResolver {}

  /** Location where a transit vehicle stops at. */
  public interface GraphQLCallStopLocation extends TypeResolver {}

  /** Car park represents a location where cars can be parked. */
  public interface GraphQLCarPark {
    public DataFetcher<String> carParkId();

    public DataFetcher<graphql.relay.Relay.ResolvedGlobalId> id();

    public DataFetcher<Double> lat();

    public DataFetcher<Double> lon();

    public DataFetcher<Integer> maxCapacity();

    public DataFetcher<String> name();

    public DataFetcher<OHCalendar> openingHours();

    public DataFetcher<Boolean> realtime();

    public DataFetcher<Integer> spacesAvailable();

    public DataFetcher<Iterable<String>> tags();
  }

  /** Cluster is a list of stops grouped by name and proximity */
  public interface GraphQLCluster {
    public DataFetcher<String> gtfsId();

    public DataFetcher<graphql.relay.Relay.ResolvedGlobalId> id();

    public DataFetcher<Double> lat();

    public DataFetcher<Double> lon();

    public DataFetcher<String> name();

    public DataFetcher<Iterable<Object>> stops();
  }

  /** Contact information for booking an on-demand or flexible service. */
  public interface GraphQLContactInfo {
    public DataFetcher<String> additionalDetails();

    public DataFetcher<String> bookingUrl();

    public DataFetcher<String> contactPerson();

    public DataFetcher<String> eMail();

    public DataFetcher<String> faxNumber();

    public DataFetcher<String> infoUrl();

    public DataFetcher<String> phoneNumber();
  }

  /**
   * Coordinate (often referred as coordinates), which is used to specify a location using in the
   * WGS84 coordinate system.
   */
  public interface GraphQLCoordinate {
    public DataFetcher<Double> latitude();

    public DataFetcher<Double> longitude();
  }

  public interface GraphQLCoordinates {
    public DataFetcher<Double> lat();

    public DataFetcher<Double> lon();
  }

  /** A currency */
  public interface GraphQLCurrency {
    public DataFetcher<String> code();

    public DataFetcher<Integer> digits();
  }

  /**
   * The standard case of a fare product: it only has a single price to be paid by the passenger
   * and no discounts are applied.
   */
  public interface GraphQLDefaultFareProduct {
    public DataFetcher<String> id();

    public DataFetcher<FareMedium> medium();

    public DataFetcher<String> name();

    public DataFetcher<Money> price();

    public DataFetcher<RiderCategory> riderCategory();
  }

  /**
   * Departure row is a combination of a pattern and a stop of that pattern.
   *
   * They are de-duplicated so for each pattern there will only be a single departure row.
   *
   * This is useful if you want to show a list of stop/pattern combinations but want each pattern to be
   * listed only once.
   */
  public interface GraphQLDepartureRow {
    public DataFetcher<graphql.relay.Relay.ResolvedGlobalId> id();

    public DataFetcher<Double> lat();

    public DataFetcher<Double> lon();

    public DataFetcher<TripPattern> pattern();

    public DataFetcher<Object> stop();

    public DataFetcher<Iterable<TripTimeOnDate>> stoptimes();
  }

  public interface GraphQLDependentFareProduct {
    public DataFetcher<Iterable<FareOffer>> dependencies();

    public DataFetcher<String> id();

    public DataFetcher<FareMedium> medium();

    public DataFetcher<String> name();

    public DataFetcher<Money> price();

    public DataFetcher<RiderCategory> riderCategory();
  }

  public interface GraphQLEmissions {
    public DataFetcher<org.opentripplanner.framework.model.Gram> co2();
  }

  /** Station entrance or exit, originating from OSM or GTFS data. */
  public interface GraphQLEntrance {
    public DataFetcher<String> entranceId();

    public DataFetcher<String> name();

    public DataFetcher<String> publicCode();

    public DataFetcher<
      org.opentripplanner.apis.gtfs.generated.GraphQLTypes.GraphQLWheelchairBoarding
    > wheelchairAccessible();
  }

  /** Real-time estimates for an arrival or departure at a certain place. */
  public interface GraphQLEstimatedTime {
    public DataFetcher<java.time.Duration> delay();

    public DataFetcher<java.time.OffsetDateTime> time();
  }

  /** A 'medium' that a fare product applies to, for example cash, 'Oyster Card' or 'DB Navigator App'. */
  public interface GraphQLFareMedium {
    public DataFetcher<String> id();

    public DataFetcher<String> name();
  }

  /** A fare product (a ticket) to be bought by a passenger */
  public interface GraphQLFareProduct extends TypeResolver {
    public default DataFetcher<String> id() {
      return null;
    }

    public default DataFetcher<FareMedium> medium() {
      return null;
    }

    public default DataFetcher<String> name() {
      return null;
    }

    public default DataFetcher<RiderCategory> riderCategory() {
      return null;
    }
  }

  /** A container for both a fare product (a ticket) and its relationship to the itinerary. */
  public interface GraphQLFareProductUse {
    public DataFetcher<String> id();

    public DataFetcher<FareOffer> product();
  }

  /** A feed provides routing data (stops, routes, timetables, etc.) from one or more public transport agencies. */
  public interface GraphQLFeed {
    public DataFetcher<Iterable<Agency>> agencies();

    public DataFetcher<Iterable<TransitAlert>> alerts();

    public DataFetcher<String> feedId();

    public DataFetcher<FeedPublisher> publisher();
  }

  /** Feed publisher information */
  public interface GraphQLFeedPublisher {
    public DataFetcher<String> name();

    public DataFetcher<String> url();
  }

  public interface GraphQLGeometry {
    public DataFetcher<Integer> length();

    public DataFetcher<String> points();
  }

  public interface GraphQLItinerary {
    public DataFetcher<Double> accessibilityScore();

    public DataFetcher<Boolean> arrivedAtDestinationWithRentedBicycle();

    public DataFetcher<Long> duration();

    public DataFetcher<Double> elevationGained();

    public DataFetcher<Double> elevationLost();

    public DataFetcher<Emission> emissionsPerPerson();

    public DataFetcher<java.time.OffsetDateTime> end();

    public DataFetcher<Long> endTime();

    public DataFetcher<Iterable<Object>> fares();

    public DataFetcher<Integer> generalizedCost();

    public DataFetcher<Iterable<Leg>> legs();

    public DataFetcher<Integer> numberOfTransfers();

    public DataFetcher<java.time.OffsetDateTime> start();

    public DataFetcher<Long> startTime();

    public DataFetcher<Iterable<SystemNotice>> systemNotices();

    public DataFetcher<Long> waitingTime();

    public DataFetcher<Double> walkDistance();

    public DataFetcher<Long> walkTime();
  }

  public interface GraphQLLeg {
    public DataFetcher<Double> accessibilityScore();

    public DataFetcher<Agency> agency();

    public DataFetcher<Iterable<TransitAlert>> alerts();

    public DataFetcher<Integer> arrivalDelay();

    public DataFetcher<Integer> departureDelay();

    public DataFetcher<Double> distance();

    public DataFetcher<BookingInfo> dropOffBookingInfo();

    public DataFetcher<GraphQLPickupDropoffType> dropoffType();

    public DataFetcher<Double> duration();

    public DataFetcher<LegCallTime> end();

    public DataFetcher<Long> endTime();

    public DataFetcher<Iterable<FareOffer>> fareProducts();

    public DataFetcher<StopArrival> from();

    public DataFetcher<Integer> generalizedCost();

    public DataFetcher<String> headsign();

    public DataFetcher<String> id();

    public DataFetcher<Boolean> interlineWithPreviousLeg();

    public DataFetcher<Boolean> intermediatePlace();

    public DataFetcher<Iterable<StopArrival>> intermediatePlaces();

    public DataFetcher<Iterable<Object>> intermediateStops();

    public DataFetcher<Geometry> legGeometry();

    public DataFetcher<String> mode();

    public DataFetcher<Iterable<Leg>> nextLegs();

    public DataFetcher<BookingInfo> pickupBookingInfo();

    public DataFetcher<GraphQLPickupDropoffType> pickupType();

    public DataFetcher<Iterable<Leg>> previousLegs();

    public DataFetcher<Boolean> realTime();

    public DataFetcher<GraphQLRealtimeState> realtimeState();

    public DataFetcher<Boolean> rentedBike();

    public DataFetcher<RideEstimate> rideHailingEstimate();

    public DataFetcher<Route> route();

    public DataFetcher<String> serviceDate();

    public DataFetcher<LegCallTime> start();

    public DataFetcher<Long> startTime();

    public DataFetcher<Iterable<WalkStep>> steps();

    public DataFetcher<Iterable<TripTimeOnDate>> stopCalls();

    public DataFetcher<StopArrival> to();

    public DataFetcher<Boolean> transitLeg();

    public DataFetcher<Trip> trip();

    public DataFetcher<Boolean> walkingBike();
  }

  /**
   * Time information about a passenger at a certain place. May contain real-time information if
   * available.
   */
  public interface GraphQLLegTime {
    public DataFetcher<LegRealTimeEstimate> estimated();

    public DataFetcher<java.time.OffsetDateTime> scheduledTime();
  }

  /** A span of time. */
  public interface GraphQLLocalTimeSpan {
    public DataFetcher<Integer> from();

    public DataFetcher<Integer> to();
  }

  /** A date using the local timezone of the object that can contain timespans. */
  public interface GraphQLLocalTimeSpanDate {
    public DataFetcher<String> date();

    public DataFetcher<Iterable<Object>> timeSpans();
  }

  /**
   * A stop that isn't a fixed point but zone where passengers can board or alight anywhere.
   *
   * This is mostly used by demand-responsive services.
   */
  public interface GraphQLLocation {
    public DataFetcher<Object> geometry();

    public DataFetcher<String> gtfsId();

    public DataFetcher<String> name();
  }

  /**
   * A group of fixed stops that are visited in an arbitrary order.
   *
   * This is mostly used by demand-responsive services.
   */
  public interface GraphQLLocationGroup {
    public DataFetcher<String> gtfsId();

    public DataFetcher<Iterable<Object>> members();

    public DataFetcher<String> name();
  }

  /** An amount of money. */
  public interface GraphQLMoney {
    public DataFetcher<Double> amount();

    public DataFetcher<Currency> currency();
  }

  /** An object with an ID */
  public interface GraphQLNode extends TypeResolver {
    public default DataFetcher<graphql.relay.Relay.ResolvedGlobalId> id() {
      return null;
    }
  }

  public interface GraphQLOpeningHours {
    public DataFetcher<Iterable<Object>> dates();

    public DataFetcher<String> osm();
  }

  /** Information about pagination in a connection. */
  public interface GraphQLPageInfo {
    public DataFetcher<String> endCursor();

    public DataFetcher<Boolean> hasNextPage();

    public DataFetcher<Boolean> hasPreviousPage();

    public DataFetcher<String> startCursor();
  }

  /**
   * Pattern is sequence of stops used by trips on a specific direction and variant
   * of a route. Most routes have only two patterns: one for outbound trips and one
   * for inbound trips
   */
  public interface GraphQLPattern {
    public DataFetcher<Iterable<TransitAlert>> alerts();

    public DataFetcher<String> code();

    public DataFetcher<Integer> directionId();

    public DataFetcher<Iterable<Coordinate>> geometry();

    public DataFetcher<String> headsign();

    public DataFetcher<graphql.relay.Relay.ResolvedGlobalId> id();

    public DataFetcher<String> name();

    public DataFetcher<TripPattern> originalTripPattern();

    public DataFetcher<Geometry> patternGeometry();

    public DataFetcher<Route> route();

    public DataFetcher<String> semanticHash();

    public DataFetcher<Iterable<Object>> stops();

    public DataFetcher<Iterable<Trip>> trips();

    public DataFetcher<Iterable<Trip>> tripsForDate();

    public DataFetcher<Iterable<RealtimeVehicle>> vehiclePositions();
  }

  public interface GraphQLPlace {
    public DataFetcher<LegCallTime> arrival();

    public DataFetcher<Long> arrivalTime();

    public DataFetcher<VehicleParking> bikePark();

    public DataFetcher<VehicleRentalPlace> bikeRentalStation();

    public DataFetcher<VehicleParking> carPark();

    public DataFetcher<LegCallTime> departure();

    public DataFetcher<Long> departureTime();

    public DataFetcher<Double> lat();

    public DataFetcher<Double> lon();

    public DataFetcher<String> name();

    public DataFetcher<VehicleRentalVehicle> rentalVehicle();

    public DataFetcher<Object> stop();

    public DataFetcher<StopPosition> stopPosition();

    public DataFetcher<VehicleParking> vehicleParking();

    public DataFetcher<VehicleRentalStation> vehicleRentalStation();

    public DataFetcher<String> vertexType();
  }

  /** Interface for places, e.g. stops, stations, parking areas.. */
  public interface GraphQLPlaceInterface extends TypeResolver {
    public default DataFetcher<graphql.relay.Relay.ResolvedGlobalId> id() {
      return null;
    }

    public default DataFetcher<Double> lat() {
      return null;
    }

    public default DataFetcher<Double> lon() {
      return null;
    }
  }

  public interface GraphQLPlan {
    public DataFetcher<Long> date();

    public DataFetcher<DebugOutput> debugOutput();

    public DataFetcher<StopArrival> from();

    public DataFetcher<Iterable<Itinerary>> itineraries();

    public DataFetcher<Iterable<String>> messageEnums();

    public DataFetcher<Iterable<String>> messageStrings();

    public DataFetcher<Long> nextDateTime();

    public DataFetcher<String> nextPageCursor();

    public DataFetcher<Long> prevDateTime();

    public DataFetcher<String> previousPageCursor();

    public DataFetcher<Iterable<RoutingError>> routingErrors();

    public DataFetcher<Long> searchWindowUsed();

    public DataFetcher<StopArrival> to();
  }

  /**
   * Plan (result of an itinerary search) that follows
   * [GraphQL Cursor Connections Specification](https://relay.dev/graphql/connections.htm).
   */
  public interface GraphQLPlanConnection {
    public DataFetcher<Iterable<DefaultEdge<Itinerary>>> edges();

    public DataFetcher<PlanPageInfo> pageInfo();

    public DataFetcher<Iterable<RoutingError>> routingErrors();

    public DataFetcher<java.time.OffsetDateTime> searchDateTime();
  }

  /**
   * Edge outputted by a plan search. Part of the
   * [GraphQL Cursor Connections Specification](https://relay.dev/graphql/connections.htm).
   */
  public interface GraphQLPlanEdge {
    public DataFetcher<String> cursor();

    public DataFetcher<Itinerary> node();
  }

  /**
   * Information about pagination in a connection. Part of the
   * [GraphQL Cursor Connections Specification](https://relay.dev/graphql/connections.htm).
   */
  public interface GraphQLPlanPageInfo {
    public DataFetcher<String> endCursor();

    public DataFetcher<Boolean> hasNextPage();

    public DataFetcher<Boolean> hasPreviousPage();

    public DataFetcher<java.time.Duration> searchWindowUsed();

    public DataFetcher<String> startCursor();
  }

  /** Stop position at a specific stop. */
  public interface GraphQLPositionAtStop {
    public DataFetcher<Integer> position();
  }

  /** The board/alight position in between two stops of the pattern of a trip with continuous pickup/drop off. */
  public interface GraphQLPositionBetweenStops {
    public DataFetcher<Integer> nextPosition();

    public DataFetcher<Integer> previousPosition();
  }

  public interface GraphQLQueryType {
    public DataFetcher<Iterable<Agency>> agencies();

    public DataFetcher<Agency> agency();

    public DataFetcher<Iterable<TransitAlert>> alerts();

    public DataFetcher<VehicleParking> bikePark();

    public DataFetcher<Iterable<VehicleParking>> bikeParks();

    public DataFetcher<VehicleRentalPlace> bikeRentalStation();

    public DataFetcher<Iterable<VehicleRentalPlace>> bikeRentalStations();

    public DataFetcher<Connection<TripOnServiceDate>> canceledTrips();

    public DataFetcher<Iterable<TripTimeOnDate>> cancelledTripTimes();

    public DataFetcher<VehicleParking> carPark();

    public DataFetcher<Iterable<VehicleParking>> carParks();

    public DataFetcher<Object> cluster();

    public DataFetcher<Iterable<Object>> clusters();

    public DataFetcher<PatternAtStop> departureRow();

    public DataFetcher<Iterable<String>> feeds();

    public DataFetcher<Trip> fuzzyTrip();

    public DataFetcher<Leg> leg();

    public DataFetcher<Connection<PlaceAtDistance>> nearest();

    public DataFetcher<Object> node();

    public DataFetcher<TripPattern> pattern();

    public DataFetcher<Iterable<TripPattern>> patterns();

    public DataFetcher<
      graphql.execution.DataFetcherResult<org.opentripplanner.routing.api.response.RoutingResponse>
    > plan();

    public DataFetcher<
      graphql.execution.DataFetcherResult<org.opentripplanner.routing.api.response.RoutingResponse>
    > planConnection();

    public DataFetcher<VehicleRentalVehicle> rentalVehicle();

    public DataFetcher<Iterable<VehicleRentalVehicle>> rentalVehicles();

    public DataFetcher<Route> route();

    public DataFetcher<Iterable<Route>> routes();

    public DataFetcher<Object> serviceTimeRange();

    public DataFetcher<Object> station();

    public DataFetcher<Iterable<Object>> stations();

    public DataFetcher<Object> stop();

    public DataFetcher<Iterable<Object>> stops();

    public DataFetcher<Iterable<Object>> stopsByBbox();

    public DataFetcher<Connection<NearbyStop>> stopsByRadius();

    public DataFetcher<Iterable<FareRuleSet>> ticketTypes();

    public DataFetcher<Trip> trip();

    public DataFetcher<Iterable<Trip>> trips();

    public DataFetcher<VehicleParking> vehicleParking();

    public DataFetcher<Iterable<VehicleParking>> vehicleParkings();

    public DataFetcher<VehicleRentalStation> vehicleRentalStation();

    public DataFetcher<Iterable<VehicleRentalStation>> vehicleRentalStations();

    public DataFetcher<Iterable<VehicleRentalPlace>> vehicleRentalsByBbox();

    public DataFetcher<Object> viewer();
  }

  /** Real-time estimates for a vehicle at a certain place. */
  public interface GraphQLRealTimeEstimate {
    public DataFetcher<java.time.Duration> delay();

    public DataFetcher<java.time.OffsetDateTime> time();
  }

  /** Rental place union that represents either a VehicleRentalStation or a RentalVehicle */
  public interface GraphQLRentalPlace extends TypeResolver {}

  /** Rental vehicle represents a vehicle that belongs to a rental network. */
  public interface GraphQLRentalVehicle {
    public DataFetcher<Boolean> allowPickupNow();

    public DataFetcher<java.time.OffsetDateTime> availableUntil();

    public DataFetcher<RentalVehicleFuel> fuel();

    public DataFetcher<graphql.relay.Relay.ResolvedGlobalId> id();

    public DataFetcher<Double> lat();

    public DataFetcher<Double> lon();

    public DataFetcher<String> name();

    public DataFetcher<String> network();

    public DataFetcher<Boolean> operative();

    public DataFetcher<VehicleRentalSystem> rentalNetwork();

    public DataFetcher<VehicleRentalStationUris> rentalUris();

    public DataFetcher<String> vehicleId();

    public DataFetcher<RentalVehicleType> vehicleType();
  }

  public interface GraphQLRentalVehicleEntityCounts {
    public DataFetcher<Iterable<RentalVehicleTypeCount>> byType();

    public DataFetcher<Integer> total();
  }

  /** Rental vehicle fuel represent the current status of the battery or fuel of a rental vehicle */
  public interface GraphQLRentalVehicleFuel {
    public DataFetcher<Double> percent();

    public DataFetcher<Integer> range();
  }

  public interface GraphQLRentalVehicleType {
    public DataFetcher<
      org.opentripplanner.apis.gtfs.generated.GraphQLTypes.GraphQLFormFactor
    > formFactor();

    public DataFetcher<
      org.opentripplanner.apis.gtfs.generated.GraphQLTypes.GraphQLPropulsionType
    > propulsionType();
  }

  public interface GraphQLRentalVehicleTypeCount {
    public DataFetcher<Integer> count();

    public DataFetcher<RentalVehicleType> vehicleType();
  }

  /** An estimate for a ride on a hailed vehicle, like an Uber car. */
  public interface GraphQLRideHailingEstimate {
    public DataFetcher<java.time.Duration> arrival();

    public DataFetcher<Money> maxPrice();

    public DataFetcher<Money> minPrice();

    public DataFetcher<String> productName();

    public DataFetcher<RideHailingProvider> provider();
  }

  public interface GraphQLRideHailingProvider {
    public DataFetcher<String> id();
  }

  /** Category of riders a fare product applies to, for example students or pensioners. */
  public interface GraphQLRiderCategory {
    public DataFetcher<String> id();

    public DataFetcher<String> name();
  }

  /**
   * Route represents a public transportation service, usually from point A to point
   * B and *back*, shown to customers under a single name, e.g. bus 550. Routes
   * contain patterns (see field `patterns`), which describe different variants of
   * the route, e.g. outbound pattern from point A to point B and inbound pattern
   * from point B to point A.
   */
  public interface GraphQLRoute {
    public DataFetcher<Agency> agency();

    public DataFetcher<Iterable<TransitAlert>> alerts();

    public DataFetcher<GraphQLBikesAllowed> bikesAllowed();

    public DataFetcher<String> color();

    public DataFetcher<String> desc();

    public DataFetcher<String> gtfsId();

    public DataFetcher<graphql.relay.Relay.ResolvedGlobalId> id();

    public DataFetcher<String> longName();

    public DataFetcher<GraphQLTransitMode> mode();

    public DataFetcher<Iterable<TripPattern>> patterns();

    public DataFetcher<String> shortName();

    public DataFetcher<Integer> sortOrder();

    public DataFetcher<Iterable<Object>> stops();

    public DataFetcher<String> textColor();

    public DataFetcher<Iterable<Trip>> trips();

    public DataFetcher<Integer> type();

    public DataFetcher<String> url();
  }

  /**
   * Route type entity which covers all agencies if agency is null,
   * otherwise only relevant for one agency.
   */
  public interface GraphQLRouteType {
    public DataFetcher<Agency> agency();

    public DataFetcher<Integer> routeType();

    public DataFetcher<Iterable<Route>> routes();
  }

  /** Description of the reason, why the planner did not return any results */
  public interface GraphQLRoutingError {
    public DataFetcher<GraphQLRoutingErrorCode> code();

    public DataFetcher<String> description();

    public DataFetcher<GraphQLInputField> inputField();
  }

  /** A feature for a step */
  public interface GraphQLStepFeature extends TypeResolver {}

  /**
   * Stop can represent either a single public transport stop, where passengers can
   * board and/or disembark vehicles, or a station, which contains multiple stops.
   * See field `locationType`.
   */
  public interface GraphQLStop {
    public DataFetcher<Iterable<TransitAlert>> alerts();

    public DataFetcher<Object> cluster();

    public DataFetcher<String> code();

    public DataFetcher<String> desc();

    public DataFetcher<String> direction();

    public DataFetcher<Object> geometries();

    public DataFetcher<String> gtfsId();

    public DataFetcher<graphql.relay.Relay.ResolvedGlobalId> id();

    public DataFetcher<Double> lat();

    public DataFetcher<Object> locationType();

    public DataFetcher<Double> lon();

    public DataFetcher<String> name();

    public DataFetcher<Object> parentStation();

    public DataFetcher<Iterable<TripPattern>> patterns();

    public DataFetcher<String> platformCode();

    public DataFetcher<Iterable<Route>> routes();

    public DataFetcher<Iterable<TripTimeOnDate>> stopTimesForPattern();

    public DataFetcher<Iterable<Object>> stops();

    public DataFetcher<Iterable<StopTimesInPattern>> stoptimesForPatterns();

    public DataFetcher<Iterable<StopTimesInPattern>> stoptimesForServiceDate();

    public DataFetcher<Iterable<TripTimeOnDate>> stoptimesWithoutPatterns();

    public DataFetcher<String> timezone();

    public DataFetcher<Iterable<NearbyStop>> transfers();

    public DataFetcher<String> url();

    public DataFetcher<String> vehicleMode();

    public DataFetcher<Integer> vehicleType();

    public DataFetcher<
      org.opentripplanner.apis.gtfs.generated.GraphQLTypes.GraphQLWheelchairBoarding
    > wheelchairBoarding();

    public DataFetcher<String> zoneId();
  }

  /**
   * Represents the time or time window when a specific trip on a specific date arrives to and/or departs
   * from a specific stop location.
   *
   * This may contain real-time information, if available.
   */
  public interface GraphQLStopCall {
    public DataFetcher<CallRealTime> realTime();

    public DataFetcher<CallSchedule> schedule();

    public DataFetcher<Object> stopLocation();
  }

  public interface GraphQLStopGeometries {
    public DataFetcher<org.locationtech.jts.geom.Geometry> geoJson();

    public DataFetcher<Iterable<Geometry>> googleEncoded();
  }

  /** Stop that should (but not guaranteed) to exist on a route. */
  public interface GraphQLStopOnRoute {
    public DataFetcher<Route> route();

    public DataFetcher<Object> stop();
  }

  /** Stop that should (but not guaranteed) to exist on a trip. */
  public interface GraphQLStopOnTrip {
    public DataFetcher<Object> stop();

    public DataFetcher<Trip> trip();
  }

  public interface GraphQLStopPosition extends TypeResolver {}

  /** Upcoming or current stop and how close the vehicle is to it. */
  public interface GraphQLStopRelationship {
    public DataFetcher<Object> status();

    public DataFetcher<Object> stop();
  }

  /** Stoptime represents the time when a specific trip arrives to or departs from a specific stop. */
  public interface GraphQLStoptime {
    public DataFetcher<Integer> arrivalDelay();

    public DataFetcher<Integer> departureDelay();

    public DataFetcher<GraphQLPickupDropoffType> dropoffType();

    public DataFetcher<String> headsign();

    public DataFetcher<GraphQLPickupDropoffType> pickupType();

    public DataFetcher<Boolean> realtime();

    public DataFetcher<Integer> realtimeArrival();

    public DataFetcher<Integer> realtimeDeparture();

    public DataFetcher<GraphQLRealtimeState> realtimeState();

    public DataFetcher<Integer> scheduledArrival();

    public DataFetcher<Integer> scheduledDeparture();

    public DataFetcher<Long> serviceDay();

    public DataFetcher<Object> stop();

    public DataFetcher<Integer> stopPosition();

    public DataFetcher<Integer> stopPositionInPattern();

    public DataFetcher<Boolean> timepoint();

    public DataFetcher<Trip> trip();
  }

  /** Stoptimes grouped by pattern */
  public interface GraphQLStoptimesInPattern {
    public DataFetcher<TripPattern> pattern();

    public DataFetcher<Iterable<TripTimeOnDate>> stoptimes();
  }

  /**
   * A system notice is used to tag elements with system information for debugging
   * or other system related purpose. One use-case is to run a routing search with
   * 'debugItineraryFilter: true'. This will then tag itineraries instead of removing
   * them from the result. This make it possible to inspect the itinerary-filter-chain.
   * A SystemNotice only has english text,
   * because the primary user are technical staff, like testers and developers.
   */
  public interface GraphQLSystemNotice {
    public DataFetcher<String> tag();

    public DataFetcher<String> text();
  }

  /** Describes ticket type */
  public interface GraphQLTicketType {
    public DataFetcher<String> currency();

    public DataFetcher<String> fareId();

    public DataFetcher<graphql.relay.Relay.ResolvedGlobalId> id();

    public DataFetcher<Double> price();

    public DataFetcher<Iterable<String>> zones();
  }

  /** A time window when a vehicle visit a stop, area or group of stops. */
  public interface GraphQLTimeWindow {
    public DataFetcher<java.time.OffsetDateTime> end();

    public DataFetcher<java.time.OffsetDateTime> start();
  }

  /** Text with language */
  public interface GraphQLTranslatedString {
    public DataFetcher<String> language();

    public DataFetcher<String> text();
  }

  /** Trip is a specific occurance of a pattern, usually identified by route, direction on the route and exact departure time. */
  public interface GraphQLTrip {
    public DataFetcher<Iterable<String>> activeDates();

    public DataFetcher<Iterable<TransitAlert>> alerts();

    public DataFetcher<TripTimeOnDate> arrivalStoptime();

    public DataFetcher<GraphQLBikesAllowed> bikesAllowed();

    public DataFetcher<String> blockId();

    public DataFetcher<TripTimeOnDate> departureStoptime();

    public DataFetcher<String> directionId();

    public DataFetcher<Iterable<Iterable<Double>>> geometry();

    public DataFetcher<String> gtfsId();

    public DataFetcher<graphql.relay.Relay.ResolvedGlobalId> id();

    public DataFetcher<TripOccupancy> occupancy();

    public DataFetcher<TripPattern> pattern();

    public DataFetcher<Route> route();

    public DataFetcher<String> routeShortName();

    public DataFetcher<String> semanticHash();

    public DataFetcher<String> serviceId();

    public DataFetcher<String> shapeId();

    public DataFetcher<Iterable<Object>> stops();

    public DataFetcher<Iterable<TripTimeOnDate>> stoptimes();

    public DataFetcher<Iterable<TripTimeOnDate>> stoptimesForDate();

    public DataFetcher<Geometry> tripGeometry();

    public DataFetcher<String> tripHeadsign();

    public DataFetcher<String> tripShortName();

    public DataFetcher<
      org.opentripplanner.apis.gtfs.generated.GraphQLTypes.GraphQLWheelchairBoarding
    > wheelchairAccessible();
  }

  /**
   * Occupancy of a vehicle on a trip. This should include the most recent occupancy information
   * available for a trip. Historic data might not be available.
   */
  public interface GraphQLTripOccupancy {
    public DataFetcher<GraphQLOccupancyStatus> occupancyStatus();
  }

  /** A trip on a specific service date. */
  public interface GraphQLTripOnServiceDate {
    public DataFetcher<TripTimeOnDate> end();

    public DataFetcher<java.time.LocalDate> serviceDate();

    public DataFetcher<TripTimeOnDate> start();

    public DataFetcher<Iterable<TripTimeOnDate>> stopCalls();

    public DataFetcher<Trip> trip();
  }

  /**
   * A connection to a list of trips on service dates that follows
   * [GraphQL Cursor Connections Specification](https://relay.dev/graphql/connections.htm).
   */
  public interface GraphQLTripOnServiceDateConnection {
    public DataFetcher<Iterable<Edge<TripOnServiceDate>>> edges();

    public DataFetcher<Object> pageInfo();
  }

  /**
   * An edge for TripOnServiceDate connection. Part of the
   * [GraphQL Cursor Connections Specification](https://relay.dev/graphql/connections.htm).
   */
  public interface GraphQLTripOnServiceDateEdge {
    public DataFetcher<String> cursor();

    public DataFetcher<TripOnServiceDate> node();
  }

  /** This is used for alert entities that we don't explicitly handle or they are missing. */
  public interface GraphQLUnknown {
    public DataFetcher<String> description();
  }

  /** Vehicle parking represents a location where bicycles or cars can be parked. */
  public interface GraphQLVehicleParking {
    public DataFetcher<Boolean> anyCarPlaces();

    public DataFetcher<VehicleParkingSpaces> availability();

    public DataFetcher<Boolean> bicyclePlaces();

    public DataFetcher<VehicleParkingSpaces> capacity();

    public DataFetcher<Boolean> carPlaces();

    public DataFetcher<String> detailsUrl();

    public DataFetcher<graphql.relay.Relay.ResolvedGlobalId> id();

    public DataFetcher<String> imageUrl();

    public DataFetcher<Double> lat();

    public DataFetcher<Double> lon();

    public DataFetcher<String> name();

    public DataFetcher<String> note();

    public DataFetcher<OHCalendar> openingHours();

    public DataFetcher<Boolean> realtime();

    public DataFetcher<VehicleParkingState> state();

    public DataFetcher<Iterable<String>> tags();

    public DataFetcher<String> vehicleParkingId();

    public DataFetcher<Boolean> wheelchairAccessibleCarPlaces();
  }

  /** The number of spaces by type. null if unknown. */
  public interface GraphQLVehicleParkingSpaces {
    public DataFetcher<Integer> bicycleSpaces();

    public DataFetcher<Integer> carSpaces();

    public DataFetcher<Integer> wheelchairAccessibleCarSpaces();
  }

  /** Real-time vehicle position */
  public interface GraphQLVehiclePosition {
    public DataFetcher<Double> heading();

    public DataFetcher<String> label();

    public DataFetcher<java.time.OffsetDateTime> lastUpdate();

    public DataFetcher<Long> lastUpdated();

    public DataFetcher<Double> lat();

    public DataFetcher<Double> lon();

    public DataFetcher<Double> speed();

    public DataFetcher<StopRelationship> stopRelationship();

    public DataFetcher<Trip> trip();

    public DataFetcher<String> vehicleId();
  }

  /**
   * Vehicle rental network, which is referred as system in the GBFS terminology. Note, the same operator can operate in multiple
   * regions either with the same network/system or with a different one. This can contain information about either the rental brand
   * or about the operator.
   */
  public interface GraphQLVehicleRentalNetwork {
    public DataFetcher<String> networkId();

    public DataFetcher<String> url();
  }

  /** Vehicle rental station represents a location where users can rent bicycles etc. for a fee. */
  public interface GraphQLVehicleRentalStation {
    public DataFetcher<Boolean> allowDropoff();

    public DataFetcher<Boolean> allowDropoffNow();

    public DataFetcher<Boolean> allowOverloading();

    public DataFetcher<Boolean> allowPickup();

    public DataFetcher<Boolean> allowPickupNow();

    public DataFetcher<RentalVehicleEntityCounts> availableSpaces();

    public DataFetcher<RentalVehicleEntityCounts> availableVehicles();

    public DataFetcher<Integer> capacity();

    public DataFetcher<graphql.relay.Relay.ResolvedGlobalId> id();

    public DataFetcher<Double> lat();

    public DataFetcher<Double> lon();

    public DataFetcher<String> name();

    public DataFetcher<String> network();

    public DataFetcher<Boolean> operative();

    public DataFetcher<Boolean> realtime();

    public DataFetcher<VehicleRentalSystem> rentalNetwork();

    public DataFetcher<VehicleRentalStationUris> rentalUris();

    public DataFetcher<Integer> spacesAvailable();

    public DataFetcher<String> stationId();

    public DataFetcher<Integer> vehiclesAvailable();
  }

  public interface GraphQLVehicleRentalUris {
    public DataFetcher<String> android();

    public DataFetcher<String> ios();

    public DataFetcher<String> web();
  }

  public interface GraphQLDebugOutput {
    public DataFetcher<Long> pathCalculationTime();

    public DataFetcher<Long> precalculationTime();

    public DataFetcher<Long> renderingTime();

    public DataFetcher<Boolean> timedOut();

    public DataFetcher<Long> totalTime();
  }

  public interface GraphQLElevationProfileComponent {
    public DataFetcher<Double> distance();

    public DataFetcher<Double> elevation();
  }

  /**
   * This type is only here for backwards-compatibility and this API will never return it anymore.
   * Please use the leg's `fareProducts` instead.
   */
  public interface GraphQLFare {
    public DataFetcher<Integer> cents();

    public DataFetcher<Iterable<Object>> components();

    public DataFetcher<String> currency();

    public DataFetcher<String> type();
  }

  /**
   * This type is only here for backwards-compatibility and this API will never return it anymore.
   * Please use the leg's `fareProducts` instead.
   */
  public interface GraphQLFareComponent {
    public DataFetcher<Integer> cents();

    public DataFetcher<String> currency();

    public DataFetcher<String> fareId();

    public DataFetcher<Iterable<Route>> routes();
  }

  public interface GraphQLPlaceAtDistance {
    public DataFetcher<Integer> distance();

    public DataFetcher<graphql.relay.Relay.ResolvedGlobalId> id();

    public DataFetcher<Object> place();
  }

  /** A connection to a list of items. */
  public interface GraphQLPlaceAtDistanceConnection {
    public DataFetcher<Iterable<Edge<PlaceAtDistance>>> edges();

    public DataFetcher<Object> pageInfo();
  }

  /** An edge in a connection. */
  public interface GraphQLPlaceAtDistanceEdge {
    public DataFetcher<String> cursor();

    public DataFetcher<PlaceAtDistance> node();
  }

  /** Time range for which the API has data available */
  public interface GraphQLServiceTimeRange {
    public DataFetcher<Long> end();

    public DataFetcher<Long> start();
  }

  public interface GraphQLStep {
    public DataFetcher<GraphQLAbsoluteDirection> absoluteDirection();

    public DataFetcher<Iterable<TransitAlert>> alerts();

    public DataFetcher<Boolean> area();

    public DataFetcher<Boolean> bogusName();

    public DataFetcher<Double> distance();

    public DataFetcher<
      Iterable<org.opentripplanner.model.plan.leg.ElevationProfile.Step>
    > elevationProfile();

    public DataFetcher<String> exit();

    public DataFetcher<Object> feature();

    public DataFetcher<Double> lat();

    public DataFetcher<Double> lon();

    public DataFetcher<GraphQLRelativeDirection> relativeDirection();

    public DataFetcher<Boolean> stayOn();

    public DataFetcher<String> streetName();

    public DataFetcher<Boolean> walkingBike();
  }

  public interface GraphQLStopAtDistance {
    public DataFetcher<Integer> distance();

    public DataFetcher<graphql.relay.Relay.ResolvedGlobalId> id();

    public DataFetcher<Object> stop();
  }

  /** A connection to a list of items. */
  public interface GraphQLStopAtDistanceConnection {
    public DataFetcher<Iterable<Edge<NearbyStop>>> edges();

    public DataFetcher<Object> pageInfo();
  }

  /** An edge in a connection. */
  public interface GraphQLStopAtDistanceEdge {
    public DataFetcher<String> cursor();

    public DataFetcher<NearbyStop> node();
  }
}
