/*
 * Decompiled with CFR 0.152.
 */
package org.opentest4j.reporting.tooling.validator;

import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.opentest4j.reporting.tooling.validator.Severity;
import org.opentest4j.reporting.tooling.validator.ValidationMessage;

public class ValidationResult
implements Iterable<ValidationMessage> {
    private final List<ValidationMessage> messages;

    ValidationResult(List<ValidationMessage> messages) {
        this.messages = List.copyOf(messages);
    }

    public long count(Severity severity) {
        return this.messages.stream().filter(m -> severity.equals((Object)m.getSeverity())).count();
    }

    @Override
    public Iterator<ValidationMessage> iterator() {
        return this.messages.iterator();
    }

    public String toString() {
        return this.messages.stream().map(Objects::toString).collect(Collectors.joining("\n"));
    }
}

