/*
 * Decompiled with CFR 0.152.
 */
package org.opentest4j.reporting.tooling.validator;

import java.util.Objects;

public class Location {
    private final String path;
    private final int lineNumber;
    private final int column;

    Location(String path, int lineNumber, int column) {
        this.path = path;
        this.lineNumber = lineNumber;
        this.column = column;
    }

    public String getPath() {
        return this.path;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int getColumn() {
        return this.column;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Location location = (Location)o;
        return this.lineNumber == location.lineNumber && this.column == location.column && this.path.equals(location.path);
    }

    public int hashCode() {
        return Objects.hash(this.path, this.lineNumber, this.column);
    }

    public String toString() {
        return String.format("%s:%d:%d", this.path, this.lineNumber, this.column);
    }
}

