/*
 * Decompiled with CFR 0.152.
 */
package org.opentest4j.reporting.tooling.validator;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.xml.catalog.CatalogFeatures;
import javax.xml.catalog.CatalogManager;
import javax.xml.catalog.CatalogResolver;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.SchemaFactory;
import org.opentest4j.reporting.schema.Namespace;
import org.opentest4j.reporting.tooling.validator.Location;
import org.opentest4j.reporting.tooling.validator.Severity;
import org.opentest4j.reporting.tooling.validator.ValidationMessage;
import org.opentest4j.reporting.tooling.validator.ValidationResult;
import org.opentest4j.reporting.tooling.validator.Validator;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class DefaultValidator
implements Validator {
    private static final Map<Namespace, String> SCHEMAS = Map.of(Namespace.REPORTING_EVENTS, "/org/opentest4j/reporting/schema/events.xsd", Namespace.REPORTING_HIERARCHY, "/org/opentest4j/reporting/schema/hierarchy.xsd", Namespace.REPORTING_CORE, "/org/opentest4j/reporting/schema/core.xsd", Namespace.REPORTING_JAVA, "/org/opentest4j/reporting/schema/java.xsd");
    private final SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
    private final CatalogResolver catalogResolver;

    public DefaultValidator(URI ... catalogs) {
        CatalogFeatures features = CatalogFeatures.builder().with(CatalogFeatures.Feature.RESOLVE, "continue").build();
        this.catalogResolver = CatalogManager.catalogResolver(features, catalogs);
    }

    @Override
    public ValidationResult validate(Path xmlFile) {
        ValidationResult validationResult;
        block8: {
            InputStream in = Files.newInputStream(xmlFile, new OpenOption[0]);
            try {
                validationResult = this.validateSafely(xmlFile, new StreamSource(in));
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new RuntimeException("Failure during validation: " + xmlFile, e);
                }
            }
            in.close();
        }
        return validationResult;
    }

    private ValidationResult validateSafely(Path xmlFile, Source source) throws SAXException, IOException {
        CollectingErrorHandler errorHandler = new CollectingErrorHandler(xmlFile);
        this.validate(source, errorHandler);
        return errorHandler.toValidationResult();
    }

    private void validate(Source source, ErrorHandler errorHandler) throws SAXException, IOException {
        javax.xml.validation.Validator validator = this.schemaFactory.newSchema().newValidator();
        validator.setResourceResolver(this.createResourceResolver());
        validator.setErrorHandler(errorHandler);
        validator.validate(source);
    }

    private LSResourceResolver createResourceResolver() {
        return (type, namespaceURI, publicId, systemId, baseURI) -> {
            Namespace namespace;
            if (namespaceURI != null && SCHEMAS.containsKey(namespace = Namespace.of((String)namespaceURI))) {
                LSInputImpl input = new LSInputImpl();
                input.setPublicId(publicId);
                String schema = SCHEMAS.get(namespace);
                input.setSystemId(Objects.requireNonNull(Namespace.class.getResource(schema)).toExternalForm());
                input.setBaseURI(baseURI);
                InputStream stream = Namespace.class.getResourceAsStream(schema);
                input.setCharacterStream(new InputStreamReader(Objects.requireNonNull(stream)));
                return input;
            }
            if (systemId != null) {
                return this.catalogResolver.resolveResource(type, namespaceURI, publicId, systemId, baseURI);
            }
            return null;
        };
    }

    private static class CollectingErrorHandler
    implements ErrorHandler {
        private final Path xmlFile;
        private final List<ValidationMessage> messages = new ArrayList<ValidationMessage>();

        public CollectingErrorHandler(Path xmlFile) {
            this.xmlFile = xmlFile;
        }

        @Override
        public void warning(SAXParseException e) {
            this.addValidationMessage(Severity.WARNING, e);
        }

        @Override
        public void error(SAXParseException e) {
            this.addValidationMessage(Severity.ERROR, e);
        }

        private void addValidationMessage(Severity severity, SAXParseException e) {
            String path = e.getSystemId() == null ? this.xmlFile.toString() : e.getSystemId();
            Location location = new Location(path, e.getLineNumber(), e.getColumnNumber());
            this.messages.add(new ValidationMessage(severity, location, e.getMessage()));
        }

        @Override
        public void fatalError(SAXParseException e) throws SAXParseException {
            throw e;
        }

        public ValidationResult toValidationResult() {
            return new ValidationResult(this.messages);
        }
    }

    static class LSInputImpl
    implements LSInput {
        private Reader characterStream;
        private InputStream byteStream;
        private String stringData;
        private String systemId;
        private String publicId;
        private String baseURI;
        private String encoding;
        private boolean certifiedText;

        LSInputImpl() {
        }

        @Override
        public Reader getCharacterStream() {
            return this.characterStream;
        }

        @Override
        public void setCharacterStream(Reader characterStream) {
            this.characterStream = characterStream;
        }

        @Override
        public InputStream getByteStream() {
            return this.byteStream;
        }

        @Override
        public void setByteStream(InputStream byteStream) {
            this.byteStream = byteStream;
        }

        @Override
        public String getStringData() {
            return this.stringData;
        }

        @Override
        public void setStringData(String stringData) {
            this.stringData = stringData;
        }

        @Override
        public String getSystemId() {
            return this.systemId;
        }

        @Override
        public void setSystemId(String systemId) {
            this.systemId = systemId;
        }

        @Override
        public String getPublicId() {
            return this.publicId;
        }

        @Override
        public void setPublicId(String publicId) {
            this.publicId = publicId;
        }

        @Override
        public String getBaseURI() {
            return this.baseURI;
        }

        @Override
        public void setBaseURI(String baseURI) {
            this.baseURI = baseURI;
        }

        @Override
        public String getEncoding() {
            return this.encoding;
        }

        @Override
        public void setEncoding(String encoding) {
            this.encoding = encoding;
        }

        @Override
        public boolean getCertifiedText() {
            return this.certifiedText;
        }

        @Override
        public void setCertifiedText(boolean certifiedText) {
            this.certifiedText = certifiedText;
        }
    }
}

