/*
 * Decompiled with CFR 0.152.
 */
package org.opentest4j.reporting.tooling.converter;

import java.nio.file.Path;
import java.time.Duration;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.IntFunction;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.opentest4j.reporting.events.core.Infrastructure;
import org.opentest4j.reporting.events.root.Event;
import org.opentest4j.reporting.events.root.Finished;
import org.opentest4j.reporting.events.root.Reported;
import org.opentest4j.reporting.events.root.Started;
import org.opentest4j.reporting.schema.Namespace;
import org.opentest4j.reporting.schema.QualifiedName;
import org.opentest4j.reporting.tooling.converter.Converter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DefaultConverter
implements Converter {
    private static final String HIERARCHY_PREFIX = "h";
    private static final String EXECUTION_NODE_NAME = "h:execution";
    private static final String ROOT_NODE_NAME = "h:root";
    private static final String CHILD_NODE_NAME = "h:child";
    private static final String START_ATTRIBUTE_NAME = "start";
    private static final String DURATION_ATTRIBUTE_NAME = "duration";
    private static final Set<String> EVENT_ONLY_ATTRIBUTES = Stream.of(Event.ID, Event.TIME, Started.PARENT_ID).map(QualifiedName::getSimpleName).collect(Collectors.toUnmodifiableSet());

    @Override
    public void convert(Path eventsXmlFile, Path hierarchicalXmlFile) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document sourceDocument = builder.parse(eventsXmlFile.toFile());
        Element sourceRoot = sourceDocument.getDocumentElement();
        Document targetDocument = builder.newDocument();
        this.createRootElement(sourceRoot, targetDocument);
        HashMap<String, Element> nodeById = new HashMap<String, Element>();
        for (Node child = sourceRoot.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof Element)) continue;
            Element element = (Element)child;
            if (this.matches(Started.ELEMENT, element)) {
                this.started(targetDocument, nodeById, element);
                continue;
            }
            if (this.matches(Reported.ELEMENT, element)) {
                this.reported(nodeById, element);
                continue;
            }
            if (this.matches(Finished.ELEMENT, element)) {
                this.finished(nodeById, element);
                continue;
            }
            if (!this.matches(Infrastructure.ELEMENT, element)) continue;
            this.infrastructure(targetDocument, element);
        }
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        transformerFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        transformer.transform(new DOMSource(targetDocument), new StreamResult(hierarchicalXmlFile.toFile()));
    }

    private void createRootElement(Node sourceRoot, Document targetDocument) {
        Element targetRoot = targetDocument.createElement(EXECUTION_NODE_NAME);
        targetDocument.appendChild(targetRoot);
        this.copyAttributes(sourceRoot, targetRoot, (__, value) -> !Namespace.REPORTING_EVENTS.getUri().equals(value));
        targetRoot.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:h", Namespace.REPORTING_HIERARCHY.getUri());
    }

    private boolean matches(QualifiedName qualifiedName, Element element) {
        return qualifiedName.getNamespace().getUri().equals(element.getNamespaceURI()) && qualifiedName.getSimpleName().equals(element.getLocalName());
    }

    private void infrastructure(Document targetDocument, Element sourceElement) {
        Node targetElement = sourceElement.cloneNode(true);
        targetDocument.adoptNode(targetElement);
        targetDocument.getDocumentElement().appendChild(targetElement);
    }

    private void started(Document targetDocument, Map<String, Element> nodeById, Element sourceElement) {
        Element targetElement;
        if (sourceElement.hasAttribute(Started.PARENT_ID.getSimpleName())) {
            targetElement = targetDocument.createElementNS(Namespace.REPORTING_HIERARCHY.getUri(), CHILD_NODE_NAME);
            nodeById.get(sourceElement.getAttribute(Started.PARENT_ID.getSimpleName())).appendChild(targetElement);
        } else {
            targetElement = targetDocument.createElementNS(Namespace.REPORTING_HIERARCHY.getUri(), ROOT_NODE_NAME);
            targetDocument.getDocumentElement().appendChild(targetElement);
        }
        String id = sourceElement.getAttribute(Event.ID.getSimpleName());
        nodeById.put(id, targetElement);
        this.copyAttributes(sourceElement, targetElement, (name, __) -> !EVENT_ONLY_ATTRIBUTES.contains(name));
        this.copyChildren(sourceElement, targetElement);
        if (sourceElement.hasAttribute(Event.TIME.getSimpleName())) {
            targetElement.setAttribute(START_ATTRIBUTE_NAME, sourceElement.getAttribute(Event.TIME.getSimpleName()));
        }
    }

    private void reported(Map<String, Element> nodeById, Element sourceElement) {
        Element targetElement = nodeById.get(sourceElement.getAttribute(Event.ID.getSimpleName()));
        this.copyAttributes(sourceElement, targetElement, (name, __) -> !EVENT_ONLY_ATTRIBUTES.contains(name));
        this.mergeChildren(sourceElement, targetElement);
    }

    private void finished(Map<String, Element> nodeById, Element sourceElement) {
        Element targetElement = nodeById.get(sourceElement.getAttribute(Event.ID.getSimpleName()));
        this.copyAttributes(sourceElement, targetElement, (name, __) -> !EVENT_ONLY_ATTRIBUTES.contains(name));
        this.mergeChildren(sourceElement, targetElement);
        if (targetElement.hasAttribute(START_ATTRIBUTE_NAME) && sourceElement.hasAttribute(Event.TIME.getSimpleName())) {
            Instant start = Instant.parse(targetElement.getAttribute(START_ATTRIBUTE_NAME));
            Instant finish = Instant.parse(sourceElement.getAttribute(Event.TIME.getSimpleName()));
            targetElement.setAttribute(DURATION_ATTRIBUTE_NAME, Duration.between(start, finish).toString());
        }
        this.moveChildrenToEnd(targetElement);
    }

    private void moveChildrenToEnd(Element targetElement) {
        DefaultConverter.stream(targetElement.getChildNodes()).filter(child -> CHILD_NODE_NAME.equals(child.getNodeName())).collect(Collectors.toList()).forEach(child -> {
            targetElement.removeChild((Node)child);
            targetElement.appendChild((Node)child);
        });
    }

    private void copyAttributes(Node sourceNode, Node targetNode, BiPredicate<String, String> filter) {
        DefaultConverter.stream(sourceNode.getAttributes()).filter(sourceItem -> filter.test(sourceItem.getNodeName(), sourceItem.getNodeValue())).map(sourceItem -> sourceItem.cloneNode(true)).forEach(targetItem -> {
            targetNode.getOwnerDocument().adoptNode((Node)targetItem);
            targetNode.getAttributes().setNamedItem((Node)targetItem);
        });
    }

    private void mergeChildren(Node sourceElement, Node targetElement) {
        DefaultConverter.stream(sourceElement.getChildNodes()).forEach(sourceChild -> this.findNode(targetElement.getChildNodes(), sourceChild.getNodeName()).ifPresentOrElse(existingNode -> this.copyChildren((Node)sourceChild, (Node)existingNode), () -> {
            Node targetChild = sourceChild.cloneNode(true);
            targetElement.getOwnerDocument().adoptNode(targetChild);
            targetElement.appendChild(targetChild);
        }));
    }

    private Optional<Node> findNode(NodeList nodes, String name) {
        return DefaultConverter.stream(nodes).filter(node -> node.getNodeName().equals(name)).findAny();
    }

    private void copyChildren(Node sourceElement, Node targetElement) {
        DefaultConverter.stream(sourceElement.getChildNodes()).map(sourceChild -> sourceChild.cloneNode(true)).forEach(targetChild -> {
            targetElement.getOwnerDocument().adoptNode((Node)targetChild);
            targetElement.appendChild((Node)targetChild);
        });
    }

    private static Stream<Node> stream(NodeList nodeList) {
        return DefaultConverter.stream(nodeList.getLength(), nodeList::item);
    }

    private static Stream<Node> stream(NamedNodeMap namedNodeMap) {
        return DefaultConverter.stream(namedNodeMap.getLength(), namedNodeMap::item);
    }

    private static Stream<Node> stream(int length, IntFunction<Node> item) {
        return IntStream.range(0, length).mapToObj(item);
    }
}

