/*
 * Decompiled with CFR 0.152.
 */
package org.opentest4j.reporting.events.java;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.opentest4j.reporting.events.api.ChildElement;
import org.opentest4j.reporting.events.api.Context;
import org.opentest4j.reporting.events.core.Result;
import org.opentest4j.reporting.schema.Namespace;
import org.opentest4j.reporting.schema.QualifiedName;

public class Throwable
extends ChildElement<Result, Throwable> {
    private static final QualifiedName ELEMENT = QualifiedName.of((Namespace)Namespace.REPORTING_JAVA, (String)"throwable");
    private static final QualifiedName TYPE = QualifiedName.of((Namespace)Namespace.REPORTING_JAVA, (String)"type");
    private static final QualifiedName ASSERTION_ERROR = QualifiedName.of((Namespace)Namespace.REPORTING_JAVA, (String)"assertionError");

    Throwable(Context context) {
        super(context, ELEMENT);
    }

    Throwable withThrowable(java.lang.Throwable throwable) {
        this.withAttribute(TYPE, throwable.getClass().getName());
        this.withAttribute(ASSERTION_ERROR, String.valueOf(throwable instanceof AssertionError));
        StringWriter stringWriter = new StringWriter();
        try (PrintWriter writer = new PrintWriter(stringWriter);){
            throwable.printStackTrace(writer);
        }
        this.withCDataSection(stringWriter.toString());
        return this;
    }
}

