/*
 * Decompiled with CFR 0.152.
 */
package org.opentest4j.reporting.events.api;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.opentest4j.reporting.schema.Namespace;

public class NamespaceRegistry {
    static final String XSI_PREFIX = "xsi";
    private final Namespace defaultNamespace;
    private final Map<Namespace, String> schemaLocations;
    private final Map<Namespace, String> additionalNamespaces;

    public static Builder builder(Namespace defaultNamespace) {
        return new Builder(defaultNamespace, null);
    }

    public static Builder builder(Namespace defaultNamespace, String schemaLocation) {
        return new Builder(defaultNamespace, schemaLocation);
    }

    private NamespaceRegistry(Namespace defaultNamespace, Map<Namespace, String> schemaLocations, Map<Namespace, String> additionalNamespaces) {
        this.defaultNamespace = defaultNamespace;
        this.schemaLocations = Collections.unmodifiableMap(new LinkedHashMap<Namespace, String>(schemaLocations));
        this.additionalNamespaces = Collections.unmodifiableMap(new LinkedHashMap<Namespace, String>(additionalNamespaces));
    }

    public Namespace getDefaultNamespace() {
        return this.defaultNamespace;
    }

    public Set<Namespace> getAdditionalNamespaces() {
        return this.additionalNamespaces.keySet();
    }

    public Optional<String> getPrefix(Namespace namespace) {
        return Optional.ofNullable(this.additionalNamespaces.get(namespace));
    }

    public Map<Namespace, String> getSchemaLocations() {
        return this.schemaLocations;
    }

    public boolean containsUri(String uri) {
        return this.defaultNamespace.getUri().equals(uri) || this.additionalNamespaces.containsKey(Namespace.of((String)uri));
    }

    public static class Builder {
        private final Namespace defaultNamespace;
        private final Map<Namespace, String> schemaLocations = new LinkedHashMap<Namespace, String>();
        private final Map<Namespace, String> additionalNamespaces = new LinkedHashMap<Namespace, String>();

        private Builder(Namespace defaultNamespace, String schemaLocation) {
            this.defaultNamespace = defaultNamespace;
            if (schemaLocation != null) {
                this.schemaLocations.put(defaultNamespace, schemaLocation);
            }
        }

        public Builder add(String prefix, Namespace namespace) {
            return this.add(prefix, namespace, null);
        }

        public Builder add(String prefix, Namespace namespace, String schemaLocation) {
            if (this.additionalNamespaces.containsKey(namespace) || this.defaultNamespace.equals((Object)namespace)) {
                throw new IllegalStateException("Namespace has already been added previously: " + namespace);
            }
            this.additionalNamespaces.put(namespace, prefix);
            if (schemaLocation != null) {
                this.schemaLocations.put(namespace, schemaLocation);
            }
            return this;
        }

        public NamespaceRegistry build() {
            if (!this.schemaLocations.isEmpty()) {
                this.add(NamespaceRegistry.XSI_PREFIX, Namespace.XML_SCHEMA_INSTANCE);
            }
            return new NamespaceRegistry(this.defaultNamespace, this.schemaLocations, this.additionalNamespaces);
        }
    }
}

