/*
 * Decompiled with CFR 0.152.
 */
package org.opentest4j.reporting.events.api;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stax.StAXResult;
import org.opentest4j.reporting.events.api.ChildElement;
import org.opentest4j.reporting.events.api.Context;
import org.opentest4j.reporting.events.api.DocumentWriter;
import org.opentest4j.reporting.events.api.Element;
import org.opentest4j.reporting.events.api.Factory;
import org.opentest4j.reporting.events.api.NamespaceRegistry;
import org.opentest4j.reporting.schema.Namespace;
import org.opentest4j.reporting.schema.QualifiedName;

class DefaultDocumentWriter<T extends Element<T>>
implements DocumentWriter<T> {
    private final BufferedWriter bufferedWriter;
    private final XMLStreamWriter xmlWriter;
    private final Context context;
    private final Transformer transformer;
    private final SingleElementStreamWriter elementXmlWriter;

    DefaultDocumentWriter(QualifiedName rootElementName, NamespaceRegistry namespaceRegistry, Writer writer) throws Exception {
        XMLOutputFactory factory = XMLOutputFactory.newInstance();
        this.bufferedWriter = DefaultDocumentWriter.buffered(writer);
        this.xmlWriter = factory.createXMLStreamWriter(writer);
        this.xmlWriter.writeStartDocument();
        this.bufferedWriter.newLine();
        this.writeStartElement(rootElementName, namespaceRegistry);
        this.writeNamespaces(namespaceRegistry);
        this.writeSchemaLocations(namespaceRegistry);
        this.xmlWriter.writeCharacters("");
        this.elementXmlWriter = new SingleElementStreamWriter(this.xmlWriter, namespaceRegistry);
        this.context = Context.create(rootElementName, namespaceRegistry);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        transformerFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        this.transformer = transformerFactory.newTransformer();
        this.transformer.setOutputProperty("method", "xml");
    }

    private void writeStartElement(QualifiedName rootElement, NamespaceRegistry namespaceRegistry) throws XMLStreamException {
        Optional<String> prefix = namespaceRegistry.getPrefix(rootElement.getNamespace());
        if (prefix.isPresent()) {
            this.xmlWriter.writeStartElement(prefix.get(), rootElement.getSimpleName(), rootElement.getNamespace().getUri());
        } else {
            this.xmlWriter.writeStartElement(rootElement.getSimpleName());
        }
    }

    private void writeNamespaces(NamespaceRegistry namespaceRegistry) throws XMLStreamException {
        this.xmlWriter.writeDefaultNamespace(namespaceRegistry.getDefaultNamespace().getUri());
        for (Namespace namespace : namespaceRegistry.getAdditionalNamespaces()) {
            Optional<String> prefix = namespaceRegistry.getPrefix(namespace);
            if (!prefix.isPresent()) continue;
            this.xmlWriter.writeNamespace(prefix.get(), namespace.getUri());
        }
    }

    private void writeSchemaLocations(NamespaceRegistry namespaceRegistry) throws XMLStreamException {
        if (!namespaceRegistry.getSchemaLocations().isEmpty()) {
            String value = namespaceRegistry.getSchemaLocations().entrySet().stream().map(e -> ((Namespace)e.getKey()).getUri() + " " + (String)e.getValue()).collect(Collectors.joining(" "));
            this.xmlWriter.writeAttribute("xsi", "http://www.w3.org/2001/XMLSchema-instance", "schemaLocation", value);
        }
    }

    private static BufferedWriter buffered(Writer writer) {
        return writer instanceof BufferedWriter ? (BufferedWriter)writer : new BufferedWriter(writer);
    }

    @Override
    public synchronized <C extends ChildElement<T, ? super C>> DocumentWriter<T> append(Factory<C> creator, Consumer<? super C> configurer) {
        ChildElement event = (ChildElement)creator.createAndConfigure(this.context, configurer);
        try {
            this.bufferedWriter.newLine();
            org.w3c.dom.Element domElement = event.getDomElement();
            domElement.normalize();
            this.transformer.transform(new DOMSource(domElement), new StAXResult(this.elementXmlWriter));
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to write event: " + event, e);
        }
        return this;
    }

    @Override
    public void close() throws IOException {
        try {
            this.bufferedWriter.newLine();
            this.xmlWriter.writeEndDocument();
            this.xmlWriter.close();
        }
        catch (XMLStreamException e) {
            throw new IOException("Failed to write XML", e);
        }
        finally {
            this.bufferedWriter.close();
        }
    }

    private static class SingleElementStreamWriter
    implements XMLStreamWriter {
        private final XMLStreamWriter delegate;
        private final NamespaceRegistry namespaceRegistry;

        public SingleElementStreamWriter(XMLStreamWriter delegate, NamespaceRegistry namespaceRegistry) {
            this.delegate = delegate;
            this.namespaceRegistry = namespaceRegistry;
        }

        @Override
        public void writeStartElement(String localName) throws XMLStreamException {
            this.delegate.writeStartElement(localName);
        }

        @Override
        public void writeStartElement(String namespaceURI, String localName) throws XMLStreamException {
            this.delegate.writeStartElement(namespaceURI, localName);
        }

        @Override
        public void writeStartElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
            this.delegate.writeStartElement(prefix, localName, namespaceURI);
        }

        @Override
        public void writeEmptyElement(String namespaceURI, String localName) throws XMLStreamException {
            this.delegate.writeEmptyElement(namespaceURI, localName);
        }

        @Override
        public void writeEmptyElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
            this.delegate.writeEmptyElement(prefix, localName, namespaceURI);
        }

        @Override
        public void writeEmptyElement(String localName) throws XMLStreamException {
            this.delegate.writeEmptyElement(localName);
        }

        @Override
        public void writeEndElement() throws XMLStreamException {
            this.delegate.writeEndElement();
        }

        @Override
        public void writeEndDocument() {
        }

        @Override
        public void close() throws XMLStreamException {
            this.delegate.close();
        }

        @Override
        public void flush() throws XMLStreamException {
            this.delegate.flush();
        }

        @Override
        public void writeAttribute(String localName, String value) throws XMLStreamException {
            this.delegate.writeAttribute(localName, value);
        }

        @Override
        public void writeAttribute(String prefix, String namespaceURI, String localName, String value) throws XMLStreamException {
            this.delegate.writeAttribute(prefix, namespaceURI, localName, value);
        }

        @Override
        public void writeAttribute(String namespaceURI, String localName, String value) throws XMLStreamException {
            this.delegate.writeAttribute(namespaceURI, localName, value);
        }

        @Override
        public void writeNamespace(String prefix, String namespaceURI) throws XMLStreamException {
            if (!this.namespaceRegistry.containsUri(namespaceURI)) {
                this.delegate.writeNamespace(prefix, namespaceURI);
            }
        }

        @Override
        public void writeDefaultNamespace(String namespaceURI) {
        }

        @Override
        public void writeComment(String data) throws XMLStreamException {
            this.delegate.writeComment(data);
        }

        @Override
        public void writeProcessingInstruction(String target) throws XMLStreamException {
            this.delegate.writeProcessingInstruction(target);
        }

        @Override
        public void writeProcessingInstruction(String target, String data) throws XMLStreamException {
            this.delegate.writeProcessingInstruction(target, data);
        }

        @Override
        public void writeCData(String data) throws XMLStreamException {
            this.delegate.writeCData(data);
        }

        @Override
        public void writeDTD(String dtd) throws XMLStreamException {
            this.delegate.writeDTD(dtd);
        }

        @Override
        public void writeEntityRef(String name) throws XMLStreamException {
            this.delegate.writeEntityRef(name);
        }

        @Override
        public void writeStartDocument() {
        }

        @Override
        public void writeStartDocument(String version) {
        }

        @Override
        public void writeStartDocument(String encoding, String version) {
        }

        @Override
        public void writeCharacters(String text) throws XMLStreamException {
            this.delegate.writeCharacters(text);
        }

        @Override
        public void writeCharacters(char[] text, int start, int len) throws XMLStreamException {
            this.delegate.writeCharacters(text, start, len);
        }

        @Override
        public String getPrefix(String uri) throws XMLStreamException {
            return this.delegate.getPrefix(uri);
        }

        @Override
        public void setPrefix(String prefix, String uri) throws XMLStreamException {
            this.delegate.setPrefix(prefix, uri);
        }

        @Override
        public void setDefaultNamespace(String uri) throws XMLStreamException {
            this.delegate.setDefaultNamespace(uri);
        }

        @Override
        public void setNamespaceContext(NamespaceContext context) throws XMLStreamException {
            this.delegate.setNamespaceContext(context);
        }

        @Override
        public NamespaceContext getNamespaceContext() {
            return this.delegate.getNamespaceContext();
        }

        @Override
        public Object getProperty(String name) throws IllegalArgumentException {
            return this.delegate.getProperty(name);
        }
    }
}

