/*
 * Decompiled with CFR 0.152.
 */
package org.opentest4j.reporting.cli;

import java.net.URI;
import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.Callable;
import org.opentest4j.reporting.tooling.validator.DefaultValidator;
import org.opentest4j.reporting.tooling.validator.Severity;
import org.opentest4j.reporting.tooling.validator.ValidationResult;
import org.opentest4j.reporting.tooling.validator.Validator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="validate", description={"Validates XML report files of both formats"})
public class ValidateCommand
implements Callable<Integer> {
    private static final Logger LOG = LoggerFactory.getLogger(ValidateCommand.class);
    @CommandLine.Parameters(arity="1..*")
    List<Path> xmlFiles;
    @CommandLine.Option(names={"--catalog"})
    List<Path> catalogs = List.of();

    @Override
    public Integer call() {
        return this.validateAll() ? 0 : 1;
    }

    private boolean validateAll() {
        DefaultValidator validator = new DefaultValidator((URI[])this.catalogs.stream().map(Path::toUri).toArray(URI[]::new));
        boolean allValid = true;
        for (Path xmlFile : this.xmlFiles) {
            allValid &= this.validate((Validator)validator, xmlFile);
        }
        return allValid;
    }

    private boolean validate(Validator validator, Path xmlFile) {
        try {
            ValidationResult validationResult = validator.validate(xmlFile);
            this.logValidationMessages(validationResult);
            long errors = validationResult.count(Severity.ERROR);
            if (errors == 0L) {
                LOG.info("Valid: {}", (Object)xmlFile);
                return true;
            }
            LOG.info("Invalid ({} {}): {}", new Object[]{errors, errors == 1L ? "error" : "errors", xmlFile});
            return false;
        }
        catch (Exception e) {
            LOG.error("Failure during validation: {}", (Object)xmlFile, (Object)e);
            return false;
        }
    }

    private void logValidationMessages(ValidationResult validationResult) {
        validationResult.forEach(message -> {
            if (message.getSeverity() == Severity.WARNING) {
                LOG.warn("{}\n{}", (Object)message.getLocation(), (Object)message.getMessage());
            } else {
                LOG.error("{}\n{}", (Object)message.getLocation(), (Object)message.getMessage());
            }
        });
    }
}

