/*
 * Decompiled with CFR 0.152.
 */
package org.opentest4j.reporting.cli;

import java.nio.file.Path;
import java.util.concurrent.Callable;
import org.opentest4j.reporting.tooling.converter.DefaultConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="convert", description={"Converts from the event-based to the hierarchical XML format"})
public class ConvertCommand
implements Callable<Integer> {
    private static final Logger LOG = LoggerFactory.getLogger(ConvertCommand.class);
    @CommandLine.Parameters(arity="1")
    Path eventsXml;

    @Override
    public Integer call() throws Exception {
        Path targetFile = this.eventsXml.resolveSibling("hierarchy.xml");
        DefaultConverter converter = new DefaultConverter();
        converter.convert(this.eventsXml, targetFile);
        LOG.info("Converted {} to {}", (Object)this.eventsXml, (Object)targetFile);
        return 0;
    }
}

