/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.mutator.testing;

import com.google.common.collect.Lists;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.stream.Collectors;
import org.openstreetmap.atlas.geography.Located;
import org.openstreetmap.atlas.geography.Rectangle;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.builder.RelationBean;
import org.openstreetmap.atlas.geography.atlas.change.AtlasChangeGenerator;
import org.openstreetmap.atlas.geography.atlas.change.FeatureChange;
import org.openstreetmap.atlas.geography.atlas.change.testing.AtlasChangeGeneratorAddTurnRestrictions;
import org.openstreetmap.atlas.geography.atlas.complete.CompleteEdge;
import org.openstreetmap.atlas.geography.atlas.complete.CompleteEntity;
import org.openstreetmap.atlas.geography.atlas.complete.CompleteNode;
import org.openstreetmap.atlas.geography.atlas.complete.CompleteRelation;
import org.openstreetmap.atlas.geography.atlas.items.AtlasEntity;
import org.openstreetmap.atlas.geography.atlas.items.AtlasObject;
import org.openstreetmap.atlas.geography.atlas.items.Edge;
import org.openstreetmap.atlas.geography.atlas.items.ItemType;
import org.openstreetmap.atlas.geography.atlas.items.Node;
import org.openstreetmap.atlas.geography.atlas.items.Relation;
import org.openstreetmap.atlas.mutator.configuration.mutators.ConfiguredAtlasChangeGenerator;
import org.openstreetmap.atlas.utilities.collections.Maps;
import org.openstreetmap.atlas.utilities.collections.Sets;
import org.openstreetmap.atlas.utilities.configuration.Configuration;
import org.openstreetmap.atlas.utilities.configuration.ConfigurationReader;
import org.openstreetmap.atlas.utilities.identifiers.EntityIdentifierGenerator;

public class ConfiguredAtlasChangeGeneratorAddTurnRestrictions
extends ConfiguredAtlasChangeGenerator {
    private static final long serialVersionUID = -7944726872773507489L;
    private final AtlasChangeGenerator atlasChangeGeneratorAddTurnRestrictions;
    private final int minimumNodeValence;

    public ConfiguredAtlasChangeGeneratorAddTurnRestrictions(String name, Configuration configuration) {
        super(name, configuration);
        int valence;
        ConfigurationReader reader = new ConfigurationReader(name);
        this.minimumNodeValence = valence = Integer.parseInt((String)reader.configurationValue(configuration, "node.valence", (Object)"3"));
        this.atlasChangeGeneratorAddTurnRestrictions = new AtlasChangeGeneratorAddTurnRestrictions(valence);
    }

    @Override
    public boolean equals(Object other) {
        return super.equals(other);
    }

    public Set<FeatureChange> generateWithoutValidation(Atlas atlas) {
        EntityIdentifierGenerator identifierGenerator = new EntityIdentifierGenerator();
        HashSet<FeatureChange> result = new HashSet<FeatureChange>();
        Long parentRelationIdentifier = 999L;
        RelationBean parentMembers = new RelationBean();
        Rectangle parentBounds = null;
        for (Node node2 : atlas.nodes(node -> node.valence() > (long)this.minimumNodeValence)) {
            SortedSet inEdges = node2.inEdges();
            SortedSet outEdges = node2.outEdges();
            Iterator iterator = inEdges.iterator();
            if (!iterator.hasNext()) continue;
            Edge inEdge = (Edge)iterator.next();
            Iterator iterator2 = outEdges.iterator();
            if (!iterator2.hasNext()) continue;
            Edge outEdge = (Edge)iterator2.next();
            RelationBean members = new RelationBean();
            members.addItem(Long.valueOf(inEdge.getIdentifier()), "from", ItemType.EDGE);
            inEdge.reversed().ifPresent(reversed -> members.addItem(Long.valueOf(reversed.getIdentifier()), "from", ItemType.EDGE));
            members.addItem(Long.valueOf(node2.getIdentifier()), "via", ItemType.NODE);
            members.addItem(Long.valueOf(outEdge.getIdentifier()), "to", ItemType.EDGE);
            outEdge.reversed().ifPresent(reversed -> members.addItem(Long.valueOf(reversed.getIdentifier()), "to", ItemType.EDGE));
            Rectangle bounds = Rectangle.forLocated((Located[])new Located[]{inEdge, outEdge});
            parentBounds = parentBounds == null ? bounds : Rectangle.forLocated((Located[])new Located[]{parentBounds, bounds});
            CompleteRelation completeRelation = new CompleteRelation(Long.valueOf(0L), Maps.hashMap((Object[])new String[]{"type", "restriction", "restriction", "no_left_turn"}), bounds, members, (List)Lists.newArrayList((Object[])new Long[]{0L}), members, Long.valueOf(0L), Sets.hashSet((Object[])new Long[]{parentRelationIdentifier}));
            Long relationIdentifier = identifierGenerator.generateIdentifier((CompleteEntity)completeRelation);
            parentMembers.addItem(relationIdentifier, "addition", ItemType.RELATION);
            result.add(FeatureChange.add((AtlasEntity)new CompleteRelation(relationIdentifier, Maps.hashMap((Object[])new String[]{"type", "restriction", "restriction", "no_left_turn"}), bounds, members, (List)Lists.newArrayList((Object[])new Long[]{relationIdentifier}), members, relationIdentifier, Sets.hashSet((Object[])new Long[]{parentRelationIdentifier}))));
            result.add(FeatureChange.add((AtlasEntity)CompleteEdge.shallowFrom((Edge)inEdge).withRelationIdentifiers(this.mergeRelationMembers(inEdge.relations(), relationIdentifier))));
            if (inEdge.hasReverseEdge()) {
                result.add(FeatureChange.add((AtlasEntity)CompleteEdge.shallowFrom((Edge)((Edge)inEdge.reversed().get())).withRelationIdentifiers(this.mergeRelationMembers(inEdge.relations(), relationIdentifier))));
            }
            result.add(FeatureChange.add((AtlasEntity)CompleteNode.shallowFrom((Node)node2).withRelationIdentifiers(this.mergeRelationMembers(node2.relations(), relationIdentifier))));
            result.add(FeatureChange.add((AtlasEntity)CompleteEdge.shallowFrom((Edge)outEdge).withRelationIdentifiers(this.mergeRelationMembers(outEdge.relations(), relationIdentifier))));
            if (!outEdge.hasReverseEdge()) continue;
            result.add(FeatureChange.add((AtlasEntity)CompleteEdge.shallowFrom((Edge)((Edge)outEdge.reversed().get())).withRelationIdentifiers(this.mergeRelationMembers(outEdge.relations(), relationIdentifier))));
        }
        if (!result.isEmpty()) {
            result.add(FeatureChange.add((AtlasEntity)new CompleteRelation(parentRelationIdentifier, Maps.hashMap((Object[])new String[]{"name", "parent_of_new_restrictions"}), parentBounds, parentMembers, (List)Lists.newArrayList((Object[])new Long[]{parentRelationIdentifier}), parentMembers, parentRelationIdentifier, Sets.hashSet((Object[])new Long[0]))));
        }
        return result;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    private Set<Long> mergeRelationMembers(Set<Relation> relations, Long newIdentifier) {
        return Sets.withSets((Set[])new Set[]{relations.stream().map(AtlasObject::getIdentifier).collect(Collectors.toSet()), Sets.hashSet((Object[])new Long[]{newIdentifier})});
    }
}

