/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.mutator.testing;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.change.FeatureChange;
import org.openstreetmap.atlas.geography.atlas.complete.CompleteEntity;
import org.openstreetmap.atlas.geography.atlas.items.AtlasEntity;
import org.openstreetmap.atlas.mutator.configuration.mutators.ConfiguredAtlasChangeGenerator;
import org.openstreetmap.atlas.utilities.configuration.Configuration;
import org.openstreetmap.atlas.utilities.configuration.ConfigurationReader;
import org.openstreetmap.atlas.utilities.configuration.ConfiguredFilter;

public class AtlasChangeGeneratorAddTag
extends ConfiguredAtlasChangeGenerator {
    private static final long serialVersionUID = -5027030876937712437L;
    private final String key;
    private final String value;
    private final ConfiguredFilter filter;
    private final boolean shallow;

    public AtlasChangeGeneratorAddTag(String name, Configuration configuration) {
        super(name, configuration);
        ConfigurationReader reader = new ConfigurationReader(name);
        this.key = (String)reader.configurationValue(configuration, "tag.key", (Object)"unknownKey");
        this.value = (String)reader.configurationValue(configuration, "tag.value", (Object)"unknownValue");
        this.filter = ConfiguredFilter.from((String)((String)reader.configurationValue(configuration, "predicate", (Object)"default")), (Configuration)configuration);
        this.shallow = (Boolean)reader.configurationValue(configuration, "shallow", (Object)false);
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof AtlasChangeGeneratorAddTag) {
            return super.equals(other) && this.key.equals(((AtlasChangeGeneratorAddTag)other).key) && this.value.equals(((AtlasChangeGeneratorAddTag)other).value) && this.filter.equals(((AtlasChangeGeneratorAddTag)other).filter);
        }
        return false;
    }

    public Set<FeatureChange> generateWithoutValidation(Atlas atlas) {
        HashSet<FeatureChange> result = new HashSet<FeatureChange>();
        for (AtlasEntity entity : atlas.entities((Predicate)this.filter)) {
            String keyInternal = this.getKey(entity);
            String valueInternal = this.getValue(entity);
            CompleteEntity completeEntity = this.createFrom(entity).withAddedTag(keyInternal, "sparkConfiguration".equals(keyInternal) ? this.getSparkConfiguration().toString() : valueInternal);
            result.add(FeatureChange.add((AtlasEntity)((AtlasEntity)completeEntity)));
        }
        return result;
    }

    public String getKey(AtlasEntity entity) {
        return this.key;
    }

    public String getValue(AtlasEntity entity) {
        return this.value;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.key, this.value, this.filter);
    }

    private CompleteEntity createFrom(AtlasEntity entity) {
        if (this.shallow) {
            return ((CompleteEntity)CompleteEntity.shallowFrom((AtlasEntity)entity)).withTags(entity.getTags());
        }
        return (CompleteEntity)CompleteEntity.from((AtlasEntity)entity);
    }
}

