/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.mutator.testing;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.atlas.items.AtlasEntity;
import org.openstreetmap.atlas.geography.sharding.Shard;
import org.openstreetmap.atlas.geography.sharding.Sharding;
import org.openstreetmap.atlas.mutator.testing.AtlasChangeGeneratorAddTag;
import org.openstreetmap.atlas.utilities.collections.StringList;
import org.openstreetmap.atlas.utilities.configuration.Configuration;

public class AtlasChangeGeneratorAddShard
extends AtlasChangeGeneratorAddTag {
    private static final long serialVersionUID = 782434242891149771L;
    private List<Sharding> shardings = null;

    public AtlasChangeGeneratorAddShard(String name, Configuration configuration) {
        super(name, configuration);
    }

    @Override
    public boolean equals(Object other) {
        return super.equals(other);
    }

    @Override
    public String getValue(AtlasEntity entity) {
        this.setup();
        StringList result = new StringList();
        for (Sharding sharding : this.shardings) {
            result.add(((Shard)sharding.shardsCovering(entity.bounds().center()).iterator().next()).getName());
        }
        return result.join(",");
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    private void setup() {
        if (this.shardings == null) {
            this.shardings = new ArrayList<Sharding>();
            for (String broadcastName : this.getBroadcastVariablesNeeded().keySet()) {
                Object broadcasted = this.getBroadcastVariable(broadcastName);
                if (broadcasted instanceof Sharding) {
                    this.shardings.add((Sharding)broadcasted);
                    continue;
                }
                if (broadcasted instanceof Map) {
                    this.shardings.addAll(((Map)broadcasted).values());
                    continue;
                }
                throw new CoreException("Cannot recognize broadcast variable of type {}", new Object[]{broadcasted.getClass().getSimpleName()});
            }
        }
    }
}

