/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.mutator.filtering;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.Location;
import org.openstreetmap.atlas.geography.MultiPolygon;
import org.openstreetmap.atlas.geography.PolyLine;
import org.openstreetmap.atlas.geography.Polygon;
import org.openstreetmap.atlas.geography.Rectangle;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.change.AtlasEntityKey;
import org.openstreetmap.atlas.geography.atlas.change.Change;
import org.openstreetmap.atlas.geography.atlas.change.ChangeBuilder;
import org.openstreetmap.atlas.geography.atlas.change.ChangeType;
import org.openstreetmap.atlas.geography.atlas.change.FeatureChange;
import org.openstreetmap.atlas.geography.atlas.complete.CompleteEntity;
import org.openstreetmap.atlas.geography.atlas.complete.CompleteNode;
import org.openstreetmap.atlas.geography.atlas.dynamic.DynamicAtlas;
import org.openstreetmap.atlas.geography.atlas.items.Area;
import org.openstreetmap.atlas.geography.atlas.items.AtlasEntity;
import org.openstreetmap.atlas.geography.atlas.items.Edge;
import org.openstreetmap.atlas.geography.atlas.items.ItemType;
import org.openstreetmap.atlas.geography.atlas.items.LineItem;
import org.openstreetmap.atlas.geography.atlas.items.LocationItem;
import org.openstreetmap.atlas.geography.atlas.items.Node;
import org.openstreetmap.atlas.geography.atlas.items.Relation;
import org.openstreetmap.atlas.geography.atlas.items.RelationMemberList;
import org.openstreetmap.atlas.geography.sharding.Shard;
import org.openstreetmap.atlas.utilities.collections.Iterables;
import org.openstreetmap.atlas.utilities.collections.MultiIterable;
import org.openstreetmap.atlas.utilities.collections.StreamIterable;
import org.openstreetmap.atlas.utilities.tuples.Tuple;

public class ChangeFilter
implements Function<Change, Optional<Change>> {
    private static final Predicate<Map.Entry<String, String>> MUTATOR_TAG_PREDICATE = entry -> entry.getKey() != null && ((String)entry.getKey()).startsWith("mutator:");
    private final DynamicAtlas atlas;
    private final Shard shard;

    public static Change changeWithoutMutatorTag(Change input, Predicate<FeatureChange> entitiesToConsider) {
        ChangeBuilder result = new ChangeBuilder();
        input.changes().map(featureChange -> ChangeFilter.featureChangeWithoutMutatorTag(featureChange, entitiesToConsider)).forEach(arg_0 -> ((ChangeBuilder)result).add(arg_0));
        return result.get();
    }

    public static Map<String, String> mutatorMetaDataFromTags(Change change, Predicate<FeatureChange> entitiesToConsider) {
        return change.changes().filter(entitiesToConsider).filter(featureChange -> featureChange.getTags() != null).flatMap(featureChange -> featureChange.getTags().entrySet().stream().filter(MUTATOR_TAG_PREDICATE).map(entry -> new Tuple((Object)((String)entry.getKey() + ":" + featureChange.getItemType().name() + ":" + featureChange.getIdentifier()), (Object)((String)entry.getValue())))).collect(Collectors.toMap(Tuple::getFirst, Tuple::getSecond));
    }

    public static Optional<Change> stripForSaving(Change change) {
        return ChangeFilter.createChange(change.getFeatureChanges().stream().filter(featureChange -> !featureChange.getMetaData().isEmpty()).collect(Collectors.toList()));
    }

    static FeatureChange featureChangeWithoutMutatorTag(FeatureChange input, Predicate<FeatureChange> entitiesToConsider) {
        if (ChangeType.ADD == input.getChangeType() && entitiesToConsider.test(input) && input.getTags() != null) {
            Set<String> keysToRemove = input.getAfterView().getTags().entrySet().stream().filter(MUTATOR_TAG_PREDICATE).map(Map.Entry::getKey).collect(Collectors.toSet());
            keysToRemove.forEach(key -> input.getAfterView().getTags().remove(key));
        }
        return input;
    }

    private static Optional<Change> createChange(Iterable<FeatureChange> featureChanges) {
        ChangeBuilder result = new ChangeBuilder();
        featureChanges.forEach(arg_0 -> ((ChangeBuilder)result).add(arg_0));
        if (result.peekNumberOfChanges() > 0) {
            return Optional.of(result.get());
        }
        return Optional.empty();
    }

    public ChangeFilter(DynamicAtlas atlas) {
        this.atlas = atlas;
        this.shard = null;
    }

    public ChangeFilter(Shard shard) {
        this.atlas = null;
        this.shard = shard;
    }

    @Override
    public Optional<Change> apply(Change change) {
        if (this.atlas != null) {
            return this.stripUnwantedFeatures(change);
        }
        return this.stripUnwantedFeaturesWithoutAtlas(change);
    }

    private Set<Edge> connectedEdges(FeatureChange featureChange, Change change) {
        HashSet<Edge> connectedEdges = new HashSet<Edge>();
        CompleteNode node = (CompleteNode)featureChange.getAfterView();
        Set inEdgeIdentifiers = node.inEdgeIdentifiers();
        Set outEdgeIdentifiers = node.outEdgeIdentifiers();
        HashSet connectedEdgeIdentifiers = new HashSet();
        if (inEdgeIdentifiers != null) {
            connectedEdgeIdentifiers.addAll(inEdgeIdentifiers);
        }
        if (outEdgeIdentifiers != null) {
            connectedEdgeIdentifiers.addAll(outEdgeIdentifiers);
        }
        connectedEdgeIdentifiers.stream().map(edgeIdentifier -> {
            Optional<Edge> edgeOption;
            Edge originalEdge = this.atlas.edge(edgeIdentifier.longValue());
            if (originalEdge == null && (edgeOption = change.getFeatureChanges().stream().filter(changeFeatureChange -> changeFeatureChange.getIdentifier() == edgeIdentifier.longValue() && changeFeatureChange.getItemType() == ItemType.EDGE).findFirst().map(FeatureChange::getAfterView).map(atlasEntity -> (Edge)atlasEntity)).isPresent()) {
                originalEdge = edgeOption.get();
            }
            return originalEdge;
        }).filter(Objects::nonNull).forEach(connectedEdges::add);
        return connectedEdges;
    }

    private Predicate<FeatureChange> edgeOverlap(MultiPolygon initialShardBounds) {
        return featureChange -> {
            if (ItemType.EDGE == featureChange.getItemType() && ChangeType.ADD == featureChange.getChangeType()) {
                PolyLine shapeBefore;
                Edge beforeView;
                ArrayList<PolyLine> shapes = new ArrayList<PolyLine>();
                Edge afterView = (Edge)featureChange.getAfterView();
                PolyLine shapeAfter = afterView.asPolyLine();
                if (shapeAfter != null) {
                    shapes.add(shapeAfter);
                }
                if ((beforeView = (Edge)featureChange.getBeforeView()) != null && (shapeBefore = beforeView.asPolyLine()) != null) {
                    shapes.add(shapeBefore);
                }
                if (shapes.isEmpty()) {
                    if (this.atlas == null) {
                        throw new CoreException("There should never be an ADD EDGE FeatureChange with no geometry in before/after views and no pre-existing atlas to reference it:\n{}", new Object[]{featureChange.prettify()});
                    }
                    Edge edgeFromAtlas = this.atlas.edge(featureChange.getIdentifier());
                    if (edgeFromAtlas == null) {
                        throw new CoreException("There should never be an ADD EDGE FeatureChange with no geometry in before/after views and no pre-existing corresponding feature in the Atlas to apply it to:\n{}", new Object[]{featureChange.prettify()});
                    }
                    shapes.add(edgeFromAtlas.asPolyLine());
                }
                return shapes.stream().anyMatch(arg_0 -> ((MultiPolygon)initialShardBounds).overlaps(arg_0));
            }
            return true;
        };
    }

    private Predicate<FeatureChange> overlap(MultiPolygon initialShardBounds, Change originalChange) {
        return featureChange -> {
            if (featureChange.getItemType() == ItemType.EDGE) {
                return this.edgeOverlap(initialShardBounds).test((FeatureChange)featureChange);
            }
            if (featureChange.getItemType() == ItemType.RELATION) {
                return this.relationOverlap(initialShardBounds, originalChange).test((FeatureChange)featureChange);
            }
            return true;
        };
    }

    private void populateAreas(long memberIdentifier, Map<AtlasEntityKey, FeatureChange> keyToFeatureChangeMap, Set<Polygon> areas) {
        FeatureChange memberFeatureChange;
        Polygon areaFromFeatureChange;
        AtlasEntityKey atlasEntityKeyArea;
        Area areaFromAtlas;
        if (this.atlas != null && (areaFromAtlas = this.atlas.area(memberIdentifier)) != null) {
            areas.add(areaFromAtlas.asPolygon());
        }
        if (keyToFeatureChangeMap.containsKey(atlasEntityKeyArea = AtlasEntityKey.from((ItemType)ItemType.AREA, (Long)memberIdentifier)) && (areaFromFeatureChange = ((Area)(memberFeatureChange = keyToFeatureChangeMap.get(atlasEntityKeyArea)).getAfterView()).asPolygon()) != null) {
            areas.add(areaFromFeatureChange);
        }
    }

    private void populateLines(long memberIdentifier, ItemType memberType, Map<AtlasEntityKey, FeatureChange> keyToFeatureChangeMap, Set<PolyLine> lines) {
        FeatureChange memberFeatureChange;
        PolyLine lineFromFeatureChange;
        AtlasEntityKey atlasEntityKeyLine;
        LineItem lineFromAtlas;
        if (this.atlas != null && (lineFromAtlas = (LineItem)this.atlas.entity(memberIdentifier, memberType)) != null) {
            lines.add(lineFromAtlas.asPolyLine());
        }
        if (keyToFeatureChangeMap.containsKey(atlasEntityKeyLine = AtlasEntityKey.from((ItemType)memberType, (Long)memberIdentifier)) && (lineFromFeatureChange = ((LineItem)(memberFeatureChange = keyToFeatureChangeMap.get(atlasEntityKeyLine)).getAfterView()).asPolyLine()) != null) {
            lines.add(lineFromFeatureChange);
        }
    }

    private void populatePoints(long memberIdentifier, ItemType memberType, Map<AtlasEntityKey, FeatureChange> keyToFeatureChangeMap, Set<Location> points) {
        FeatureChange memberFeatureChange;
        Location pointFromFeatureChange;
        AtlasEntityKey atlasEntityKeyPoint;
        LocationItem pointFromAtlas;
        if (this.atlas != null && (pointFromAtlas = (LocationItem)this.atlas.entity(memberIdentifier, memberType)) != null) {
            points.add(pointFromAtlas.getLocation());
        }
        if (keyToFeatureChangeMap.containsKey(atlasEntityKeyPoint = AtlasEntityKey.from((ItemType)memberType, (Long)memberIdentifier)) && (pointFromFeatureChange = ((LocationItem)(memberFeatureChange = keyToFeatureChangeMap.get(atlasEntityKeyPoint)).getAfterView()).getLocation()) != null) {
            points.add(pointFromFeatureChange);
        }
    }

    private void populateRelationShapes(Change originalChange, long relationIdentifier, Set<Polygon> areas, Set<PolyLine> lines, Set<Location> points) {
        RelationMemberList afterMembers;
        Map keyToFeatureChangeMap = originalChange.allChangesMappedByAtlasEntityKey();
        Relation afterView = null;
        if (keyToFeatureChangeMap.containsKey(AtlasEntityKey.from((ItemType)ItemType.RELATION, (Long)relationIdentifier))) {
            afterView = (Relation)((FeatureChange)keyToFeatureChangeMap.get(AtlasEntityKey.from((ItemType)ItemType.RELATION, (Long)relationIdentifier))).getAfterView();
        }
        Relation source = null;
        if (this.atlas != null) {
            source = this.atlas.relation(relationIdentifier);
        }
        ArrayList members = new ArrayList();
        if (source != null) {
            members.addAll(source.members());
        }
        if (afterView != null && (afterMembers = afterView.members()) != null) {
            members.addAll(afterMembers);
        }
        if (!members.isEmpty()) {
            members.forEach(relationMember -> {
                AtlasEntity memberEntity = relationMember.getEntity();
                ItemType memberType = memberEntity.getType();
                long memberIdentifier = memberEntity.getIdentifier();
                switch (memberType) {
                    case AREA: {
                        this.populateAreas(memberIdentifier, keyToFeatureChangeMap, areas);
                        break;
                    }
                    case LINE: 
                    case EDGE: {
                        this.populateLines(memberIdentifier, memberType, keyToFeatureChangeMap, lines);
                        break;
                    }
                    case NODE: 
                    case POINT: {
                        this.populatePoints(memberIdentifier, memberType, keyToFeatureChangeMap, points);
                        break;
                    }
                    case RELATION: {
                        this.populateRelationShapes(originalChange, memberIdentifier, areas, lines, points);
                        break;
                    }
                    default: {
                        throw new CoreException("Unknown type");
                    }
                }
            });
        }
    }

    private Predicate<FeatureChange> relationOverlap(MultiPolygon initialShardBounds, Change originalChange) {
        return featureChange -> {
            if (ItemType.RELATION != featureChange.getItemType()) return true;
            if (ChangeType.ADD != featureChange.getChangeType()) return true;
            HashSet<Polygon> areas = new HashSet<Polygon>();
            HashSet<PolyLine> lines = new HashSet<PolyLine>();
            HashSet<Location> points = new HashSet<Location>();
            this.populateRelationShapes(originalChange, featureChange.getIdentifier(), areas, lines, points);
            if (areas.stream().anyMatch(arg_0 -> ((MultiPolygon)initialShardBounds).overlaps(arg_0))) return true;
            if (lines.stream().anyMatch(arg_0 -> ((MultiPolygon)initialShardBounds).overlaps(arg_0))) return true;
            if (!points.stream().anyMatch(arg_0 -> ((MultiPolygon)initialShardBounds).fullyGeometricallyEncloses(arg_0))) return false;
            return true;
        };
    }

    private Predicate<FeatureChange> shouldKeepExtraneousEdgeRemoval(Set<String> initialShardNames) {
        return featureChange -> {
            if (ItemType.EDGE == featureChange.getItemType() && ChangeType.REMOVE == featureChange.getChangeType() && initialShardNames.size() == 1) {
                String initialShardName = (String)initialShardNames.iterator().next();
                String metaDataMutatorSource = (String)featureChange.getMetaData().get("mutator");
                return metaDataMutatorSource == null || metaDataMutatorSource.contains(initialShardName);
            }
            return true;
        };
    }

    private Predicate<FeatureChange> shouldKeepExtraneousFeatureChange(Change change, Set<String> initialShardNames) {
        return this.shouldKeepExtraneousEdgeRemoval(initialShardNames).and(this.shouldKeepExtraneousNodeUpdate(change, initialShardNames));
    }

    private Predicate<FeatureChange> shouldKeepExtraneousNodeUpdate(Change change, Set<String> initialShardNames) {
        return featureChange -> {
            if (ItemType.NODE == featureChange.getItemType() && ChangeType.ADD == featureChange.getChangeType() && initialShardNames.size() == 1) {
                String initialShardName = (String)initialShardNames.iterator().next();
                String metaDataMutatorSource = (String)featureChange.getMetaData().get("mutator");
                Node originalNode = this.atlas.node(featureChange.getIdentifier());
                HashSet<Edge> connectedEdges = new HashSet<Edge>();
                if (originalNode != null) {
                    connectedEdges.addAll(originalNode.connectedEdges());
                }
                connectedEdges.addAll(this.connectedEdges((FeatureChange)featureChange, change));
                Rectangle shardBounds = ((Shard)this.atlas.getPolicy().getInitialShards().iterator().next()).bounds();
                return metaDataMutatorSource == null || metaDataMutatorSource.contains(initialShardName) || connectedEdges.stream().filter(edge -> edge.asPolyLine() != null).anyMatch(edge -> shardBounds.overlaps(edge.asPolyLine()));
            }
            return true;
        };
    }

    private Optional<Change> stripUnwantedFeatures(Change change) {
        MultiPolygon initialShardBounds = this.atlas.getPolicy().getInitialShardsBounds();
        Set<String> initialShardNames = this.atlas.getPolicy().getInitialShards().stream().map(Shard::getName).collect(Collectors.toSet());
        List filteredChanges = change.changes().filter(featureChange -> featureChange.afterViewIsFull() || this.atlas.entity(featureChange.getIdentifier(), featureChange.getItemType()) != null).filter(this.overlap(initialShardBounds, change)).filter(this.shouldKeepExtraneousFeatureChange(change, initialShardNames)).collect(Collectors.toList());
        Set filteredChangeIdentifiers = filteredChanges.stream().filter(featureChange -> (featureChange.getItemType() == ItemType.EDGE || featureChange.getItemType() == ItemType.RELATION) && featureChange.getChangeType() == ChangeType.ADD).map(featureChange -> AtlasEntityKey.from((ItemType)featureChange.getItemType(), (Long)featureChange.getIdentifier())).collect(Collectors.toSet());
        StreamIterable additionalRemoves = Iterables.stream((Iterable)new MultiIterable(new Iterable[]{this.atlas.edges(), this.atlas.relations()})).filter(entity -> !filteredChangeIdentifiers.contains(AtlasEntityKey.from((ItemType)entity.getType(), (Long)entity.getIdentifier()))).filter(entity -> !this.overlap(initialShardBounds, change).test(FeatureChange.add((AtlasEntity)CompleteEntity.from((AtlasEntity)entity)))).map(entity -> FeatureChange.remove((AtlasEntity)CompleteEntity.shallowFrom((AtlasEntity)entity), (Atlas)this.atlas));
        MultiIterable result = new MultiIterable(new Iterable[]{filteredChanges, additionalRemoves});
        return ChangeFilter.createChange((Iterable<FeatureChange>)result);
    }

    private Optional<Change> stripUnwantedFeaturesWithoutAtlas(Change change) {
        MultiPolygon initialShardBounds = MultiPolygon.forPolygon((Polygon)this.shard.bounds());
        Iterable filteredChanges = change.changes().filter(FeatureChange::afterViewIsFull).filter(this.overlap(initialShardBounds, change)).collect(Collectors.toList());
        return ChangeFilter.createChange(filteredChanges);
    }
}

