/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.mutator.configuration.util;

import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;
import org.apache.commons.lang.Validate;

public final class ClasspathUtil {
    public static String fromClasspath(String classpathLocation) {
        Validate.notEmpty((String)classpathLocation, (String)"The classpath is EMPTY.");
        try {
            byte[] aqlBytes = Files.readAllBytes(Paths.get(ClasspathUtil.class.getResource(classpathLocation).toURI()));
            return new String(aqlBytes, Charset.defaultCharset());
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Couldn't load: " + classpathLocation, exception);
        }
    }

    private ClasspathUtil() {
    }
}

