/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.mutator.configuration.parsing.provider.file;

import java.util.Map;
import java.util.Optional;
import org.openstreetmap.atlas.generator.PbfLocator;
import org.openstreetmap.atlas.generator.persistence.scheme.SlippyTilePersistenceScheme;
import org.openstreetmap.atlas.geography.MultiPolygon;
import org.openstreetmap.atlas.geography.Polygon;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.pbf.AtlasLoadingOption;
import org.openstreetmap.atlas.geography.atlas.raw.creation.RawAtlasGenerator;
import org.openstreetmap.atlas.geography.sharding.Shard;
import org.openstreetmap.atlas.mutator.configuration.parsing.provider.file.AbstractFileAtlasProvider;
import org.openstreetmap.atlas.mutator.configuration.parsing.provider.file.HadoopPbfFileCache;
import org.openstreetmap.atlas.streaming.resource.Resource;
import org.openstreetmap.atlas.streaming.resource.StringResource;
import org.openstreetmap.atlas.tags.Taggable;
import org.openstreetmap.atlas.tags.filters.ConfiguredTaggableFilter;
import org.openstreetmap.atlas.tags.filters.matcher.TaggableMatcher;
import org.openstreetmap.atlas.utilities.configuration.Configuration;
import org.openstreetmap.atlas.utilities.configuration.ConfigurationReader;
import org.openstreetmap.atlas.utilities.configuration.StandardConfiguration;
import org.openstreetmap.atlas.utilities.time.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PbfRawAtlasProvider
extends AbstractFileAtlasProvider {
    private static final Logger logger = LoggerFactory.getLogger(PbfRawAtlasProvider.class);
    private static final String CONFIGURATION_PBF_NODE = "pbfNode";
    private static final String CONFIGURATION_PBF_WAY = "pbfWay";
    private static final String CONFIGURATION_PBF_RELATION = "pbfRelation";
    private static final String CONFIGURATION_PBF_SCHEME = "pbfScheme";
    private static final long serialVersionUID = 219796406525700034L;
    private final TaggableMatcher pbfNodeMatcher;
    private final TaggableMatcher pbfWayMatcher;
    private final TaggableMatcher pbfRelationMatcher;
    private final SlippyTilePersistenceScheme pbfScheme;
    private transient HadoopPbfFileCache cache;

    public PbfRawAtlasProvider(Configuration configuration) {
        String root = "";
        ConfigurationReader reader = new ConfigurationReader("");
        String pbfNode = (String)reader.configurationValue(configuration, CONFIGURATION_PBF_NODE, (Object)"");
        String pbfWay = (String)reader.configurationValue(configuration, CONFIGURATION_PBF_WAY, (Object)"");
        String pbfRelation = (String)reader.configurationValue(configuration, CONFIGURATION_PBF_RELATION, (Object)"");
        String pbfSchemeString = (String)reader.configurationValue(configuration, CONFIGURATION_PBF_SCHEME, (Object)PbfLocator.DEFAULT_SCHEME);
        this.pbfNodeMatcher = TaggableMatcher.from((String)pbfNode);
        this.pbfWayMatcher = TaggableMatcher.from((String)pbfWay);
        this.pbfRelationMatcher = TaggableMatcher.from((String)pbfRelation);
        this.pbfScheme = SlippyTilePersistenceScheme.getSchemeInstanceFromString(pbfSchemeString);
    }

    @Override
    public void setAtlasProviderContext(Map<String, Object> context) {
        super.setAtlasProviderContext(context);
        this.cache = new HadoopPbfFileCache(this.getAtlasPath(), this.pbfScheme, this.getSparkConfiguration());
    }

    @Override
    protected Optional<Resource> getResourceFromCache(String country, Shard shard) {
        return this.cache.get(shard);
    }

    @Override
    protected void invalidateCache(String country, Shard shard) {
        this.cache.invalidate(shard);
    }

    @Override
    protected Optional<Atlas> resourceToAtlas(Resource resource, String country, Shard shard) {
        AtlasLoadingOption atlasLoadingOption = AtlasLoadingOption.createOptionWithNoSlicing();
        atlasLoadingOption.setCountryCode(country);
        StandardConfiguration emptyConfiguration = new StandardConfiguration((Resource)new StringResource("{filters:[]}"));
        atlasLoadingOption.setOsmPbfNodeFilter(new ConfiguredTaggableFilter((Configuration)emptyConfiguration){
            private static final long serialVersionUID = 4881464932217937980L;

            public boolean test(Taggable taggable) {
                return PbfRawAtlasProvider.this.pbfNodeMatcher.test(taggable);
            }
        });
        atlasLoadingOption.setOsmPbfWayFilter(new ConfiguredTaggableFilter((Configuration)emptyConfiguration){
            private static final long serialVersionUID = -3018918280683785215L;

            public boolean test(Taggable taggable) {
                return PbfRawAtlasProvider.this.pbfWayMatcher.test(taggable);
            }
        });
        atlasLoadingOption.setOsmPbfRelationFilter(new ConfiguredTaggableFilter((Configuration)emptyConfiguration){
            private static final long serialVersionUID = -4496334067178504004L;

            public boolean test(Taggable taggable) {
                return PbfRawAtlasProvider.this.pbfRelationMatcher.test(taggable);
            }
        });
        logger.debug("Loading PBF to Atlas from Resource {}", (Object)resource.getName());
        Time start = Time.now();
        Atlas result = new RawAtlasGenerator(resource, atlasLoadingOption, MultiPolygon.forPolygon((Polygon)shard.bounds())).build();
        logger.debug("Loaded PBF to Atlas from Resource {} in {}. Atlas result: {}", new Object[]{resource.getName(), start.elapsedSince(), result});
        return Optional.ofNullable(result);
    }
}

