/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.mutator.configuration.parsing.provider.file;

import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.generator.persistence.scheme.SlippyTilePersistenceScheme;
import org.openstreetmap.atlas.generator.tools.filesystem.FileSystemHelper;
import org.openstreetmap.atlas.generator.tools.spark.utilities.SparkFileHelper;
import org.openstreetmap.atlas.geography.sharding.Shard;
import org.openstreetmap.atlas.geography.sharding.SlippyTile;
import org.openstreetmap.atlas.streaming.resource.File;
import org.openstreetmap.atlas.streaming.resource.Resource;
import org.openstreetmap.atlas.utilities.caching.ConcurrentResourceCache;
import org.openstreetmap.atlas.utilities.caching.strategies.CachingStrategy;
import org.openstreetmap.atlas.utilities.caching.strategies.NamespaceCachingStrategy;
import org.openstreetmap.atlas.utilities.runtime.Retry;
import org.openstreetmap.atlas.utilities.scalars.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HadoopPbfFileCache
extends ConcurrentResourceCache {
    private static final Logger logger = LoggerFactory.getLogger(HadoopPbfFileCache.class);
    private static final String GLOBAL_HADOOP_FILE_CACHE_NAMESPACE = "__HadoopPbfFileCache_global_namespace__";
    private static final int RETRY_ATTEMPTS = 5;
    private final String parentPbfPath;
    private final SlippyTilePersistenceScheme pbfScheme;

    public HadoopPbfFileCache(String parentPbfPath, SlippyTilePersistenceScheme pbfScheme, Map<String, String> configuration) {
        this(parentPbfPath, pbfScheme, (CachingStrategy)new NamespaceCachingStrategy(GLOBAL_HADOOP_FILE_CACHE_NAMESPACE){

            protected void validateLocalFile(File localFile) {
            }
        }, uri -> {
            Retry retry = new Retry(5, Duration.ONE_SECOND).withQuadratic(true);
            boolean exists = (Boolean)retry.run(() -> {
                Boolean bl;
                block9: {
                    InputStream ignored = FileSystemHelper.resource(uri.toString(), configuration).read();
                    try {
                        bl = true;
                        if (ignored == null) break block9;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (ignored != null) {
                                try {
                                    ignored.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (Exception exception) {
                            if (exception.getMessage().contains("File not found")) {
                                return false;
                            }
                            throw new CoreException("Unable to test existence of {}", new Object[]{uri, exception});
                        }
                    }
                    ignored.close();
                }
                return bl;
            });
            if (!exists) {
                logger.warn("Fetcher: resource {} does not exist!", uri);
                return Optional.empty();
            }
            return Optional.ofNullable(FileSystemHelper.resource(uri.toString(), configuration));
        });
    }

    public HadoopPbfFileCache(String parentAtlasPath, SlippyTilePersistenceScheme atlasScheme, CachingStrategy cachingStrategy, Function<URI, Optional<Resource>> fetcher) {
        super(cachingStrategy, fetcher);
        this.parentPbfPath = parentAtlasPath;
        this.pbfScheme = atlasScheme;
    }

    public Optional<Resource> get(Shard shard) {
        return this.get(this.getURIFromShard(shard));
    }

    public void invalidate(Shard shard) {
        this.invalidate(this.getURIFromShard(shard));
    }

    private URI getURIFromShard(Shard shard) {
        URI pbfURI;
        String compiledPbfScheme = "";
        if (shard instanceof SlippyTile) {
            compiledPbfScheme = this.pbfScheme.compile((SlippyTile)shard);
        }
        String pbfURIString = SparkFileHelper.combine(this.parentPbfPath, compiledPbfScheme);
        try {
            pbfURI = new URI(pbfURIString);
        }
        catch (URISyntaxException exception) {
            throw new CoreException("Bad URI syntax: {}", new Object[]{pbfURIString, exception});
        }
        return pbfURI;
    }
}

