/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.mutator.configuration.parsing.provider.file;

import java.lang.module.Configuration;
import java.util.Map;
import java.util.Optional;
import org.openstreetmap.atlas.generator.tools.caching.HadoopAtlasFileCache;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.packed.PackedAtlas;
import org.openstreetmap.atlas.geography.sharding.Shard;
import org.openstreetmap.atlas.mutator.configuration.parsing.provider.file.AbstractFileAtlasProvider;
import org.openstreetmap.atlas.streaming.resource.Resource;

public class AtlasFileAtlasProvider
extends AbstractFileAtlasProvider {
    private static final long serialVersionUID = -8571516671628110381L;
    private transient HadoopAtlasFileCache cache;

    public AtlasFileAtlasProvider(Configuration configuration) {
    }

    public AtlasFileAtlasProvider() {
    }

    @Override
    public void setAtlasProviderContext(Map<String, Object> context) {
        super.setAtlasProviderContext(context);
        this.cache = new HadoopAtlasFileCache(this.getAtlasPath(), this.getSparkConfiguration());
    }

    @Override
    protected Optional<Resource> getResourceFromCache(String country, Shard shard) {
        return this.cache.get(country, shard);
    }

    @Override
    protected void invalidateCache(String country, Shard shard) {
        this.cache.invalidate(country, shard);
    }

    @Override
    protected Optional<Atlas> resourceToAtlas(Resource resource, String country, Shard shard) {
        return Optional.ofNullable(PackedAtlas.load((Resource)resource));
    }
}

