/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.mutator.configuration.parsing.provider.file;

import java.io.InputStream;
import java.util.Map;
import java.util.Optional;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.sharding.Shard;
import org.openstreetmap.atlas.mutator.configuration.parsing.provider.AtlasProvider;
import org.openstreetmap.atlas.streaming.resource.FileSuffix;
import org.openstreetmap.atlas.streaming.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractFileAtlasProvider
implements AtlasProvider {
    private static final long serialVersionUID = -6878724137563447659L;
    private static final Logger logger = LoggerFactory.getLogger(AbstractFileAtlasProvider.class);
    private String atlasPath = null;
    private Map<String, String> sparkConfiguration = null;

    @Override
    public Optional<Atlas> apply(String country, Shard shard) {
        Optional<Resource> resourceOption = this.getResourceFromCache(country, shard);
        if (resourceOption.isPresent()) {
            Optional<Atlas> namedAtlas;
            block5: {
                Resource namedAtlasResource = this.namedAtlasResource(shard, resourceOption.get());
                namedAtlas = null;
                try {
                    namedAtlas = this.resourceToAtlas(namedAtlasResource, country, shard);
                    if (!namedAtlas.isPresent()) {
                        return Optional.empty();
                    }
                    namedAtlas.get().numberOfAreas();
                }
                catch (Exception e) {
                    logger.warn("Invalidating cache for {} at {}, to attempt a re-fetch. (Source path was {})", new Object[]{country, shard.getName(), this.atlasPath});
                    this.invalidateCache(country, shard);
                    resourceOption = this.getResourceFromCache(country, shard);
                    if (!resourceOption.isPresent()) break block5;
                    namedAtlasResource = this.namedAtlasResource(shard, resourceOption.get());
                    namedAtlas = this.resourceToAtlas(namedAtlasResource, country, shard);
                    if (namedAtlas.isPresent()) {
                        namedAtlas.get().numberOfAreas();
                    }
                    return Optional.empty();
                }
            }
            return namedAtlas;
        }
        return Optional.empty();
    }

    @Override
    public void setAtlasProviderContext(Map<String, Object> context) {
        this.atlasPath = (String)context.get("filePath");
        if (this.atlasPath == null) {
            throw new CoreException("AtlasProvider {} is missing atlasPath.", new Object[]{this.getClass().getCanonicalName()});
        }
        this.sparkConfiguration = (Map)context.get("sparkConfiguration");
        if (this.sparkConfiguration == null) {
            throw new CoreException("AtlasProvider {} is missing sparkConfiguration.", new Object[]{this.getClass().getCanonicalName()});
        }
    }

    protected String getAtlasPath() {
        return this.atlasPath;
    }

    protected abstract Optional<Resource> getResourceFromCache(String var1, Shard var2);

    protected Map<String, String> getSparkConfiguration() {
        return this.sparkConfiguration;
    }

    protected abstract void invalidateCache(String var1, Shard var2);

    protected abstract Optional<Atlas> resourceToAtlas(Resource var1, String var2, Shard var3);

    private Resource namedAtlasResource(final Shard shardSource, final Resource atlasResource) {
        return new Resource(){

            public String getName() {
                return shardSource.getName() + FileSuffix.ATLAS;
            }

            public long length() {
                return atlasResource.length();
            }

            public InputStream read() {
                return atlasResource.read();
            }
        };
    }
}

