/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.mutator.configuration.parsing.provider;

import java.io.Serializable;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.mutator.configuration.parsing.provider.AtlasProvider;
import org.openstreetmap.atlas.utilities.configuration.Configuration;
import org.openstreetmap.atlas.utilities.configuration.ConfigurationReader;

public class ConfiguredAtlasProvider
implements Serializable {
    private static final long serialVersionUID = 5631940672482541575L;
    public static final String CONFIGURATION_ROOT = "global.atlasProviders";
    private static final String CONFIGURATION_CLASS_NAME = "className";
    private static final String CONFIGURATION_PROVIDER_CONFIGURATION = "providerConfiguration";
    private final AtlasProvider atlasProvider;

    public ConfiguredAtlasProvider(String name, Configuration configuration) {
        String configurationRoot = "global.atlasProviders." + name;
        ConfigurationReader reader = new ConfigurationReader(configurationRoot);
        String atlasProviderClassName = (String)reader.configurationValue(configuration, CONFIGURATION_CLASS_NAME, (Object)"");
        Configuration providerConfiguration = (Configuration)configuration.subConfiguration(configurationRoot + ".providerConfiguration").orElseThrow(() -> new CoreException("Unable to find \"{}\" for atlasProvider {}", new Object[]{CONFIGURATION_PROVIDER_CONFIGURATION, atlasProviderClassName}));
        this.atlasProvider = AtlasProvider.from(atlasProviderClassName, providerConfiguration);
    }

    public AtlasProvider getAtlasProvider() {
        return this.atlasProvider;
    }
}

