/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.mutator.configuration.parsing.provider;

import java.io.Serializable;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.sharding.Shard;
import org.openstreetmap.atlas.mutator.configuration.parsing.provider.file.AtlasFileAtlasProvider;
import org.openstreetmap.atlas.utilities.configuration.Configuration;

public interface AtlasProvider
extends BiFunction<String, Shard, Optional<Atlas>>,
Serializable {
    public static AtlasProvider defaultProvider() {
        return new AtlasFileAtlasProvider();
    }

    public static AtlasProvider from(String className, Configuration configuration) {
        try {
            Class<?> clazz = Class.forName(className);
            if (!AtlasProvider.class.isAssignableFrom(clazz)) {
                throw new CoreException("Class {} is not an AtlasProvider.", new Object[]{clazz.getName()});
            }
            return (AtlasProvider)clazz.getDeclaredConstructor(Configuration.class).newInstance(configuration);
        }
        catch (Exception e) {
            throw new CoreException("Cannot instantiate AtlasProvider {}", new Object[]{className, e});
        }
    }

    default public void setAtlasProviderContext(Map<String, Object> context) {
    }

    public static class AtlasProviderConstants {
        public static final String SPARK_CONFIGURATION_KEY = "sparkConfiguration";
        public static final String FILE_PATH_KEY = "filePath";

        private AtlasProviderConstants() {
        }
    }
}

