/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.mutator.configuration.parsing.mergeforgiveness.strategies;

import java.io.Serializable;
import java.util.Map;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.atlas.change.ChangeType;
import org.openstreetmap.atlas.geography.atlas.change.FeatureChange;
import org.openstreetmap.atlas.geography.atlas.complete.CompleteEdge;
import org.openstreetmap.atlas.geography.atlas.items.AtlasEntity;
import org.openstreetmap.atlas.geography.atlas.items.ItemType;
import org.openstreetmap.atlas.mutator.configuration.parsing.mergeforgiveness.MergeForgivenessStrategy;

public class TakeLowerNodeIdentifierStrategy
implements MergeForgivenessStrategy {
    private static final long serialVersionUID = 5772246281692335416L;

    @Override
    public FeatureChange resolve(FeatureChange left, FeatureChange right, Map<String, Serializable> configuration) {
        CompleteEdge synthesizedEdge;
        if (left.getIdentifier() != right.getIdentifier()) {
            throw new CoreException("Cannot choose a FeatureChange since identifiers conflict: left: {} vs right: {}", new Object[]{left.getIdentifier(), right.getIdentifier()});
        }
        if (left.getItemType() != right.getItemType() || left.getItemType() != ItemType.EDGE) {
            throw new CoreException("Cannot apply merge forgiveness since FeatureChanges are not both edges: left: {} vs right: {}", new Object[]{left.getItemType(), right.getItemType()});
        }
        if (left.getChangeType() != right.getChangeType() || left.getChangeType() != ChangeType.ADD) {
            throw new CoreException("Cannot apply merge FeatureChanges as they are of different types: left: {} vs right: {}", new Object[]{left.getChangeType(), right.getChangeType()});
        }
        CompleteEdge leftEdge = (CompleteEdge)left.getAfterView();
        CompleteEdge rightEdge = (CompleteEdge)right.getAfterView();
        CompleteEdge completeEdge = synthesizedEdge = leftEdge.isFull() ? leftEdge : rightEdge;
        if (leftEdge.start() == null) {
            leftEdge.withStartNodeIdentifier(Long.valueOf(rightEdge.start().getIdentifier()));
        }
        if (leftEdge.end() == null) {
            leftEdge.withEndNodeIdentifier(Long.valueOf(rightEdge.end().getIdentifier()));
        }
        if (rightEdge.start() == null) {
            rightEdge.withStartNodeIdentifier(Long.valueOf(leftEdge.start().getIdentifier()));
        }
        if (rightEdge.end() == null) {
            rightEdge.withEndNodeIdentifier(Long.valueOf(leftEdge.end().getIdentifier()));
        }
        if (leftEdge.start().getIdentifier() != rightEdge.start().getIdentifier()) {
            synthesizedEdge.withStartNodeIdentifier(Long.valueOf(Math.min(leftEdge.start().getIdentifier(), rightEdge.start().getIdentifier())));
        }
        if (leftEdge.end().getIdentifier() != rightEdge.end().getIdentifier()) {
            synthesizedEdge.withEndNodeIdentifier(Long.valueOf(Math.min(leftEdge.end().getIdentifier(), rightEdge.end().getIdentifier())));
        }
        return FeatureChange.add((AtlasEntity)synthesizedEdge);
    }
}

