/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.mutator.configuration.parsing.mergeforgiveness.strategies;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.atlas.change.FeatureChange;
import org.openstreetmap.atlas.mutator.configuration.parsing.mergeforgiveness.MergeForgivenessStrategy;
import org.openstreetmap.atlas.tags.Taggable;
import org.openstreetmap.atlas.tags.filters.TaggableFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrioritizeTagStrategy
implements MergeForgivenessStrategy {
    static final String RULES = "rules";
    private static final long serialVersionUID = 1587521150202532598L;
    private static final Logger logger = LoggerFactory.getLogger(PrioritizeTagStrategy.class);

    @Override
    public FeatureChange resolve(FeatureChange left, FeatureChange right, Map<String, Serializable> configuration) {
        logger.error("Trying PrioritizeTagStrategy on conflict:\n{}\nvs\n{}\nUsing raw config:\n{}", new Object[]{left.prettify(), right.prettify(), configuration});
        List<PrioritizationRule> prioritizationRules = this.getPrioritizationRules(configuration);
        Map<PrioritizationRule, FeatureChange> ruleToSelectedChanges = this.computeRulesToSelectedChanges(left, right, prioritizationRules);
        if (ruleToSelectedChanges.isEmpty()) {
            throw new CoreException("Unable to select a FeatureChange from\n{}\nvs\n{}\nNeither exclusively matched any provided filters:\n{}", new Object[]{left.prettify(), right.prettify(), prioritizationRules});
        }
        if (ruleToSelectedChanges.size() > 1) {
            ruleToSelectedChanges = this.filterSelectionDownToSingleEntry(ruleToSelectedChanges);
        }
        Map.Entry<PrioritizationRule, FeatureChange> selectedEntry = new ArrayList<Map.Entry<PrioritizationRule, FeatureChange>>(ruleToSelectedChanges.entrySet()).get(0);
        logger.error("Successfully applied PrioritizeTagStrategy to conflict:\n{}\nvs\n{}\nChose:\n{}\nUsing rule:\n{}", new Object[]{left.prettify(), right.prettify(), selectedEntry.getValue(), selectedEntry.getKey()});
        return selectedEntry.getValue();
    }

    private Map<PrioritizationRule, FeatureChange> computeRulesToSelectedChanges(FeatureChange left, FeatureChange right, List<PrioritizationRule> prioritizationRules) {
        HashMap<PrioritizationRule, FeatureChange> ruleToSelectedChanges = new HashMap<PrioritizationRule, FeatureChange>();
        for (PrioritizationRule prioritizationRule : prioritizationRules) {
            boolean rightTagsMatchFilter;
            boolean leftTagsMatchFilter = left.getTags() != null && prioritizationRule.getFilter().test((Taggable)left);
            boolean bl = rightTagsMatchFilter = right.getTags() != null && prioritizationRule.getFilter().test((Taggable)right);
            if (leftTagsMatchFilter && rightTagsMatchFilter) {
                if (!prioritizationRule.isLeftRightExclusive()) {
                    ruleToSelectedChanges.put(prioritizationRule, left);
                    break;
                }
                logger.error("Skipping resolution of:\n{}\nvs\n{}\nWith rule:\n{}\nsince both matched filter and leftRightExclusive=true", new Object[]{left.prettify(), right.prettify(), prioritizationRule});
                continue;
            }
            if (leftTagsMatchFilter) {
                ruleToSelectedChanges.put(prioritizationRule, left);
                break;
            }
            if (!rightTagsMatchFilter) continue;
            ruleToSelectedChanges.put(prioritizationRule, right);
            break;
        }
        return ruleToSelectedChanges;
    }

    private Map<PrioritizationRule, FeatureChange> filterSelectionDownToSingleEntry(Map<PrioritizationRule, FeatureChange> ruleToSelectedChanges) {
        throw new CoreException("Unable to select a FeatureChange. Too many matched:\n{}", new Object[]{ruleToSelectedChanges});
    }

    private List<PrioritizationRule> getPrioritizationRules(Map<String, Serializable> configuration) {
        ArrayList<PrioritizationRule> configurations = new ArrayList<PrioritizationRule>();
        List rawConfig = (List)((Object)configuration.get(RULES));
        HashSet<String> namesSeen = new HashSet<String>();
        for (Map rawMap : rawConfig) {
            String name = (String)rawMap.get("name");
            if (name == null) {
                throw new CoreException("{} was missing required key \"{}\"", new Object[]{PrioritizationRule.class.getName(), "name"});
            }
            if (namesSeen.contains(name)) {
                throw new CoreException("Already saw a {} with name \"{}\"", new Object[]{PrioritizationRule.class.getName(), name});
            }
            namesSeen.add(name);
            String filterString = (String)rawMap.get("filter");
            if (filterString == null) {
                throw new CoreException("{}:{} was missing required key \"{}\"", new Object[]{PrioritizationRule.class.getName(), name, "filter"});
            }
            TaggableFilter filter = TaggableFilter.forDefinition((String)filterString);
            String precedenceString = rawMap.getOrDefault("attitude", ConflictResolutionAttitude.STRICT.toString());
            ConflictResolutionAttitude precedence = ConflictResolutionAttitude.valueOf(precedenceString);
            boolean mutuallyExclusive = rawMap.getOrDefault("mutuallyExclusive", true);
            List pairwiseExclusive = rawMap.getOrDefault("pairwiseExclusive", new ArrayList());
            boolean leftRightExclusive = rawMap.getOrDefault("leftRightExclusive", true);
            configurations.add(new PrioritizationRule(name, filter, mutuallyExclusive, pairwiseExclusive, leftRightExclusive, precedence));
        }
        return configurations;
    }

    private static enum ConflictResolutionAttitude {
        STRICT,
        LENIENT;

    }

    public static class PrioritizationRule {
        static final String NAME_CONFIG = "name";
        static final String FILTER_CONFIG = "filter";
        static final String MUTUALLY_EXCLUSIVE_CONFIG = "mutuallyExclusive";
        static final String PAIRWISE_EXCLUSIVE_CONFIG = "pairwiseExclusive";
        static final String LEFT_RIGHT_EXCLUSIVE_CONFIG = "leftRightExclusive";
        static final String ATTITUDE_CONFIG = "attitude";
        private final String name;
        private final TaggableFilter filter;
        private final boolean mutuallyExclusive;
        private final List<String> pairwiseExclusivePartners;
        private final boolean leftRightExclusive;
        private final ConflictResolutionAttitude attitude;

        PrioritizationRule(String name, TaggableFilter filter, boolean mutuallyExclusive, List<String> pairwiseExclusivePartners, boolean leftRightExclusive, ConflictResolutionAttitude attitude) {
            this.name = name;
            this.filter = filter;
            this.mutuallyExclusive = mutuallyExclusive;
            this.pairwiseExclusivePartners = pairwiseExclusivePartners;
            this.leftRightExclusive = leftRightExclusive;
            this.attitude = attitude;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            PrioritizationRule that = (PrioritizationRule)object;
            return Objects.equals(this.name, that.name);
        }

        public ConflictResolutionAttitude getAttitude() {
            return this.attitude;
        }

        public TaggableFilter getFilter() {
            return this.filter;
        }

        public String getName() {
            return this.name;
        }

        public List<String> getPairwiseExclusivePartners() {
            return this.pairwiseExclusivePartners;
        }

        public int hashCode() {
            return Objects.hash(this.name);
        }

        public boolean isLeftRightExclusive() {
            return this.leftRightExclusive;
        }

        public boolean isMutuallyExclusive() {
            return this.mutuallyExclusive;
        }

        public String toString() {
            return "PrioritizationRule{name='" + this.name + "', filter=" + this.filter + ", mutuallyExclusive=" + this.mutuallyExclusive + ", pairwiseExclusivePartners=" + this.pairwiseExclusivePartners + ", leftRightExclusive=" + this.leftRightExclusive + ", attitude=" + this.attitude + "}";
        }
    }
}

