/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.mutator.configuration.parsing.mergeforgiveness;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.exception.change.FeatureChangeMergeException;
import org.openstreetmap.atlas.exception.change.MergeFailureType;
import org.openstreetmap.atlas.geography.atlas.change.FeatureChange;
import org.openstreetmap.atlas.mutator.configuration.parsing.mergeforgiveness.MergeForgivenessStrategy;
import org.openstreetmap.atlas.streaming.resource.Resource;
import org.openstreetmap.atlas.streaming.resource.StringResource;
import org.openstreetmap.atlas.utilities.configuration.Configuration;
import org.openstreetmap.atlas.utilities.configuration.ConfigurationReader;
import org.openstreetmap.atlas.utilities.configuration.StandardConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfiguredMergeForgivenessPolicy
implements Serializable {
    public static final ConfiguredMergeForgivenessPolicy DEFAULT = new ConfiguredMergeForgivenessPolicy();
    public static final String DEFAULT_NAME = "default";
    public static final String CONFIGURATION_ROOT = "mergeForgivenessPolicy";
    public static final String TYPE_JSON_PROPERTY_VALUE = "_mergeForgivenessPolicy";
    public static final String OWNER_JSON_PROPERTY = "owner";
    public static final String ROOT_LEVEL_POLICY_JSON_PROPERTY = "rootLevelPolicy";
    public static final String SUB_SEQUENCE_FAILURE_POLICY_JSON_PROPERTY = "subSequenceFailurePolicy";
    public static final String EXACT_SEQUENCE_FAILURE_POLICY_JSON_PROPERTY = "exactSequenceFailurePolicy";
    private static final long serialVersionUID = 8158886185907696393L;
    private static final Logger logger = LoggerFactory.getLogger(ConfiguredMergeForgivenessPolicy.class);
    private static final String GLOBAL_CONFIGURATION_ROOT = "global.mergeForgivenessPolicy";
    private static final String CONFIGURATION_RESOLVABLE_ROOT_LEVEL_FAILURES = "resolvableRootLevelFailures";
    private static final String CONFIGURATION_RESOLVABLE_FAILURE_SUBSEQUENCES = "resolvableSubSequenceFailures";
    private static final String CONFIGURATION_RESOLVABLE_FAILURE_EXACT_SEQUENCES = "resolvableExactSequenceFailures";
    private static final String CONFIGURATION_ROOT_LEVEL_FAILURE = "rootLevelFailure";
    private static final String CONFIGURATION_FAILURE_SUBSEQUENCE = "subSequenceFailure";
    private static final String CONFIGURATION_FAILURE_EXACT_SEQUENCE = "exactSequenceFailure";
    private static final String CONFIGURATION_STRATEGY_CLASSNAME = "strategyClassName";
    private static final String CONFIGURATION_STRATEGY_CONFIGURATION = "strategyConfiguration";
    private final String owner;
    private final List<RootLevelPolicyElement> rootLevelFailurePolicy;
    private final List<FailureSequencePolicyElement> subSequenceFailurePolicy;
    private final List<FailureSequencePolicyElement> exactSequenceFailurePolicy;

    public static ConfiguredMergeForgivenessPolicy fromGlobal(Configuration configuration) {
        return new ConfiguredMergeForgivenessPolicy(configuration, GLOBAL_CONFIGURATION_ROOT, "global");
    }

    public static ConfiguredMergeForgivenessPolicy fromRoot(Configuration configuration, String root) {
        return new ConfiguredMergeForgivenessPolicy(configuration, root + ".mergeForgivenessPolicy", root);
    }

    private static Optional<MergeForgivenessStrategy> instantiateStrategy(String classname) {
        MergeForgivenessStrategy strategy;
        Constructor<?> constructor;
        Class<?> subcommandClass;
        try {
            subcommandClass = Class.forName(classname);
        }
        catch (ClassNotFoundException exception) {
            throw new CoreException("Class {} was not found", new Object[]{classname, exception});
        }
        if (Modifier.isAbstract(subcommandClass.getModifiers())) {
            return Optional.empty();
        }
        try {
            constructor = subcommandClass.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException exception) {
            throw new CoreException("Class {} does not have a matching constructor", new Object[]{classname, exception});
        }
        catch (SecurityException exception) {
            throw new CoreException("Error instantiating class {}", new Object[]{classname, exception});
        }
        try {
            strategy = (MergeForgivenessStrategy)constructor.newInstance(new Object[0]);
        }
        catch (ClassCastException exception) {
            throw new CoreException("Class {} not a subtype of {}", new Object[]{classname, MergeForgivenessStrategy.class.getName(), exception});
        }
        catch (Exception exception) {
            throw new CoreException("Error instantiating class {}", new Object[]{classname, exception});
        }
        return Optional.of(strategy);
    }

    public ConfiguredMergeForgivenessPolicy() {
        this((Configuration)new StandardConfiguration((Resource)new StringResource("{}")), GLOBAL_CONFIGURATION_ROOT, "");
    }

    private ConfiguredMergeForgivenessPolicy(Configuration configuration, String configurationRoot, String owner) {
        try {
            ConfigurationReader reader = new ConfigurationReader(configurationRoot);
            this.rootLevelFailurePolicy = this.parseRootLevelFailurePolicy(configuration, reader);
            this.subSequenceFailurePolicy = this.parseSubSequenceFailurePolicy(configuration, reader);
            this.exactSequenceFailurePolicy = this.parseExactSequenceFailurePolicy(configuration, reader);
        }
        catch (Exception exception) {
            throw new CoreException("Unable to create ConfiguredMergeForgivenessPolicy", (Throwable)exception);
        }
        this.owner = owner;
    }

    public Optional<FeatureChange> applyPolicy(FeatureChangeMergeException mergeException, FeatureChange left, FeatureChange right) {
        for (FailureSequencePolicyElement failureSequencePolicyElement : this.exactSequenceFailurePolicy) {
            if (!mergeException.traceMatchesExactFailureSequence(failureSequencePolicyElement.getFailureSequence())) continue;
            try {
                return Optional.of(failureSequencePolicyElement.getStrategy().resolve(left, right, failureSequencePolicyElement.getConfiguration()));
            }
            catch (Exception exception) {
                throw new CoreException("Application of exactSequenceFailurePolicy failed for {} caused by:\n{}\nvs\n{}", new Object[]{mergeException.getMergeFailureTrace(), left, right, exception});
            }
        }
        for (FailureSequencePolicyElement failureSequencePolicyElement : this.subSequenceFailurePolicy) {
            if (!mergeException.traceContainsExactFailureSubSequence(failureSequencePolicyElement.getFailureSequence())) continue;
            try {
                return Optional.of(failureSequencePolicyElement.getStrategy().resolve(left, right, failureSequencePolicyElement.getConfiguration()));
            }
            catch (Exception exception) {
                throw new CoreException("Application of subSequenceFailurePolicy failed for {} caused by:\n{}\nvs\n{}", new Object[]{mergeException.getMergeFailureTrace(), left, right, exception});
            }
        }
        for (RootLevelPolicyElement rootLevelPolicyElement : this.rootLevelFailurePolicy) {
            if (mergeException.rootLevelFailure() != rootLevelPolicyElement.getRootLevelFailureType()) continue;
            try {
                return Optional.of(rootLevelPolicyElement.getStrategy().resolve(left, right, rootLevelPolicyElement.getConfiguration()));
            }
            catch (Exception exception) {
                throw new CoreException("Application of rootLevelFailurePolicy failed for {} caused by:\n{}\nvs\n{}", new Object[]{mergeException.getMergeFailureTrace(), left, right, exception});
            }
        }
        logger.warn("No applicable merge resolution policy found for {} caused by:\n{}\nvs\n{}", new Object[]{mergeException.getMergeFailureTrace(), left, right});
        return Optional.empty();
    }

    public List<FailureSequencePolicyElement> getExactSequenceFailurePolicy() {
        return this.exactSequenceFailurePolicy;
    }

    public String getOwner() {
        return this.owner;
    }

    public List<RootLevelPolicyElement> getRootLevelFailurePolicy() {
        return this.rootLevelFailurePolicy;
    }

    public List<FailureSequencePolicyElement> getSubSequenceFailurePolicy() {
        return this.subSequenceFailurePolicy;
    }

    public boolean policyIsEmpty() {
        return this.rootLevelFailurePolicy.isEmpty() && this.subSequenceFailurePolicy.isEmpty() && this.exactSequenceFailurePolicy.isEmpty();
    }

    public JsonObject toJson() {
        JsonObject policyObject = new JsonObject();
        policyObject.addProperty("type", TYPE_JSON_PROPERTY_VALUE);
        policyObject.addProperty(OWNER_JSON_PROPERTY, this.owner);
        JsonArray rootLevelElements = new JsonArray();
        for (RootLevelPolicyElement rootLevelPolicyElement : this.rootLevelFailurePolicy) {
            rootLevelElements.add((JsonElement)new JsonPrimitive(rootLevelPolicyElement.toString()));
        }
        if (!this.rootLevelFailurePolicy.isEmpty()) {
            policyObject.add(ROOT_LEVEL_POLICY_JSON_PROPERTY, (JsonElement)rootLevelElements);
        }
        JsonArray subSequenceElements = new JsonArray();
        for (FailureSequencePolicyElement element : this.subSequenceFailurePolicy) {
            subSequenceElements.add((JsonElement)new JsonPrimitive(element.toString()));
        }
        if (!this.subSequenceFailurePolicy.isEmpty()) {
            policyObject.add(SUB_SEQUENCE_FAILURE_POLICY_JSON_PROPERTY, (JsonElement)subSequenceElements);
        }
        JsonArray jsonArray = new JsonArray();
        for (FailureSequencePolicyElement element : this.exactSequenceFailurePolicy) {
            jsonArray.add((JsonElement)new JsonPrimitive(element.toString()));
        }
        if (!this.exactSequenceFailurePolicy.isEmpty()) {
            policyObject.add(EXACT_SEQUENCE_FAILURE_POLICY_JSON_PROPERTY, (JsonElement)jsonArray);
        }
        return policyObject;
    }

    public String toString() {
        return "ConfiguredMergeForgivenessPolicy {\nrootLevelFailurePolicy=" + this.rootLevelFailurePolicy + "\nexactSequenceFailurePolicy=" + this.exactSequenceFailurePolicy + "\nsubSequenceFailurePolicy=" + this.subSequenceFailurePolicy + "\n}";
    }

    private Map<String, Serializable> getIntermediateConfigurationMap(Map<Object, Serializable> map) {
        if (map == null) {
            return new HashMap<String, Serializable>();
        }
        HashMap<String, Serializable> result = new HashMap<String, Serializable>();
        for (Map.Entry<Object, Serializable> entry : map.entrySet()) {
            String key = (String)entry.getKey();
            Serializable value = entry.getValue();
            result.put(key, value);
        }
        return result;
    }

    private List<FailureSequencePolicyElement> parseExactSequenceFailurePolicy(Configuration configuration, ConfigurationReader reader) {
        return this.parseGenericSequencePolicy(configuration, reader, CONFIGURATION_RESOLVABLE_FAILURE_EXACT_SEQUENCES, CONFIGURATION_FAILURE_EXACT_SEQUENCE, true);
    }

    private List<FailureSequencePolicyElement> parseGenericSequencePolicy(Configuration configuration, ConfigurationReader reader, String sequenceType, String sequenceSpecifier, boolean exact) {
        try {
            ArrayList<FailureSequencePolicyElement> parsedElements = new ArrayList<FailureSequencePolicyElement>();
            List rawElements = (List)reader.configurationValue(configuration, sequenceType, new ArrayList());
            for (Object rawElement : rawElements) {
                Map map = (Map)rawElement;
                List rawList = (List)map.get(sequenceSpecifier);
                ArrayList<MergeFailureType> mergeFailureTypes = new ArrayList<MergeFailureType>();
                for (String typeString : rawList) {
                    mergeFailureTypes.add(MergeFailureType.valueOf((String)typeString));
                }
                String strategyClassname = (String)map.get(CONFIGURATION_STRATEGY_CLASSNAME);
                MergeForgivenessStrategy strategy = ConfiguredMergeForgivenessPolicy.instantiateStrategy(strategyClassname).orElseThrow(() -> new CoreException("Could not instantiate class {}", new Object[]{strategyClassname}));
                Map<String, Serializable> strategyConfiguration = this.getIntermediateConfigurationMap((Map)map.get(CONFIGURATION_STRATEGY_CONFIGURATION));
                parsedElements.add(new FailureSequencePolicyElement(mergeFailureTypes, strategy, strategyConfiguration, exact));
            }
            return parsedElements;
        }
        catch (Exception exception) {
            throw new CoreException("Could not parse failure subsequence policy from {}", new Object[]{CONFIGURATION_RESOLVABLE_FAILURE_SUBSEQUENCES});
        }
    }

    private List<RootLevelPolicyElement> parseRootLevelFailurePolicy(Configuration configuration, ConfigurationReader reader) {
        try {
            ArrayList<RootLevelPolicyElement> parsedElements = new ArrayList<RootLevelPolicyElement>();
            List rawElements = (List)reader.configurationValue(configuration, CONFIGURATION_RESOLVABLE_ROOT_LEVEL_FAILURES, new ArrayList());
            for (Object rawElement : rawElements) {
                Map map = (Map)rawElement;
                MergeFailureType mergeFailureType = MergeFailureType.valueOf((String)((String)map.get(CONFIGURATION_ROOT_LEVEL_FAILURE)));
                String strategyClassname = (String)map.get(CONFIGURATION_STRATEGY_CLASSNAME);
                MergeForgivenessStrategy strategy = ConfiguredMergeForgivenessPolicy.instantiateStrategy(strategyClassname).orElseThrow(() -> new CoreException("Could not instantiate class {}", new Object[]{strategyClassname}));
                Map<String, Serializable> strategyConfiguration = this.getIntermediateConfigurationMap((Map)map.get(CONFIGURATION_STRATEGY_CONFIGURATION));
                parsedElements.add(new RootLevelPolicyElement(mergeFailureType, strategy, strategyConfiguration));
            }
            return parsedElements;
        }
        catch (Exception exception) {
            throw new CoreException("Could not parse root level failure policy from {}", new Object[]{CONFIGURATION_RESOLVABLE_ROOT_LEVEL_FAILURES});
        }
    }

    private List<FailureSequencePolicyElement> parseSubSequenceFailurePolicy(Configuration configuration, ConfigurationReader reader) {
        return this.parseGenericSequencePolicy(configuration, reader, CONFIGURATION_RESOLVABLE_FAILURE_SUBSEQUENCES, CONFIGURATION_FAILURE_SUBSEQUENCE, false);
    }

    public static class RootLevelPolicyElement
    implements Serializable {
        private static final long serialVersionUID = -3064840935245823460L;
        private final MergeFailureType rootLevelFailureType;
        private final MergeForgivenessStrategy strategy;
        private final Map<String, Serializable> configuration;

        public RootLevelPolicyElement(MergeFailureType rootLevelFailureType, MergeForgivenessStrategy strategy, Map<String, Serializable> configuration) {
            this.rootLevelFailureType = rootLevelFailureType;
            this.strategy = strategy;
            this.configuration = configuration;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            RootLevelPolicyElement that = (RootLevelPolicyElement)other;
            return this.rootLevelFailureType == that.rootLevelFailureType && Objects.equals(this.strategy, that.strategy);
        }

        public Map<String, Serializable> getConfiguration() {
            return this.configuration;
        }

        public MergeFailureType getRootLevelFailureType() {
            return this.rootLevelFailureType;
        }

        public MergeForgivenessStrategy getStrategy() {
            return this.strategy;
        }

        public int hashCode() {
            return Objects.hash(this.rootLevelFailureType, this.strategy);
        }

        public String toString() {
            return "RootLevelPolicyElement{rootLevelFailureType=" + this.rootLevelFailureType + ", strategy=" + this.strategy.getClass().getName() + ", config=" + this.configuration + "}";
        }
    }

    public static class FailureSequencePolicyElement
    implements Serializable {
        private static final long serialVersionUID = -2707475460873950048L;
        private final List<MergeFailureType> failureSubSequence;
        private final MergeForgivenessStrategy strategy;
        private final Map<String, Serializable> configuration;
        private final boolean exact;

        public FailureSequencePolicyElement(List<MergeFailureType> failureSubSequence, MergeForgivenessStrategy strategy, Map<String, Serializable> configuration, boolean exact) {
            this.failureSubSequence = failureSubSequence;
            this.strategy = strategy;
            this.configuration = configuration;
            this.exact = exact;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            FailureSequencePolicyElement that = (FailureSequencePolicyElement)other;
            return Objects.equals(this.failureSubSequence, that.failureSubSequence) && Objects.equals(this.strategy, that.strategy) && Objects.equals(this.exact, that.exact);
        }

        public Map<String, Serializable> getConfiguration() {
            return this.configuration;
        }

        public List<MergeFailureType> getFailureSequence() {
            return this.failureSubSequence;
        }

        public MergeForgivenessStrategy getStrategy() {
            return this.strategy;
        }

        public int hashCode() {
            return Objects.hash(this.failureSubSequence, this.strategy);
        }

        public boolean isExact() {
            return this.exact;
        }

        public String toString() {
            return "FailureSequencePolicyElement{failureSubSequence=" + this.failureSubSequence + ", strategy=" + this.strategy.getClass().getName() + ", config=" + this.configuration + ", exact=" + this.exact + "}";
        }
    }
}

