/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.mutator.configuration.parsing;

import com.google.gson.JsonObject;
import java.io.Serializable;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.sub.AtlasCutType;
import org.openstreetmap.atlas.streaming.resource.Resource;
import org.openstreetmap.atlas.streaming.resource.StringResource;
import org.openstreetmap.atlas.utilities.configuration.Configuration;
import org.openstreetmap.atlas.utilities.configuration.ConfigurationReader;
import org.openstreetmap.atlas.utilities.configuration.ConfiguredFilter;
import org.openstreetmap.atlas.utilities.configuration.StandardConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConfiguredSubAtlas
implements Function<Atlas, Optional<Atlas>>,
Serializable {
    public static final String DEFAULT = "default";
    public static final ConfiguredSubAtlas UNCHANGED = new ConfiguredSubAtlas();
    public static final String TYPE_JSON_PROPERTY_VALUE = "_subAtlas";
    public static final String NAME_JSON_PROPERTY = "name";
    public static final String FILTER_JSON_PROPERTY = "filter";
    public static final String CUT_TYPE_JSON_PROPERTY = "cutType";
    private static final long serialVersionUID = -2506410811249068520L;
    private static final Logger logger = LoggerFactory.getLogger(ConfiguredSubAtlas.class);
    private static final String CONFIGURATION_ROOT = "global.subAtlases";
    private static final String CONFIGURATION_FILTER = "filter";
    private static final String CONFIGURATION_CUT_TYPE = "cutType";
    private final ConfiguredFilter subAtlasFilter;
    private final AtlasCutType subAtlasCutType;
    private final String name;

    public static ConfiguredSubAtlas from(String name, Configuration configuration) {
        if (DEFAULT.equals(name)) {
            return UNCHANGED;
        }
        if (!new ConfigurationReader(CONFIGURATION_ROOT).isPresent(configuration, name)) {
            logger.warn("Attempted to create ConfiguredSubAtlas called \"{}\" but it was not found. It will be swapped with default passthrough sub atlas.", (Object)name);
            return UNCHANGED;
        }
        return new ConfiguredSubAtlas(name, configuration);
    }

    private ConfiguredSubAtlas() {
        this(DEFAULT, (Configuration)new StandardConfiguration((Resource)new StringResource("{}")));
    }

    private ConfiguredSubAtlas(String name, Configuration configuration) {
        ConfigurationReader reader = new ConfigurationReader("global.subAtlases." + name);
        this.name = name;
        this.subAtlasFilter = ConfiguredFilter.from((String)((String)reader.configurationValue(configuration, "filter", (Object)DEFAULT)), (Configuration)configuration);
        this.subAtlasCutType = AtlasCutType.valueOf((String)((String)reader.configurationValue(configuration, "cutType", (Object)AtlasCutType.SOFT_CUT.name())));
    }

    @Override
    public Optional<Atlas> apply(Atlas atlas) {
        if (atlas == null) {
            return Optional.empty();
        }
        if (this.subAtlasFilter == ConfiguredFilter.NO_FILTER) {
            return Optional.of(atlas);
        }
        return atlas.subAtlas((Predicate)this.subAtlasFilter, this.subAtlasCutType);
    }

    public String getName() {
        return this.name;
    }

    public AtlasCutType getSubAtlasCutType() {
        return this.subAtlasCutType;
    }

    public ConfiguredFilter getSubAtlasFilter() {
        return this.subAtlasFilter;
    }

    public JsonObject toJson() {
        JsonObject subAtlasObject = new JsonObject();
        subAtlasObject.addProperty("type", TYPE_JSON_PROPERTY_VALUE);
        subAtlasObject.addProperty(NAME_JSON_PROPERTY, this.name);
        subAtlasObject.addProperty("filter", this.subAtlasFilter.getName());
        subAtlasObject.addProperty("cutType", this.subAtlasCutType.name());
        return subAtlasObject;
    }
}

