/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.mutator.configuration.parsing;

import com.google.gson.JsonObject;
import java.io.Serializable;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.GeometricSurface;
import org.openstreetmap.atlas.geography.Polygon;
import org.openstreetmap.atlas.geography.Rectangle;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.dynamic.policy.DynamicAtlasPolicy;
import org.openstreetmap.atlas.geography.atlas.packed.PackedAtlas;
import org.openstreetmap.atlas.geography.sharding.Shard;
import org.openstreetmap.atlas.geography.sharding.Sharding;
import org.openstreetmap.atlas.mutator.configuration.InputDependency;
import org.openstreetmap.atlas.mutator.configuration.parsing.ConfiguredAtlasFetcher;
import org.openstreetmap.atlas.streaming.resource.Resource;
import org.openstreetmap.atlas.streaming.resource.StringResource;
import org.openstreetmap.atlas.utilities.collections.Iterables;
import org.openstreetmap.atlas.utilities.collections.Sets;
import org.openstreetmap.atlas.utilities.configuration.Configuration;
import org.openstreetmap.atlas.utilities.configuration.ConfigurationReader;
import org.openstreetmap.atlas.utilities.configuration.ConfiguredFilter;
import org.openstreetmap.atlas.utilities.configuration.StandardConfiguration;
import org.openstreetmap.atlas.utilities.scalars.Distance;
import org.openstreetmap.atlas.utilities.time.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConfiguredDynamicAtlasPolicy
implements Serializable {
    public static final ConfiguredDynamicAtlasPolicy DEFAULT = new ConfiguredDynamicAtlasPolicy();
    public static final String DEFAULT_NAME = "default";
    public static final String TYPE_JSON_PROPERTY_VALUE = "_dynamicAtlasPolicy";
    public static final String NAME_JSON_PROPERTY = "name";
    public static final String EXTEND_INDEFINITELY_JSON_PROPERTY = "extendIndefinitely";
    public static final String DEFER_LOADING_JSON_PROPERTY = "deferLoading";
    public static final String AGGRESSIVELY_EXPLORE_RELATIONS_JSON_PROPERTY = "aggressivelyExploreRelations";
    public static final String ENTITIES_TO_CONSIDER_FOR_EXPANSION_JSON_PROPERTY = "entitiesToConsiderForExpansion";
    public static final String MAX_EXPANSION_DISTANCE_METERS_JSON_PROPERTY = "maximumExpansionDistanceInMeters";
    public static final String FETCHER_JSON_PROPERTY = "fetcher";
    public static final String DIRECT_FETCHER_JSON_PROPERTY = "directFetcher";
    public static final String INPUT_DEPENDENCY_JSON_PROPERTY = "inputDependency";
    public static final String IS_PRE_DETERMINED_JSON_PROPERTY = "isPreDetermined";
    private static final long serialVersionUID = 3221637872080329610L;
    private static final Logger logger = LoggerFactory.getLogger(ConfiguredDynamicAtlasPolicy.class);
    private static final String CONFIGURATION_ROOT = "global.dynamicAtlasPolicies";
    private static final String CONFIGURATION_EXTEND_INDEFINITELY = "extendIndefinitely";
    private static final String CONFIGURATION_DEFER_LOADING = "deferLoading";
    private static final String CONFIGURATION_AGGRESSIVELY_EXPLORE_RELATIONS = "aggressivelyExploreRelations";
    private static final String CONFIGURATION_DIRECT_FETCHER = "directFetcher";
    private static final String CONFIGURATION_FETCHER = "fetcher";
    private static final String CONFIGURATION_ENTITIES_TO_CONSIDER_FOR_EXPANSION = "entitiesToConsiderForExpansion";
    private static final String CONFIGURATION_MAXIMUM_EXPANSION_DISTANCE = "maximumExpansionDistanceInMeters";
    private static final String CONFIGURATION_MAXIMUM_EXPANSION_DISTANCE_DEFAULT = "N/A";
    private final String name;
    private final boolean extendIndefinitely;
    private final boolean deferLoading;
    private final boolean aggressivelyExploreRelations;
    private final String maximumExpansionDistanceInMeters;
    private final ConfiguredFilter entitiesToConsiderForExpansion;
    private final ConfiguredAtlasFetcher directFetcher;
    private final ConfiguredAtlasFetcher fetcher;
    private final InputDependency inputDependency;

    public static ConfiguredDynamicAtlasPolicy from(String name, Configuration configuration) {
        if (DEFAULT_NAME.equals(name)) {
            return DEFAULT;
        }
        if (!new ConfigurationReader(CONFIGURATION_ROOT).isPresent(configuration, name)) {
            logger.warn("Attempted to create ConfiguredDynamicAtlasPolicy called \"{}\" but it was not found. It will be swapped with default policy.", (Object)name);
            return DEFAULT;
        }
        return new ConfiguredDynamicAtlasPolicy(name, configuration);
    }

    private ConfiguredDynamicAtlasPolicy() {
        this(DEFAULT_NAME, (Configuration)new StandardConfiguration((Resource)new StringResource("{}")));
    }

    private ConfiguredDynamicAtlasPolicy(String name, Configuration configuration) {
        this.name = name;
        try {
            String root = "global.dynamicAtlasPolicies." + name;
            ConfigurationReader reader = new ConfigurationReader(root);
            this.extendIndefinitely = this.readBoolean(configuration, reader, "extendIndefinitely", false);
            this.deferLoading = this.readBoolean(configuration, reader, "deferLoading", true);
            this.aggressivelyExploreRelations = this.readBoolean(configuration, reader, "aggressivelyExploreRelations", false);
            this.maximumExpansionDistanceInMeters = (String)reader.configurationValue(configuration, "maximumExpansionDistanceInMeters", (Object)CONFIGURATION_MAXIMUM_EXPANSION_DISTANCE_DEFAULT);
            this.entitiesToConsiderForExpansion = ConfiguredFilter.from((String)((String)reader.configurationValue(configuration, "entitiesToConsiderForExpansion", (Object)DEFAULT_NAME)), (Configuration)configuration);
            this.directFetcher = ConfiguredAtlasFetcher.from((String)reader.configurationValue(configuration, "directFetcher", (Object)DEFAULT_NAME), configuration);
            this.fetcher = ConfiguredAtlasFetcher.from((String)reader.configurationValue(configuration, "fetcher", (Object)DEFAULT_NAME), configuration);
            this.inputDependency = this.fetcher.getInputDependencyName().map(inputDependencyName -> new InputDependency(null, (String)inputDependencyName, configuration)).orElse(null);
        }
        catch (Exception e) {
            throw new CoreException("Unable to create ConfiguredDynamicAtlasPolicy \"{}\"", new Object[]{name, e});
        }
    }

    public boolean equals(Object other) {
        if (other instanceof ConfiguredDynamicAtlasPolicy) {
            return this.getName().equals(((ConfiguredDynamicAtlasPolicy)other).getName());
        }
        return false;
    }

    public ConfiguredAtlasFetcher getConfiguredFetcher() {
        return this.fetcher;
    }

    public ConfiguredFilter getEntitiesToConsiderForExpansion() {
        return this.entitiesToConsiderForExpansion;
    }

    public Optional<InputDependency> getInputDependency() {
        return Optional.ofNullable(this.inputDependency);
    }

    public Optional<String> getInputDependencyName() {
        return this.fetcher.getInputDependencyName();
    }

    public String getName() {
        return this.name;
    }

    public DynamicAtlasPolicy getPolicy(Set<Shard> initialShards, Sharding sharding, String atlasPath, Map<String, String> sparkConfiguration, String country) {
        return this.getPolicy(initialShards, sharding, this.getFetcher(initialShards, atlasPath, country, sparkConfiguration));
    }

    public DynamicAtlasPolicy getRDDBasedPolicy(Set<Shard> initialShards, Sharding sharding, Map<Shard, PackedAtlas> shardToAtlasMap) {
        return this.getPolicy(initialShards, sharding, shard -> Optional.ofNullable((Atlas)shardToAtlasMap.get(shard)));
    }

    public Function<Shard, Set<Shard>> getShardExplorer(Sharding sharding) {
        if (!this.isPreDetermined()) {
            throw new CoreException("Impossible to know what shards to request in advance for {}", new Object[]{this.name});
        }
        if (this.entitiesToConsiderForExpansion.isNoExpansion()) {
            return (Function<Shard, Set> & Serializable)xva$0 -> Sets.hashSet((Object[])new Shard[]{xva$0});
        }
        return (Function<Shard, Set> & Serializable)shard -> {
            Rectangle maximumBounds = this.computeMaximumBounds(Sets.hashSet((Object[])new Shard[]{shard}));
            Set result = Iterables.asSet((Iterable)sharding.shards((GeometricSurface)maximumBounds));
            result.add(shard);
            return result;
        };
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public boolean isPreDetermined() {
        return !this.aggressivelyExploreRelations && (!CONFIGURATION_MAXIMUM_EXPANSION_DISTANCE_DEFAULT.equals(this.maximumExpansionDistanceInMeters) || this.entitiesToConsiderForExpansion.isNoExpansion());
    }

    public JsonObject toJson() {
        JsonObject policyObject = new JsonObject();
        policyObject.addProperty("type", TYPE_JSON_PROPERTY_VALUE);
        policyObject.addProperty(NAME_JSON_PROPERTY, this.name);
        policyObject.addProperty("extendIndefinitely", Boolean.valueOf(this.extendIndefinitely));
        policyObject.addProperty("deferLoading", Boolean.valueOf(this.deferLoading));
        policyObject.addProperty("aggressivelyExploreRelations", Boolean.valueOf(this.aggressivelyExploreRelations));
        policyObject.addProperty("entitiesToConsiderForExpansion", this.entitiesToConsiderForExpansion.toString());
        policyObject.addProperty("maximumExpansionDistanceInMeters", this.maximumExpansionDistanceInMeters);
        policyObject.addProperty("directFetcher", this.directFetcher.toString());
        policyObject.addProperty("fetcher", this.fetcher.toString());
        policyObject.addProperty(IS_PRE_DETERMINED_JSON_PROPERTY, Boolean.valueOf(this.isPreDetermined()));
        if (this.inputDependency != null) {
            policyObject.addProperty(INPUT_DEPENDENCY_JSON_PROPERTY, this.inputDependency.getPathName());
        }
        return policyObject;
    }

    public String toString() {
        return "ConfiguredDynamicAtlasPolicy [name=" + this.name + ", extendIndefinitely=" + this.extendIndefinitely + ", deferLoading=" + this.deferLoading + ", aggressivelyExploreRelations=" + this.aggressivelyExploreRelations + ", entitiesToConsiderForExpansion=" + this.entitiesToConsiderForExpansion + ", fetcher=" + this.fetcher + "]";
    }

    public String toStringCompact() {
        return this.name;
    }

    private Rectangle computeMaximumBounds(Set<Shard> initialShards) {
        Rectangle maximumBounds;
        if (CONFIGURATION_MAXIMUM_EXPANSION_DISTANCE_DEFAULT.equals(this.maximumExpansionDistanceInMeters)) {
            maximumBounds = Rectangle.MAXIMUM;
        } else {
            Distance expansionDistance = Distance.meters((double)Double.valueOf(this.maximumExpansionDistanceInMeters));
            Rectangle start = null;
            for (Shard initialShard : initialShards) {
                if (start == null) {
                    start = initialShard.bounds();
                    continue;
                }
                start = start.combine(initialShard.bounds());
            }
            if (start == null) {
                throw new CoreException("There should be at least one shard to start with.");
            }
            maximumBounds = start.expand(expansionDistance);
        }
        return maximumBounds;
    }

    private Function<Shard, Optional<Atlas>> getFetcher(Set<Shard> initialShards, String atlasPath, String country, Map<String, String> sparkConfiguration) {
        Function<Shard, Optional<Atlas>> initialShardAtlasFetcher = this.directFetcher.getFetcher(atlasPath, country, sparkConfiguration);
        Function<Shard, Optional<Atlas>> subAtlasFetcher = this.fetcher.getFetcher(atlasPath, country, sparkConfiguration);
        return shardSource -> {
            String initialShard;
            Optional result;
            Time start = Time.now();
            if (initialShards.contains(shardSource)) {
                result = (Optional)initialShardAtlasFetcher.apply((Shard)shardSource);
                initialShard = "(initial shard)";
            } else {
                result = (Optional)subAtlasFetcher.apply((Shard)shardSource);
                initialShard = "(satellite shard)";
            }
            logger.debug("Fetched {} and {} and {} {} in {}", new Object[]{atlasPath, country, shardSource.getName(), initialShard, start.elapsedSince()});
            return result;
        };
    }

    private DynamicAtlasPolicy getPolicy(Set<Shard> initialShards, Sharding sharding, Function<Shard, Optional<Atlas>> fetcher) {
        Rectangle maximumBounds = this.computeMaximumBounds(initialShards);
        return new DynamicAtlasPolicy(fetcher, sharding, initialShards, (Polygon)maximumBounds).withExtendIndefinitely(this.extendIndefinitely).withDeferredLoading(this.deferLoading).withAggressivelyExploreRelations(this.aggressivelyExploreRelations).withAtlasEntitiesToConsiderForExpansion((Predicate)this.entitiesToConsiderForExpansion);
    }

    private boolean readBoolean(Configuration configuration, ConfigurationReader reader, String booleanName, boolean defaultValue) {
        try {
            return (Boolean)reader.configurationValue(configuration, booleanName, (Object)defaultValue);
        }
        catch (Exception e) {
            throw new CoreException("Unable to read \"{}\"", new Object[]{booleanName, e});
        }
    }
}

