/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.mutator.configuration.parsing;

import com.google.gson.JsonObject;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.sharding.Shard;
import org.openstreetmap.atlas.mutator.configuration.parsing.ConfiguredSubAtlas;
import org.openstreetmap.atlas.mutator.configuration.parsing.provider.AtlasProvider;
import org.openstreetmap.atlas.mutator.configuration.parsing.provider.ConfiguredAtlasProvider;
import org.openstreetmap.atlas.utilities.configuration.Configuration;
import org.openstreetmap.atlas.utilities.configuration.ConfigurationReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConfiguredAtlasFetcher
implements Serializable {
    public static final String DEFAULT = "default";
    public static final String TYPE_JSON_PROPERTY_VALUE = "_fetcher";
    public static final String NAME_JSON_PROPERTY = "name";
    public static final String INPUT_DEPENDENCY_NAME_JSON_PROPERTY = "inputDependencyName";
    public static final String INPUT_DEPENDENCY_PATH_JSON_PROPERTY = "inputDependencyPath";
    public static final String SUB_ATLAS_JSON_PROPERTY = "subAtlas";
    public static final String CONFIGURATION_ROOT = "global.fetchers";
    private static final long serialVersionUID = 4533389855900131531L;
    private static final Logger logger = LoggerFactory.getLogger(ConfiguredAtlasFetcher.class);
    private static final String CONFIGURATION_INPUT_DEPENDENCY = "inputDependency";
    private static final String CONFIGURATION_SUBATLAS = "subAtlas";
    private static final String CONFIGURATION_ATLAS_PROVIDER = "atlasProvider";
    private final String name;
    private final String inputDependencyName;
    private final String inputDependencyPath;
    private final ConfiguredSubAtlas subAtlas;
    private final AtlasProvider atlasProvider;

    public static ConfiguredAtlasFetcher direct() {
        return new ConfiguredAtlasFetcher();
    }

    public static ConfiguredAtlasFetcher from(String name, Configuration configuration) {
        if (DEFAULT.equals(name)) {
            return ConfiguredAtlasFetcher.direct();
        }
        if (!new ConfigurationReader(CONFIGURATION_ROOT).isPresent(configuration, name)) {
            logger.warn("Attempted to create ConfiguredAtlasFetcher called \"{}\" but it was not found. It will be swapped with default passthrough fetcher.", (Object)name);
            return ConfiguredAtlasFetcher.direct();
        }
        return new ConfiguredAtlasFetcher(name, configuration);
    }

    private ConfiguredAtlasFetcher() {
        this.name = DEFAULT;
        this.inputDependencyName = "";
        this.inputDependencyPath = "";
        this.subAtlas = ConfiguredSubAtlas.UNCHANGED;
        this.atlasProvider = AtlasProvider.defaultProvider();
    }

    private ConfiguredAtlasFetcher(String name, Configuration configuration) {
        this.name = name;
        String root = "global.fetchers." + name;
        ConfigurationReader reader = new ConfigurationReader(root);
        this.inputDependencyName = (String)reader.configurationValue(configuration, CONFIGURATION_INPUT_DEPENDENCY, (Object)"");
        if (!this.inputDependencyName.isEmpty() && !new ConfigurationReader("global.inputDependencies").isPresent(configuration, this.inputDependencyName)) {
            throw new CoreException("InputDependency name \"{}\" in ConfiguredAtlasFetcher \"{}\" is missing from the input dependency list.", new Object[]{this.inputDependencyName, name});
        }
        this.inputDependencyPath = this.inputDependencyName.isEmpty() ? "" : "_inputDependency_" + this.inputDependencyName;
        this.subAtlas = ConfiguredSubAtlas.from((String)reader.configurationValue(configuration, "subAtlas", (Object)DEFAULT), configuration);
        String atlasProviderName = (String)reader.configurationValue(configuration, CONFIGURATION_ATLAS_PROVIDER, (Object)"");
        this.atlasProvider = !atlasProviderName.isEmpty() ? new ConfiguredAtlasProvider(atlasProviderName, configuration).getAtlasProvider() : AtlasProvider.defaultProvider();
    }

    public Function<Shard, Optional<Atlas>> getFetcher(String atlasPath, String country, Map<String, String> sparkConfiguration) {
        HashMap<String, Object> atlasProviderContext = new HashMap<String, Object>();
        atlasProviderContext.put("filePath", atlasPath + this.inputDependencyPath);
        atlasProviderContext.put("sparkConfiguration", sparkConfiguration);
        this.atlasProvider.setAtlasProviderContext(atlasProviderContext);
        return (Function<Shard, Optional> & Serializable)shardSource -> {
            Optional atlasOption = (Optional)this.atlasProvider.apply(country, shardSource);
            if (atlasOption.isPresent()) {
                return this.subAtlas.apply((Atlas)atlasOption.get());
            }
            return Optional.empty();
        };
    }

    public Optional<String> getInputDependencyName() {
        return "".equals(this.inputDependencyName) ? Optional.empty() : Optional.of(this.inputDependencyName);
    }

    public String getName() {
        return this.name;
    }

    public ConfiguredSubAtlas getSubAtlas() {
        return this.subAtlas;
    }

    public JsonObject toJson() {
        JsonObject fetcherObject = new JsonObject();
        fetcherObject.addProperty("type", TYPE_JSON_PROPERTY_VALUE);
        fetcherObject.addProperty(NAME_JSON_PROPERTY, this.name);
        if (this.inputDependencyName != null && !this.inputDependencyName.isEmpty()) {
            fetcherObject.addProperty(INPUT_DEPENDENCY_NAME_JSON_PROPERTY, this.inputDependencyName);
        }
        if (this.inputDependencyPath != null && !this.inputDependencyPath.isEmpty()) {
            fetcherObject.addProperty(INPUT_DEPENDENCY_PATH_JSON_PROPERTY, this.inputDependencyPath);
        }
        if (this.subAtlas != null) {
            fetcherObject.addProperty("subAtlas", this.subAtlas.getName());
        }
        return fetcherObject;
    }

    public String toString() {
        return this.name;
    }
}

