/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.mutator.configuration.parsing;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.openstreetmap.atlas.geography.atlas.change.AtlasChangeGenerator;
import org.openstreetmap.atlas.mutator.configuration.mutators.ConfiguredAtlasChangeGenerator;
import org.openstreetmap.atlas.mutator.configuration.mutators.ConfiguredAtlasChangeGeneratorBuilder;
import org.openstreetmap.atlas.utilities.configuration.Configuration;
import org.openstreetmap.atlas.utilities.configuration.StandardConfiguration;
import org.openstreetmap.atlas.utilities.graphs.DirectedAcyclicGraph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtlasMutatorIndex
implements Serializable {
    public static final String OVERRIDE_KEY = "override";
    private static final Logger logger = LoggerFactory.getLogger(AtlasMutatorIndex.class);
    private static final long serialVersionUID = -5540910714691494013L;
    private final Map<Key, ConfiguredAtlasChangeGenerator> index = new HashMap<Key, ConfiguredAtlasChangeGenerator>();
    private final transient ConfiguredAtlasChangeGeneratorBuilder configuredAtlasChangeGeneratorBuilder;

    public AtlasMutatorIndex(ConfiguredAtlasChangeGeneratorBuilder configuredAtlasChangeGeneratorBuilder) {
        this.configuredAtlasChangeGeneratorBuilder = configuredAtlasChangeGeneratorBuilder;
    }

    protected DirectedAcyclicGraph<ConfiguredAtlasChangeGenerator> getActionableDag(String country) {
        Map<String, ConfiguredAtlasChangeGenerator> filteredNameToGeneratorMap = this.filteredNameToGeneratorMap(country);
        DirectedAcyclicGraph changeGeneratorDag = new DirectedAcyclicGraph();
        for (Map.Entry<String, ConfiguredAtlasChangeGenerator> nameToGeneratorEntry : filteredNameToGeneratorMap.entrySet()) {
            ConfiguredAtlasChangeGenerator candidateGenerator = nameToGeneratorEntry.getValue();
            Set<ConfiguredAtlasChangeGenerator> dependsOn = this.dependsOn(country, candidateGenerator, filteredNameToGeneratorMap);
            boolean generatorExists = false;
            for (AtlasChangeGenerator generator : changeGeneratorDag.getTopologicalSortedList()) {
                if (!generator.getName().equals(candidateGenerator.getName())) continue;
                generatorExists = true;
            }
            if (!generatorExists) {
                changeGeneratorDag.addVertex((Object)candidateGenerator);
            }
            for (ConfiguredAtlasChangeGenerator dependency : dependsOn) {
                logger.info("{}: Added dependency: {} to {}", new Object[]{country, dependency.getName(), candidateGenerator.getName()});
                Optional<ConfiguredAtlasChangeGenerator> existingDependency = this.getGeneratorFromDag(dependency, (DirectedAcyclicGraph<ConfiguredAtlasChangeGenerator>)changeGeneratorDag);
                if (existingDependency.isPresent()) {
                    changeGeneratorDag.addEdge((Object)existingDependency.get(), (Object)candidateGenerator);
                    continue;
                }
                changeGeneratorDag.addEdge((Object)dependency, (Object)candidateGenerator);
            }
        }
        return changeGeneratorDag;
    }

    protected void populate(Set<String> countries, Set<String> mutatorNames, Configuration configuration) {
        for (String country : countries) {
            Configuration updatedConfiguration = this.updatedConfiguration(configuration, country);
            for (String mutatorName : mutatorNames) {
                this.configuredAtlasChangeGeneratorBuilder.create(country, mutatorName, updatedConfiguration).ifPresent(mutator -> this.index.put(new Key(country, mutatorName), (ConfiguredAtlasChangeGenerator)mutator));
            }
        }
    }

    protected Configuration updatedConfiguration(Configuration source, String country) {
        HashMap<String, Object> configurationMap = new HashMap<String, Object>();
        for (String key : source.configurationDataKeySet()) {
            configurationMap.put(key, source.get(key).value());
        }
        return new StandardConfiguration(source.toString(), this.updatedInternal(configurationMap, country));
    }

    private Set<ConfiguredAtlasChangeGenerator> dependsOn(String country, ConfiguredAtlasChangeGenerator candidateGenerator, Map<String, ConfiguredAtlasChangeGenerator> allGenerators) {
        HashSet<ConfiguredAtlasChangeGenerator> dependsOn = new HashSet<ConfiguredAtlasChangeGenerator>();
        String name = candidateGenerator.getName();
        for (String dependency : candidateGenerator.getDependencies()) {
            Optional<ConfiguredAtlasChangeGenerator> dependentGenerator = Optional.ofNullable(allGenerators.get(dependency));
            if (dependentGenerator.isPresent()) {
                dependsOn.add(dependentGenerator.get());
                continue;
            }
            logger.warn("{}: {} depends on {} which is not configured. The dependency will be ignored.", new Object[]{country, name, dependency});
        }
        return dependsOn;
    }

    private Map<String, ConfiguredAtlasChangeGenerator> filteredNameToGeneratorMap(String country) {
        HashMap<String, ConfiguredAtlasChangeGenerator> result = new HashMap<String, ConfiguredAtlasChangeGenerator>();
        this.index.entrySet().stream().filter(entry -> country.equals(((Key)entry.getKey()).getCountry())).forEach(entry -> result.put(((Key)entry.getKey()).getName(), (ConfiguredAtlasChangeGenerator)entry.getValue()));
        return result;
    }

    private void findOverride(Map.Entry<String, Object> entry, Map<String, Object> overrides, String country) {
        Object value;
        if (OVERRIDE_KEY.equals(entry.getKey()) && (value = entry.getValue()) instanceof HashMap) {
            HashMap countryCodes = (HashMap)value;
            for (Map.Entry countryCode : countryCodes.entrySet()) {
                Object countryValue;
                if (!country.equals(countryCode.getKey()) || !((countryValue = countryCode.getValue()) instanceof HashMap)) continue;
                HashMap overridableValues = (HashMap)countryValue;
                overrides.putAll(overridableValues);
            }
        }
    }

    private Optional<ConfiguredAtlasChangeGenerator> getGeneratorFromDag(ConfiguredAtlasChangeGenerator target, DirectedAcyclicGraph<ConfiguredAtlasChangeGenerator> dag) {
        for (ConfiguredAtlasChangeGenerator generator : dag.getTopologicalSortedList()) {
            if (!generator.getName().equals(target.getName())) continue;
            return Optional.of(generator);
        }
        return Optional.empty();
    }

    private Map<String, Object> updatedInternal(Map<String, Object> source, String country) {
        HashMap<String, Object> configurationMap = new HashMap<String, Object>();
        HashMap<String, Object> overrides = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : source.entrySet()) {
            this.findOverride(entry, overrides, country);
        }
        for (Map.Entry<String, Object> entry : source.entrySet()) {
            String key = entry.getKey();
            if (overrides.containsKey(key)) {
                configurationMap.put(key, overrides.get(key));
                continue;
            }
            Object value = entry.getValue();
            if (value instanceof HashMap) {
                HashMap subValue = (HashMap)value;
                configurationMap.put(key, this.updatedInternal(subValue, country));
                continue;
            }
            configurationMap.put(key, value);
        }
        return configurationMap;
    }

    public static class Key
    implements Serializable {
        private static final long serialVersionUID = 2519299928829644206L;
        private final String country;
        private final String name;

        public Key(String country, String name) {
            this.country = country;
            this.name = name;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            Key key = (Key)other;
            return this.getCountry().equals(key.getCountry()) && this.getName().equals(key.getName());
        }

        public String getCountry() {
            return this.country;
        }

        public String getName() {
            return this.name;
        }

        public int hashCode() {
            return Objects.hash(this.getCountry(), this.getName());
        }
    }
}

