/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.mutator.configuration.parsing;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.openstreetmap.atlas.mutator.configuration.AtlasMutationLevel;
import org.openstreetmap.atlas.mutator.configuration.AtlasMutatorConfiguration;
import org.openstreetmap.atlas.mutator.configuration.mutators.ConfiguredAtlasChangeGenerator;
import org.openstreetmap.atlas.mutator.configuration.mutators.ConfiguredAtlasChangeGeneratorBuilder;
import org.openstreetmap.atlas.mutator.configuration.parsing.AtlasMutatorIndex;
import org.openstreetmap.atlas.utilities.collections.Sets;
import org.openstreetmap.atlas.utilities.configuration.Configuration;
import org.openstreetmap.atlas.utilities.graphs.DirectedAcyclicGraph;
import org.openstreetmap.atlas.utilities.maps.MultiMapWithSet;
import org.openstreetmap.atlas.utilities.tuples.Tuple;

public class AtlasMutatorConfigurationParser {
    public static final String CONFIGURATION_GLOBAL = "global";
    private final AtlasMutatorConfiguration atlasMutatorConfiguration;
    private final ConfiguredAtlasChangeGeneratorBuilder configuredAtlasChangeGeneratorBuilder;
    private final Configuration mutatorsConfiguration;

    static Map<String, List<AtlasMutationLevel>> coalesce(Map<String, List<AtlasMutationLevel>> countryToMutationLevels) {
        AtomicInteger identifierGenerator = new AtomicInteger();
        HashMap<String, List<AtlasMutationLevel>> groups = new HashMap<String, List<AtlasMutationLevel>>();
        for (Map.Entry<String, List<AtlasMutationLevel>> entry : countryToMutationLevels.entrySet()) {
            String keyToRemove = null;
            Tuple entryToAdd = null;
            for (Map.Entry groupEntry : groups.entrySet()) {
                List<AtlasMutationLevel> merged = AtlasMutatorConfigurationParser.isSimilar(identifierGenerator, (List)groupEntry.getValue(), entry.getValue(), (String)groupEntry.getKey());
                if (merged.isEmpty()) continue;
                keyToRemove = (String)groupEntry.getKey();
                String key = merged.get(0).getCountryGroup();
                entryToAdd = new Tuple((Object)key, merged);
                break;
            }
            if (keyToRemove != null) {
                groups.remove(keyToRemove);
                groups.put((String)entryToAdd.getFirst(), (List)entryToAdd.getSecond());
                continue;
            }
            groups.put(entry.getKey(), entry.getValue());
        }
        return groups;
    }

    private static List<AtlasMutationLevel> isSimilar(AtomicInteger identifierGenerator, List<AtlasMutationLevel> levelList1, List<AtlasMutationLevel> levelList2, String groupNameOption) {
        ArrayList<AtlasMutationLevel> result = new ArrayList<AtlasMutationLevel>();
        if (levelList1.size() != levelList2.size()) {
            return result;
        }
        for (int index = 0; index < levelList1.size(); ++index) {
            if (levelList1.get(index).isSimilarTo(levelList2.get(index))) continue;
            return result;
        }
        Object groupName = groupNameOption.startsWith("GROUP") ? groupNameOption : "GROUP" + identifierGenerator.getAndIncrement();
        for (int index = 0; index < levelList1.size(); ++index) {
            result.add(levelList1.get(index).merge(levelList2.get(index), (String)groupName));
        }
        return result;
    }

    public AtlasMutatorConfigurationParser(AtlasMutatorConfiguration atlasMutatorConfiguration, Configuration mutatorsConfiguration, Map<String, String> sparkConfiguration) {
        this.atlasMutatorConfiguration = atlasMutatorConfiguration;
        this.mutatorsConfiguration = mutatorsConfiguration;
        this.configuredAtlasChangeGeneratorBuilder = new ConfiguredAtlasChangeGeneratorBuilder(mutatorsConfiguration, sparkConfiguration);
    }

    public Map<String, List<AtlasMutationLevel>> generateCountryToMutationLevels(Set<String> countries, boolean groupCountries, boolean allowRDD, boolean preloadRDD) {
        AtlasMutatorIndex index = new AtlasMutatorIndex(this.configuredAtlasChangeGeneratorBuilder);
        Set<String> mutatorNames = this.mutatorsConfiguration.configurationDataKeySet().stream().filter(value -> !CONFIGURATION_GLOBAL.equals(value)).collect(Collectors.toSet());
        index.populate(countries, mutatorNames, this.mutatorsConfiguration);
        HashMap countryToDagMap = new HashMap();
        countries.forEach(country -> {
            DirectedAcyclicGraph<ConfiguredAtlasChangeGenerator> actionableDag = index.getActionableDag((String)country);
            if (!actionableDag.getSources().isEmpty()) {
                countryToDagMap.put(country, index.getActionableDag((String)country));
            }
        });
        HashMap<String, List<AtlasMutationLevel>> result = new HashMap<String, List<AtlasMutationLevel>>();
        for (Map.Entry countryToDagMapEntry : countryToDagMap.entrySet()) {
            String country2 = (String)countryToDagMapEntry.getKey();
            DirectedAcyclicGraph dag = (DirectedAcyclicGraph)countryToDagMapEntry.getValue();
            List<Set<ConfiguredAtlasChangeGenerator>> atlasChangeGeneratorsGroups = this.splitAccordingToDynamicAtlasPolicies(dag.processGroups(), (DirectedAcyclicGraph<ConfiguredAtlasChangeGenerator>)dag);
            int maximumLevelIndex = atlasChangeGeneratorsGroups.size() - 1;
            int levelIndex = 0;
            ArrayList<AtlasMutationLevel> levels = new ArrayList<AtlasMutationLevel>();
            for (Set<ConfiguredAtlasChangeGenerator> generatorGroup : atlasChangeGeneratorsGroups) {
                AtlasMutationLevel level = new AtlasMutationLevel(this.atlasMutatorConfiguration, country2, Sets.hashSet((Object[])new String[]{country2}), generatorGroup, levelIndex, maximumLevelIndex);
                level.setAllowRDD(allowRDD);
                level.setPreloadRDD(preloadRDD);
                levels.add(level);
                if (levelIndex > 0) {
                    AtlasMutationLevel parent = (AtlasMutationLevel)levels.get(levelIndex - 1);
                    level.notifyOfParentLevel(parent);
                    parent.notifyOfChildLevel(level);
                }
                ++levelIndex;
            }
            result.put(country2, levels);
        }
        if (groupCountries) {
            return AtlasMutatorConfigurationParser.coalesce(result);
        }
        return result;
    }

    private boolean parentsAlreadyProcessedBeforeThisLevel(ConfiguredAtlasChangeGenerator mutator, int levelIndex, List<Set<ConfiguredAtlasChangeGenerator>> result, DirectedAcyclicGraph<ConfiguredAtlasChangeGenerator> dag) {
        Set parents = dag.getParents((Object)mutator);
        ArrayList<ConfiguredAtlasChangeGenerator> allProcessed = new ArrayList<ConfiguredAtlasChangeGenerator>();
        for (int i = 0; i < levelIndex; ++i) {
            Set<ConfiguredAtlasChangeGenerator> level = result.get(i);
            allProcessed.addAll(level);
        }
        return allProcessed.containsAll(parents);
    }

    private List<Set<ConfiguredAtlasChangeGenerator>> splitAccordingToDynamicAtlasPolicies(List<Set<ConfiguredAtlasChangeGenerator>> atlasChangeGeneratorsGroups, DirectedAcyclicGraph<ConfiguredAtlasChangeGenerator> dag) {
        ArrayList<Set<ConfiguredAtlasChangeGenerator>> result = new ArrayList<Set<ConfiguredAtlasChangeGenerator>>();
        Set sources = dag.getSources();
        HashMap<Tuple, Integer> expansionPolicyToLevelIndex = new HashMap<Tuple, Integer>();
        int levelIndex = 0;
        for (Set<ConfiguredAtlasChangeGenerator> generatorGroup : atlasChangeGeneratorsGroups) {
            MultiMapWithSet generationApplicationToMutator = new MultiMapWithSet();
            for (ConfiguredAtlasChangeGenerator mutator : generatorGroup) {
                Tuple generationApplicationTuple = new Tuple((Object)mutator.getDynamicAtlasPolicyGeneration(), (Object)mutator.getDynamicAtlasPolicyApplication());
                Integer matchingDynamicPolicyLevelIndex = (Integer)expansionPolicyToLevelIndex.get(generationApplicationTuple);
                if (matchingDynamicPolicyLevelIndex == null) {
                    generationApplicationToMutator.add((Object)generationApplicationTuple, (Object)mutator);
                    continue;
                }
                if (sources.contains(mutator) || this.parentsAlreadyProcessedBeforeThisLevel(mutator, matchingDynamicPolicyLevelIndex, result, dag)) {
                    Set mutationsOnLevel = (Set)result.get(matchingDynamicPolicyLevelIndex);
                    mutationsOnLevel.add(mutator);
                    result.set(matchingDynamicPolicyLevelIndex, mutationsOnLevel);
                    continue;
                }
                generationApplicationToMutator.add((Object)generationApplicationTuple, (Object)mutator);
            }
            TreeSet sortedMutatorGroups = new TreeSet((setLeft, setRight) -> {
                SortedSet namesLeft = setLeft.stream().map(ConfiguredAtlasChangeGenerator::getName).collect(Collectors.toCollection(TreeSet::new));
                SortedSet namesRight = setRight.stream().map(ConfiguredAtlasChangeGenerator::getName).collect(Collectors.toCollection(TreeSet::new));
                StringBuilder nameLeft = new StringBuilder();
                namesLeft.forEach(nameLeft::append);
                StringBuilder nameRight = new StringBuilder();
                namesRight.forEach(nameRight::append);
                return nameLeft.toString().compareTo(nameRight.toString());
            });
            sortedMutatorGroups.addAll(generationApplicationToMutator.values());
            for (Set mutatorGroup : sortedMutatorGroups) {
                result.add(mutatorGroup);
                ConfiguredAtlasChangeGenerator mutator = (ConfiguredAtlasChangeGenerator)mutatorGroup.iterator().next();
                Tuple generationApplicationTuple = new Tuple((Object)mutator.getDynamicAtlasPolicyGeneration(), (Object)mutator.getDynamicAtlasPolicyApplication());
                expansionPolicyToLevelIndex.put(generationApplicationTuple, levelIndex);
                ++levelIndex;
            }
        }
        return result;
    }
}

