/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.mutator.configuration.mutators.aql.config;

import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.openstreetmap.atlas.geography.atlas.dsl.authentication.Authenticator;
import org.openstreetmap.atlas.mutator.configuration.mutators.aql.config.AqlConfigInfo;
import org.openstreetmap.atlas.mutator.configuration.mutators.aql.config.SecureAqlConfigInfoBuilder;

public class SecureAqlConfigInfo
implements AqlConfigInfo {
    private static final long serialVersionUID = 834193230487629948L;
    private final String embeddedAql;
    private final String embeddedAqlSignature;

    public static SecureAqlConfigInfoBuilder builder(Authenticator authenticator) {
        return new SecureAqlConfigInfoBuilder(authenticator);
    }

    SecureAqlConfigInfo(String embeddedAql, String embeddedAqlSignature) {
        this.embeddedAql = embeddedAql;
        this.embeddedAqlSignature = embeddedAqlSignature;
    }

    public boolean equals(Object other) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)other, (String[])new String[0]);
    }

    @Override
    public String getEmbeddedAql() {
        return this.embeddedAql;
    }

    @Override
    public String getEmbeddedAqlSignature() {
        return this.embeddedAqlSignature;
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
    }

    public String toString() {
        return "SecureAqlConfigInfo(embeddedAql=" + this.getEmbeddedAql() + ", embeddedAqlSignature=" + this.getEmbeddedAqlSignature() + ")";
    }

    void structuralValidation() {
        Validate.notEmpty((CharSequence)this.embeddedAql, (String)"embeddedAql is EMPTY. %s.", (Object[])new Object[]{this});
        Validate.notEmpty((CharSequence)this.embeddedAqlSignature, (String)"embeddedAqlSignature is EMPTY. %s.", (Object[])new Object[]{this});
    }

    void validateSignature(Authenticator authenticator) {
        authenticator.verify(this.embeddedAql, this.embeddedAqlSignature);
    }
}

