/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.mutator.configuration.mutators.aql.config;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.openstreetmap.atlas.mutator.configuration.mutators.aql.config.AqlConfigHelper;

public class AbstractAqlConfigBuilder<B extends AbstractAqlConfigBuilder<B>> {
    private String embeddedAql;
    private String embeddedAqlSignature;

    public B embeddedAql(String paramEmbeddedAql) {
        if (paramEmbeddedAql == null) {
            return this.self();
        }
        Validate.isTrue((boolean)StringUtils.isEmpty((CharSequence)this.embeddedAql), (String)"Embedded AQL is already set: [%s]; while trying to set: [%s]", (Object[])new Object[]{this.embeddedAql, paramEmbeddedAql});
        this.embeddedAql = paramEmbeddedAql;
        return this.self();
    }

    public B embeddedAqlSignature(String paramEmbeddedAqlSignature) {
        if (paramEmbeddedAqlSignature != null) {
            this.embeddedAqlSignature = paramEmbeddedAqlSignature;
        }
        return this.self();
    }

    public B externalAqlClasspath(String externalAqlClasspath) {
        if (externalAqlClasspath == null) {
            return this.self();
        }
        Validate.isTrue((boolean)StringUtils.isEmpty((CharSequence)this.embeddedAql), (String)"Either embeddedAql: [%s] OR externalAqlClasspath: [%s] can be provided per query but not both.", (Object[])new Object[]{this.embeddedAql, externalAqlClasspath});
        String extractedEmbeddedAql = AqlConfigHelper.loadAqlFromClasspath(externalAqlClasspath);
        String extractedEmbeddedAqlSignature = AqlConfigHelper.loadAqlSignatureFromClasspath(externalAqlClasspath);
        return ((AbstractAqlConfigBuilder)this.embeddedAql(extractedEmbeddedAql)).embeddedAqlSignature(extractedEmbeddedAqlSignature);
    }

    public String getEmbeddedAql() {
        return this.embeddedAql;
    }

    public String getEmbeddedAqlSignature() {
        return this.embeddedAqlSignature;
    }

    private B self() {
        return (B)this;
    }
}

