/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.mutator.configuration.mutators.aql;

import java.util.List;
import org.apache.commons.lang3.Validate;
import org.openstreetmap.atlas.geography.atlas.dsl.authentication.Authenticator;
import org.openstreetmap.atlas.geography.atlas.dsl.authentication.impl.SHA512HMACAuthenticatorImpl;
import org.openstreetmap.atlas.geography.atlas.dsl.engine.QueryExecutor;
import org.openstreetmap.atlas.geography.atlas.dsl.engine.impl.SecureQueryExecutorImpl;
import org.openstreetmap.atlas.mutator.configuration.mutators.aql.AbstractAqlChangeGenerator;
import org.openstreetmap.atlas.mutator.configuration.mutators.aql.config.AqlConfigInfo;
import org.openstreetmap.atlas.mutator.configuration.mutators.aql.config.SecureAqlConfigInfo;
import org.openstreetmap.atlas.mutator.configuration.mutators.aql.config.SecureAqlConfigInfoBuilder;
import org.openstreetmap.atlas.utilities.configuration.Configuration;

public class SecureAqlChangeGenerator
extends AbstractAqlChangeGenerator {
    public SecureAqlChangeGenerator(String name, Configuration configuration) {
        super(name, configuration);
    }

    public SecureAqlChangeGenerator(String name, Configuration configuration, List<AqlConfigInfo> aqlConfigInfos) {
        super(name, configuration, aqlConfigInfos);
    }

    @Override
    public Authenticator getAuthenticator() {
        String secret = System.getProperty("aqlKey");
        Validate.notEmpty((CharSequence)secret, (String)"The secret is empty. Please ste a system parameter [%s].", (Object[])new Object[]{"aqlKey"});
        return new SHA512HMACAuthenticatorImpl(secret);
    }

    @Override
    public QueryExecutor getQueryExecutor() {
        return new SecureQueryExecutorImpl();
    }

    @Override
    protected AqlConfigInfo toAqlConfigInfo(Authenticator authenticator, String query, String queryClasspath, String signature) {
        return ((SecureAqlConfigInfoBuilder)((SecureAqlConfigInfoBuilder)((SecureAqlConfigInfoBuilder)SecureAqlConfigInfo.builder(authenticator).externalAqlClasspath(queryClasspath)).embeddedAql(query)).embeddedAqlSignature(signature)).build();
    }
}

