/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.mutator.configuration.mutators.aql;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.change.Change;
import org.openstreetmap.atlas.geography.atlas.change.FeatureChange;
import org.openstreetmap.atlas.geography.atlas.dsl.authentication.Authenticator;
import org.openstreetmap.atlas.geography.atlas.dsl.engine.QueryExecutor;
import org.openstreetmap.atlas.geography.atlas.dsl.query.result.MutantResult;
import org.openstreetmap.atlas.geography.atlas.dsl.query.result.Result;
import org.openstreetmap.atlas.mutator.configuration.mutators.ConfiguredAtlasChangeGenerator;
import org.openstreetmap.atlas.mutator.configuration.mutators.aql.AqlSupportedAtlasChangeGenerator;
import org.openstreetmap.atlas.mutator.configuration.mutators.aql.config.AqlConfigInfo;
import org.openstreetmap.atlas.utilities.configuration.Configurable;
import org.openstreetmap.atlas.utilities.configuration.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAqlChangeGenerator
extends ConfiguredAtlasChangeGenerator
implements AqlSupportedAtlasChangeGenerator {
    private static final Logger log = LoggerFactory.getLogger(AbstractAqlChangeGenerator.class);
    private static final long serialVersionUID = 8363380396415344618L;
    private final List<AqlConfigInfo> aqlConfigInfos;

    public AbstractAqlChangeGenerator(String name, Configuration configuration) {
        super(name, configuration);
        this.aqlConfigInfos = this.loadAqlConfig(this.getAuthenticator(), name, configuration);
    }

    public AbstractAqlChangeGenerator(String name, Configuration configuration, List<AqlConfigInfo> aqlConfigInfos) {
        super(name, configuration);
        this.aqlConfigInfos = aqlConfigInfos;
    }

    @Override
    public boolean equals(Object other) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)other, (String[])new String[0]);
    }

    public Set<FeatureChange> generateWithoutValidation(Atlas atlas) {
        QueryExecutor queryExecutor = this.getQueryExecutor();
        Validate.notEmpty(this.aqlConfigInfos, (String)"aqlConfigInfos is EMPTY!", (Object[])new Object[0]);
        return this.aqlConfigInfos.stream().map(aqlConfigInfo -> this.executeAql(atlas, queryExecutor, (AqlConfigInfo)aqlConfigInfo)).map(result -> (MutantResult)result).map(MutantResult::getChange).flatMap(Change::changes).collect(Collectors.toSet());
    }

    @Override
    public List<AqlConfigInfo> getAqlConfigInfos() {
        return Collections.unmodifiableList(this.aqlConfigInfos);
    }

    @Override
    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
    }

    public List<AqlConfigInfo> loadAqlConfig(Authenticator authenticator, String name, Configuration configuration) {
        Configurable configurable = configuration.get(name);
        return this.loadAqlConfig(authenticator, name, configurable);
    }

    protected boolean canEqual(Object other) {
        return other instanceof AbstractAqlChangeGenerator;
    }

    protected abstract AqlConfigInfo toAqlConfigInfo(Authenticator var1, String var2, String var3, String var4);

    private Result executeAql(Atlas atlas, QueryExecutor queryExecutor, AqlConfigInfo aqlConfigInfo) {
        String embeddedAql = aqlConfigInfo.getEmbeddedAql();
        String embeddedAqlSignature = aqlConfigInfo.getEmbeddedAqlSignature();
        log.info("embeddedAql: {}; embeddedAqlSignature: {}.", (Object)embeddedAql, (Object)embeddedAqlSignature);
        return queryExecutor.exec(atlas, embeddedAql, embeddedAqlSignature);
    }

    private List<AqlConfigInfo> loadAqlConfig(Authenticator authenticator, String name, Configurable configurable) {
        Map configParams = (Map)configurable.value();
        log.info("loadAqlConfig: {}; class: {}.", (Object)configParams, configParams.getClass());
        Map aqlSection = (Map)configParams.get("aql");
        Validate.notEmpty((Map)aqlSection, (String)"embeddedAql: missing or empty in %s.", (Object[])new Object[]{name});
        List queriesSection = (List)aqlSection.get("queries");
        Validate.notEmpty((Map)aqlSection, (String)"embeddedAql -> queries: missing or empty in %s.", (Object[])new Object[]{name});
        return queriesSection.stream().map(configMapSection -> this.toAqlConfigInfo(authenticator, (Map<String, Object>)configMapSection)).collect(Collectors.toList());
    }

    private AqlConfigInfo toAqlConfigInfo(Authenticator authenticator, Map<String, Object> configMap) {
        String queryClasspath = (String)configMap.get("queryClasspath");
        String query = (String)configMap.get("query");
        String signature = (String)configMap.get("signature");
        return this.toAqlConfigInfo(authenticator, query, queryClasspath, signature);
    }
}

