/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.mutator.configuration.mutators;

import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.atlas.change.AtlasChangeGenerator;
import org.openstreetmap.atlas.mutator.configuration.ConfiguredObjectBuilder;
import org.openstreetmap.atlas.mutator.configuration.mutators.BasicConfiguredAtlasChangeGenerator;
import org.openstreetmap.atlas.mutator.configuration.mutators.ConfiguredAtlasChangeGenerator;
import org.openstreetmap.atlas.utilities.configuration.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfiguredAtlasChangeGeneratorBuilder
extends ConfiguredObjectBuilder {
    private static final Logger logger = LoggerFactory.getLogger(ConfiguredAtlasChangeGeneratorBuilder.class);

    public ConfiguredAtlasChangeGeneratorBuilder(Configuration configuration, Map<String, String> sparkConfiguration) {
        super(configuration, sparkConfiguration);
    }

    public Optional<ConfiguredAtlasChangeGenerator> create(String country, String mutatorName, Configuration configuration) {
        try {
            String className = this.getClassName(mutatorName);
            Class<?> clazz = this.getClass(mutatorName);
            Optional<ConfiguredAtlasChangeGenerator> result = this.temporaryConfiguredAtlasChangeGenerator(clazz, className, mutatorName, configuration, country);
            return result.filter(candidate -> this.isUsable((ConfiguredAtlasChangeGenerator)candidate, country));
        }
        catch (Exception e) {
            throw new CoreException("Cannot instantiate AtlasChangeGenerator {} for {}", new Object[]{mutatorName, country, e});
        }
    }

    private boolean isUsable(ConfiguredAtlasChangeGenerator candidate, String country) {
        candidate.setSparkConfiguration(this.getSparkConfiguration());
        Set<String> candidateCountries = candidate.getCountries();
        Set<String> candidateExcludedCountries = candidate.getExcludedCountries();
        if (candidateCountries.isEmpty() ? candidateExcludedCountries.contains(country) : !candidateCountries.contains(country) || candidateExcludedCountries.contains(country)) {
            return false;
        }
        return candidate.isEnabled();
    }

    private Optional<ConfiguredAtlasChangeGenerator> temporaryConfiguredAtlasChangeGenerator(Class<?> clazz, String className, String mutatorName, Configuration configuration, String country) throws NoSuchMethodException, IllegalAccessException, InstantiationException, InvocationTargetException {
        ConfiguredAtlasChangeGenerator result = null;
        if (clazz == null) {
            logger.error("Unable to recognize mutation. Class {} not found for {}.", (Object)className, (Object)mutatorName);
        } else if (ConfiguredAtlasChangeGenerator.class.isAssignableFrom(clazz)) {
            result = (ConfiguredAtlasChangeGenerator)clazz.getConstructor(String.class, Configuration.class).newInstance(mutatorName, configuration);
        } else if (AtlasChangeGenerator.class.isAssignableFrom(clazz)) {
            AtlasChangeGenerator source = (AtlasChangeGenerator)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            result = new BasicConfiguredAtlasChangeGenerator(className, source, configuration);
        } else {
            this.verifyDisabled(mutatorName, country, configuration);
        }
        return Optional.ofNullable(result);
    }

    private void verifyDisabled(String mutatorName, String country, Configuration configuration) {
        BasicConfiguredAtlasChangeGenerator noOp = BasicConfiguredAtlasChangeGenerator.noOp(mutatorName, configuration);
        String message = "Mutator {} was defined in the configuration, but could not be created for {}.{}";
        if (noOp.isEnabled()) {
            throw new CoreException("Mutator {} was defined in the configuration, but could not be created for {}.{}", new Object[]{mutatorName, country, ""});
        }
        logger.warn("Mutator {} was defined in the configuration, but could not be created for {}.{}", new Object[]{mutatorName, country, " It is not enabled=true so it will be ignored."});
    }
}

