/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.mutator.configuration.mutators;

import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.exception.change.FeatureChangeMergeException;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.change.AtlasChangeGenerator;
import org.openstreetmap.atlas.geography.atlas.change.AtlasEntityKey;
import org.openstreetmap.atlas.geography.atlas.change.Change;
import org.openstreetmap.atlas.geography.atlas.change.ChangeAtlas;
import org.openstreetmap.atlas.geography.atlas.change.FeatureChange;
import org.openstreetmap.atlas.geography.atlas.change.FeatureChangeBoundsExpander;
import org.openstreetmap.atlas.geography.atlas.items.ItemType;
import org.openstreetmap.atlas.mutator.configuration.InputDependency;
import org.openstreetmap.atlas.mutator.configuration.broadcast.ConfiguredBroadcastable;
import org.openstreetmap.atlas.mutator.configuration.broadcast.ConfiguredBroadcastableBuilder;
import org.openstreetmap.atlas.mutator.configuration.parsing.ConfiguredDynamicAtlasPolicy;
import org.openstreetmap.atlas.mutator.configuration.parsing.mergeforgiveness.ConfiguredMergeForgivenessPolicy;
import org.openstreetmap.atlas.utilities.collections.Maps;
import org.openstreetmap.atlas.utilities.collections.StringList;
import org.openstreetmap.atlas.utilities.configuration.Configuration;
import org.openstreetmap.atlas.utilities.configuration.ConfigurationReader;
import org.openstreetmap.atlas.utilities.filters.AtlasEntityPolygonsFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ConfiguredAtlasChangeGenerator
implements AtlasChangeGenerator {
    public static final String CONFIGURATION_DEPENDENCIES = "dependsOn";
    public static final String CONFIGURATION_COUNTRIES = "countries";
    public static final String CONFIGURATION_EXCLUDED_COUNTRIES = "excludedCountries";
    public static final String CONFIGURATION_VALIDATE = "global.validate";
    public static final String CONFIGURATION_ENABLED = "enabled";
    public static final String CONFIGURATION_DYNAMIC_ATLAS_POLICY_GENERATION = "dynamicAtlas.generation";
    public static final String CONFIGURATION_DYNAMIC_ATLAS_POLICY_APPLICATION = "dynamicAtlas.application";
    public static final String CONFIGURATION_BROADCAST_VARIABLES_NEEDED = "broadcast";
    public static final String CONFIGURATION_CLASS_NAME = "className";
    public static final String TYPE_JSON_PROPERTY_VALUE = "_mutator";
    public static final String NAME_JSON_PROPERTY = "name";
    public static final String CLASS_NAME_JSON_PROPERTY = "className";
    public static final String DEPENDENCIES_JSON_PROPERTY = "dependencies";
    public static final String COUNTRIES_JSON_PROPERTY = "countries";
    public static final String EXCLUDED_COUNTRIES_JSON_PROPERTY = "excludedCountries";
    public static final String ENABLED_JSON_PROPERTY = "enabled";
    public static final String DYNAMIC_ATLAS_POLICY_GENERATION_JSON_PROPERTY = "dynamicAtlasPolicyGeneration";
    public static final String DYNAMIC_ATLAS_POLICY_APPLICATION_JSON_PROPERTY = "dynamicAtlasPolicyApplication";
    public static final String INPUT_DEPENDENCIES_JSON_PROPERTY = "inputDependencies";
    public static final String DECLARED_MERGE_FORGIVENESS_POLICY_JSON_PROPERTY = "declaredMergeForgivenessPolicy";
    public static final String BROADCAST_VARIABLES_NEEDED_JSON_PROPERTY = "broadcastVariablesNeeded";
    private static final Logger logger = LoggerFactory.getLogger(ConfiguredAtlasChangeGenerator.class);
    private static final long serialVersionUID = 2494966710390021964L;
    private final String name;
    private final Set<String> dependencies;
    private final Set<String> countries;
    private final Set<String> excludedCountries;
    private final boolean enabled;
    private final boolean validate;
    private final AtlasEntityPolygonsFilter polygonFilter;
    private final AtlasEntityPolygonsFilter globalPolygonFilter;
    private final ConfiguredDynamicAtlasPolicy dynamicAtlasPolicyGeneration;
    private final ConfiguredDynamicAtlasPolicy dynamicAtlasPolicyApplication;
    private final ConfiguredMergeForgivenessPolicy mergeForgivenessPolicy;
    private final List<InputDependency> inputDependencies;
    private final String className;
    private Map<String, String> sparkConfiguration = Maps.hashMap((Object[])new String[0]);
    private transient Map<String, Object> broadcastVariables;
    private final Map<String, ConfiguredBroadcastable> broadcastVariablesNeeded;

    public ConfiguredAtlasChangeGenerator(String name, Configuration configuration) {
        this.name = name;
        ConfigurationReader reader = new ConfigurationReader(name);
        this.dependencies = new HashSet<String>((Collection)reader.configurationValue(configuration, CONFIGURATION_DEPENDENCIES, new ArrayList()));
        this.countries = new HashSet<String>((Collection)reader.configurationValue(configuration, "countries", new ArrayList()));
        this.excludedCountries = new HashSet<String>((Collection)reader.configurationValue(configuration, "excludedCountries", new ArrayList()));
        Sets.SetView countryIntersection = Sets.intersection(this.countries, this.excludedCountries);
        if (!countryIntersection.isEmpty()) {
            throw new CoreException("{}: Included and excluded countries are overlapping for {}", new Object[]{name, countryIntersection});
        }
        this.enabled = (Boolean)reader.configurationValue(configuration, "enabled", (Object)false);
        this.className = (String)reader.configurationValue(configuration, "className", (Object)"");
        this.validate = (Boolean)new ConfigurationReader("").configurationValue(configuration, CONFIGURATION_VALIDATE, (Object)false);
        this.globalPolygonFilter = AtlasEntityPolygonsFilter.forConfiguration((Configuration)configuration);
        this.polygonFilter = AtlasEntityPolygonsFilter.forConfigurationValues((Map)((Map)reader.configurationValue(configuration, "filter.polygons.include", Collections.emptyMap())), (Map)((Map)reader.configurationValue(configuration, "filter.multipolygons.include", Collections.emptyMap())), (Map)((Map)reader.configurationValue(configuration, "filter.polygons.exclude", Collections.emptyMap())), (Map)((Map)reader.configurationValue(configuration, "filter.multipolygons.exclude", Collections.emptyMap())));
        this.dynamicAtlasPolicyGeneration = ConfiguredDynamicAtlasPolicy.from((String)reader.configurationValue(configuration, CONFIGURATION_DYNAMIC_ATLAS_POLICY_GENERATION, (Object)"default"), configuration);
        this.dynamicAtlasPolicyApplication = ConfiguredDynamicAtlasPolicy.from((String)reader.configurationValue(configuration, CONFIGURATION_DYNAMIC_ATLAS_POLICY_APPLICATION, (Object)"default"), configuration);
        this.mergeForgivenessPolicy = ConfiguredMergeForgivenessPolicy.fromRoot(configuration, this.name);
        logger.debug("For {} read mergeForgivenessPolicy\n{}", (Object)this.name, (Object)this.mergeForgivenessPolicy);
        HashSet inputDependencyNames = new HashSet();
        this.dynamicAtlasPolicyGeneration.getInputDependencyName().ifPresent(inputDependencyNames::add);
        this.dynamicAtlasPolicyApplication.getInputDependencyName().ifPresent(inputDependencyNames::add);
        this.inputDependencies = inputDependencyNames.stream().map(inputDependencyName -> new InputDependency(this, (String)inputDependencyName, configuration)).collect(Collectors.toList());
        HashSet broadcastVariableNames = new HashSet((Collection)reader.configurationValue(configuration, CONFIGURATION_BROADCAST_VARIABLES_NEEDED, new ArrayList()));
        ConfiguredBroadcastableBuilder configuredBroadcastableBuilder = new ConfiguredBroadcastableBuilder(configuration);
        this.broadcastVariablesNeeded = new HashMap<String, ConfiguredBroadcastable>();
        broadcastVariableNames.forEach(broadcastVariableName -> this.broadcastVariablesNeeded.put((String)broadcastVariableName, configuredBroadcastableBuilder.create((String)broadcastVariableName)));
    }

    public void addBroadcastVariable(String name, Object broadcastVariable) {
        if (this.broadcastVariables == null) {
            this.broadcastVariables = new HashMap<String, Object>();
        }
        this.broadcastVariables.put(name, broadcastVariable);
    }

    public boolean equals(Object other) {
        if (other instanceof ConfiguredAtlasChangeGenerator) {
            return this.getName().equals(((ConfiguredAtlasChangeGenerator)other).getName()) && this.dynamicAtlasPolicyGeneration.equals(((ConfiguredAtlasChangeGenerator)other).getDynamicAtlasPolicyGeneration()) && this.dynamicAtlasPolicyApplication.equals(((ConfiguredAtlasChangeGenerator)other).getDynamicAtlasPolicyApplication());
        }
        return false;
    }

    public Set<FeatureChange> generate(Atlas atlas) {
        HashMap<AtlasEntityKey, Integer> identifierToIndex = new HashMap<AtlasEntityKey, Integer>();
        ArrayList<FeatureChange> mergedResult = new ArrayList<FeatureChange>();
        Set rawResult = new FeatureChangeBoundsExpander(this.generateWithoutValidation(atlas), atlas).apply();
        rawResult.stream().forEach(featureChange -> featureChange.withAtlasContext(atlas));
        if (rawResult.isEmpty()) {
            return rawResult;
        }
        for (FeatureChange rawFeatureChange : rawResult) {
            int currentIndex = mergedResult.size();
            AtlasEntityKey key = AtlasEntityKey.from((ItemType)rawFeatureChange.getItemType(), (Long)rawFeatureChange.getIdentifier());
            FeatureChange resultingFeatureChange = rawFeatureChange;
            if (!identifierToIndex.containsKey(key)) {
                identifierToIndex.put(key, currentIndex);
                mergedResult.add(resultingFeatureChange);
                continue;
            }
            int existingIndex = (Integer)identifierToIndex.get(key);
            FeatureChange existing = (FeatureChange)mergedResult.get(existingIndex);
            try {
                resultingFeatureChange = existing.merge(rawFeatureChange);
            }
            catch (FeatureChangeMergeException exception) {
                Optional<FeatureChange> featureChangeFromPolicy = this.mergeForgivenessPolicy.applyPolicy(exception, existing, rawFeatureChange);
                if (featureChangeFromPolicy.isEmpty()) {
                    throw new CoreException("Conflict merging internal {}, failed to apply forgiveness policy:\n{}\nFeatureChanges:\n{}\nvs\n{}", new Object[]{this.name, this.mergeForgivenessPolicy, existing.prettify(), rawFeatureChange.prettify(), exception});
                }
                logger.warn("Conflict merging internal {}, successfully applied forgiveness policy:\n{}\nFeatureChanges:\n{}\nvs\n{}\nChose:\n{}", new Object[]{this.name, this.mergeForgivenessPolicy, existing.prettify(), rawFeatureChange.prettify(), featureChangeFromPolicy.get().prettify(), exception});
                resultingFeatureChange = featureChangeFromPolicy.get();
            }
            mergedResult.set(existingIndex, resultingFeatureChange);
        }
        return new HashSet<FeatureChange>(mergedResult);
    }

    public Map<String, ConfiguredBroadcastable> getBroadcastVariablesNeeded() {
        return this.broadcastVariablesNeeded;
    }

    public Set<String> getCountries() {
        return this.countries;
    }

    public Set<String> getDependencies() {
        return this.dependencies;
    }

    public ConfiguredDynamicAtlasPolicy getDynamicAtlasPolicyApplication() {
        return this.dynamicAtlasPolicyApplication;
    }

    public ConfiguredDynamicAtlasPolicy getDynamicAtlasPolicyGeneration() {
        return this.dynamicAtlasPolicyGeneration;
    }

    public Set<String> getExcludedCountries() {
        return this.excludedCountries;
    }

    public AtlasEntityPolygonsFilter getGlobalPolygonFilter() {
        return this.globalPolygonFilter;
    }

    public List<InputDependency> getInputDependencies() {
        return this.inputDependencies;
    }

    public ConfiguredMergeForgivenessPolicy getMergeForgivenessPolicy() {
        return this.mergeForgivenessPolicy;
    }

    public String getName() {
        return this.name;
    }

    public AtlasEntityPolygonsFilter getPolygonFilter() {
        return this.polygonFilter;
    }

    public int hashCode() {
        return Objects.hashCode(this.getName());
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public JsonObject toJson() {
        JsonObject mutatorObject = new JsonObject();
        JsonArray dependenciesArray = new JsonArray();
        JsonArray inputDependenciesArray = new JsonArray();
        JsonArray broadcastVariablesNeededArray = new JsonArray();
        mutatorObject.addProperty("type", TYPE_JSON_PROPERTY_VALUE);
        mutatorObject.addProperty(NAME_JSON_PROPERTY, this.name);
        if (!this.className.isEmpty()) {
            mutatorObject.addProperty("className", this.className);
        }
        mutatorObject.addProperty("enabled", Boolean.valueOf(this.enabled));
        mutatorObject.addProperty(DYNAMIC_ATLAS_POLICY_GENERATION_JSON_PROPERTY, this.dynamicAtlasPolicyGeneration.getName());
        mutatorObject.addProperty(DYNAMIC_ATLAS_POLICY_APPLICATION_JSON_PROPERTY, this.dynamicAtlasPolicyApplication.getName());
        if (!this.countries.isEmpty()) {
            mutatorObject.addProperty("countries", new StringList(this.countries).join(","));
        }
        if (!this.excludedCountries.isEmpty()) {
            mutatorObject.addProperty("excludedCountries", new StringList(this.excludedCountries).join(","));
        }
        for (String string : this.dependencies) {
            dependenciesArray.add((JsonElement)new JsonPrimitive(string));
        }
        if (dependenciesArray.size() > 0) {
            mutatorObject.add(DEPENDENCIES_JSON_PROPERTY, (JsonElement)dependenciesArray);
        }
        for (InputDependency inputDependency : this.inputDependencies) {
            inputDependenciesArray.add((JsonElement)new JsonPrimitive(inputDependency.getPathName()));
        }
        if (inputDependenciesArray.size() > 0) {
            mutatorObject.add(INPUT_DEPENDENCIES_JSON_PROPERTY, (JsonElement)inputDependenciesArray);
        }
        mutatorObject.addProperty(DECLARED_MERGE_FORGIVENESS_POLICY_JSON_PROPERTY, Boolean.valueOf(!this.mergeForgivenessPolicy.policyIsEmpty()));
        for (Map.Entry entry : this.broadcastVariablesNeeded.entrySet()) {
            broadcastVariablesNeededArray.add((JsonElement)new JsonPrimitive(((ConfiguredBroadcastable)entry.getValue()).getName()));
        }
        if (broadcastVariablesNeededArray.size() > 0) {
            mutatorObject.add(BROADCAST_VARIABLES_NEEDED_JSON_PROPERTY, (JsonElement)broadcastVariablesNeededArray);
        }
        return mutatorObject;
    }

    public String toString() {
        return this.getName();
    }

    public void validate(Atlas source, Change change) {
        if (this.validate) {
            new ChangeAtlas(source, new Change[]{change}).validate();
        }
    }

    protected Object getBroadcastVariable(String name) {
        Object result = this.broadcastVariables.get(name);
        if (result == null) {
            throw new CoreException("Broadcast variable not found: \"{}\"", new Object[]{name});
        }
        return result;
    }

    protected Map<String, String> getSparkConfiguration() {
        return new HashMap<String, String>(this.sparkConfiguration);
    }

    void setSparkConfiguration(Map<String, String> sparkConfiguration) {
        this.sparkConfiguration = new HashMap<String, String>(sparkConfiguration);
    }
}

