/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.mutator.configuration.broadcast;

import com.google.gson.JsonObject;
import java.io.Serializable;
import java.util.Map;
import org.openstreetmap.atlas.mutator.configuration.broadcast.Broadcastable;
import org.openstreetmap.atlas.utilities.configuration.Configuration;
import org.openstreetmap.atlas.utilities.configuration.ConfigurationReader;

public abstract class ConfiguredBroadcastable
implements Serializable,
Broadcastable {
    public static final String CONFIGURATION_ROOT = "global.broadcast";
    public static final String CONFIGURATION_BROADCASTABLE_DEFINITION = "definition";
    public static final String TYPE_JSON_PROPERTY_VALUE = "_broadcastable";
    public static final String NAME_JSON_PROPERTY = "name";
    public static final String DEFINITION_JSON_PROPERTY = "definition";
    private static final long serialVersionUID = -1489086691317053394L;
    private final String name;
    private final String definition;

    public ConfiguredBroadcastable(String name, Configuration configuration) {
        this.name = name;
        String root = "global.broadcast." + name;
        ConfigurationReader reader = new ConfigurationReader(root);
        this.definition = reader.configurationValue(configuration, "definition");
    }

    public String getDefinition() {
        return this.definition;
    }

    public String getName() {
        return this.name;
    }

    public Object read(Map<String, String> configuration) {
        return this.read(this.definition, configuration);
    }

    public JsonObject toJson() {
        JsonObject broadcastableObject = new JsonObject();
        broadcastableObject.addProperty("type", TYPE_JSON_PROPERTY_VALUE);
        broadcastableObject.addProperty(NAME_JSON_PROPERTY, this.name);
        broadcastableObject.addProperty("definition", this.definition);
        return broadcastableObject;
    }
}

